/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterFactory;

public class BooleanQueryResultView
extends QueryResultView {
    private static final BooleanQueryResultView INSTANCE = new BooleanQueryResultView();

    public static BooleanQueryResultView getInstance() {
        return INSTANCE;
    }

    private BooleanQueryResultView() {
    }

    public String getContentType() {
        return null;
    }

    @Override
    protected void renderInternal(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BooleanQueryResultWriterFactory brWriterFactory = (BooleanQueryResultWriterFactory)model.get("factory");
        BooleanQueryResultFormat brFormat = brWriterFactory.getBooleanQueryResultFormat();
        response.setStatus(200);
        this.setContentType(response, (FileFormat)brFormat);
        this.setContentDisposition(model, response, (FileFormat)brFormat);
        boolean headersOnly = (Boolean)model.get("headersOnly");
        if (!headersOnly) {
            try (ServletOutputStream out = response.getOutputStream();){
                BooleanQueryResultWriter qrWriter = brWriterFactory.getWriter((OutputStream)out);
                boolean value = (Boolean)model.get("queryResult");
                qrWriter.handleBoolean(value);
            }
            catch (QueryResultHandlerException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }
        this.logEndOfRequest(request);
    }
}

