/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.ServerInterceptor;
import org.eclipse.rdf4j.http.server.repository.RepositoryConfigRepository;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInterceptor
extends ServerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String REPOSITORY_ID_KEY = "repositoryID";
    private static final String REPOSITORY_KEY = "repository";
    private volatile RepositoryManager repositoryManager;
    private volatile String repositoryID;

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = Objects.requireNonNull(repMan, "Repository manager was null");
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse respons, Object handler) throws Exception {
        String[] pathInfo;
        String pathInfoStr = request.getPathInfo();
        this.logger.debug("path info: {}", (Object)pathInfoStr);
        this.repositoryID = null;
        if (pathInfoStr != null && !pathInfoStr.equals("/") && (pathInfo = pathInfoStr.substring(1).split("/")).length > 0) {
            this.repositoryID = pathInfo[0];
            this.logger.debug("repositoryID is '{}'", (Object)this.repositoryID);
        }
        ProtocolUtil.logRequestParameters(request);
        return super.preHandle(request, respons, handler);
    }

    @Override
    protected String getThreadName() {
        String threadName = "repositories";
        String nextRepositoryID = this.repositoryID;
        if (nextRepositoryID != null) {
            threadName = threadName + "/" + nextRepositoryID;
        }
        return threadName;
    }

    @Override
    protected void setRequestAttributes(HttpServletRequest request) throws ClientHTTPException, ServerHTTPException {
        String nextRepositoryID = this.repositoryID;
        if ("SYSTEM".equals(nextRepositoryID)) {
            request.setAttribute(REPOSITORY_ID_KEY, (Object)nextRepositoryID);
            request.setAttribute(REPOSITORY_KEY, (Object)new RepositoryConfigRepository(this.repositoryManager));
        } else if (nextRepositoryID != null) {
            try {
                Repository repository = this.repositoryManager.getRepository(nextRepositoryID);
                if (repository == null && !"PUT".equals(request.getMethod())) {
                    throw new ClientHTTPException(404, "Unknown repository: " + nextRepositoryID);
                }
                request.setAttribute(REPOSITORY_ID_KEY, (Object)nextRepositoryID);
                request.setAttribute(REPOSITORY_KEY, (Object)repository);
            }
            catch (RepositoryException | RepositoryConfigException e) {
                throw new ServerHTTPException(e.getMessage(), e);
            }
        }
    }

    public static String getRepositoryID(HttpServletRequest request) {
        return (String)request.getAttribute(REPOSITORY_ID_KEY);
    }

    public static Repository getRepository(HttpServletRequest request) {
        return (Repository)request.getAttribute(REPOSITORY_KEY);
    }

    public static RepositoryConnection getRepositoryConnection(HttpServletRequest request) {
        Repository repo = RepositoryInterceptor.getRepository(request);
        RepositoryConnection conn = repo.getConnection();
        conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        return conn;
    }
}

