/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.statements;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.springframework.web.servlet.View;

public class ExportStatementsView
implements View {
    public static final String SUBJECT_KEY = "subject";
    public static final String PREDICATE_KEY = "predicate";
    public static final String OBJECT_KEY = "object";
    public static final String CONTEXTS_KEY = "contexts";
    public static final String USE_INFERENCING_KEY = "useInferencing";
    public static final String CONNECTION_KEY = "connection";
    public static final String TRANSACTION_ID_KEY = "transactionID";
    public static final String FACTORY_KEY = "factory";
    public static final String HEADERS_ONLY = "headersOnly";
    private static final ExportStatementsView INSTANCE = new ExportStatementsView();

    public static ExportStatementsView getInstance() {
        return INSTANCE;
    }

    private ExportStatementsView() {
    }

    public String getContentType() {
        return null;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block29: {
            Resource subj = (Resource)model.get(SUBJECT_KEY);
            IRI pred = (IRI)model.get(PREDICATE_KEY);
            Value obj = (Value)model.get(OBJECT_KEY);
            Resource[] contexts = (Resource[])model.get(CONTEXTS_KEY);
            boolean useInferencing = (Boolean)model.get(USE_INFERENCING_KEY);
            boolean headersOnly = (Boolean)model.get(HEADERS_ONLY);
            RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get(FACTORY_KEY);
            RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
            try (ServletOutputStream out = response.getOutputStream();){
                RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
                response.setStatus(200);
                String mimeType = rdfFormat.getDefaultMIMEType();
                if (rdfFormat.hasCharset()) {
                    Charset charset = rdfFormat.getCharset();
                    mimeType = mimeType + "; charset=" + charset.name();
                }
                response.setContentType(mimeType);
                String filename = "statements";
                if (rdfFormat.getDefaultFileExtension() != null) {
                    filename = filename + "." + rdfFormat.getDefaultFileExtension();
                }
                response.setHeader("Content-Disposition", "attachment; filename=" + filename);
                if (headersOnly) break block29;
                try (RepositoryConnection conn = RepositoryInterceptor.getRepositoryConnection(request);){
                    conn.exportStatements(subj, pred, obj, useInferencing, (RDFHandler)rdfWriter, contexts);
                }
            }
            catch (RDFHandlerException e) {
                throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

