/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.views;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.springframework.web.servlet.View;

public class SimpleCustomResponseView
implements View {
    public static final String SC_KEY = "sc";
    public static final String CONTENT_KEY = "content";
    public static final String CONTENT_LENGTH_KEY = "contentLength";
    public static final String CONTENT_TYPE_KEY = "contentType";
    private static final int DEFAULT_SC = 200;
    private static final SimpleCustomResponseView INSTANCE = new SimpleCustomResponseView();

    public static SimpleCustomResponseView getInstance() {
        return INSTANCE;
    }

    public String getContentType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int sc = 200;
        if (model.containsKey(SC_KEY)) {
            sc = (Integer)model.get(SC_KEY);
        }
        String contentType = (String)model.get(CONTENT_TYPE_KEY);
        Integer contentLength = (Integer)model.get(CONTENT_LENGTH_KEY);
        try (InputStream content = (InputStream)model.get(CONTENT_KEY);){
            response.setStatus(sc);
            try (ServletOutputStream out = response.getOutputStream();){
                if (content != null) {
                    if (contentType != null) {
                        response.setContentType(contentType);
                    }
                    if (contentLength != null) {
                        response.setContentLength(contentLength.intValue());
                    }
                    IOUtil.transfer((InputStream)content, (OutputStream)out);
                } else {
                    response.setContentLength(0);
                }
            }
        }
    }
}

