/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Transaction {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final UUID id;
    private final Repository rep;
    private final RepositoryConnection txnConnection;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final List<Future<?>> futures = new ArrayList();

    Transaction(Repository repository) throws InterruptedException, ExecutionException {
        this.id = UUID.randomUUID();
        this.rep = repository;
        this.txnConnection = this.getTransactionConnection();
    }

    UUID getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(IsolationLevel level) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                this.txnConnection.begin(level);
                return true;
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                this.txnConnection.rollback();
                return true;
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                this.txnConnection.commit();
                return true;
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Query prepareQuery(QueryLanguage queryLn, String queryStr, String baseURI) throws InterruptedException, ExecutionException {
        Future<Query> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> this.txnConnection.prepareQuery(queryLn, queryStr, baseURI));
            this.futures.add(result);
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TupleQueryResult evaluate(TupleQuery tQuery) throws InterruptedException, ExecutionException {
        Future<TupleQueryResult> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> tQuery.evaluate());
            this.futures.add(result);
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphQueryResult evaluate(GraphQuery gQuery) throws InterruptedException, ExecutionException {
        Future<GraphQueryResult> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> gQuery.evaluate());
            this.futures.add(result);
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evaluate(BooleanQuery bQuery) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> bQuery.evaluate());
            this.futures.add(result);
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportStatements(Resource subj, IRI pred, Value obj, boolean useInferencing, RDFWriter rdfWriter, Resource ... contexts) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                this.txnConnection.exportStatements(subj, pred, obj, useInferencing, (RDFHandler)rdfWriter, contexts);
                return true;
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSize(Resource[] contexts) throws InterruptedException, ExecutionException {
        Future<Long> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> this.txnConnection.size(contexts));
            this.futures.add(result);
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(InputStream inputStream, String baseURI, RDFFormat format, boolean preserveBNodes, Resource ... contexts) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                logger.debug("executing add operation");
                try {
                    if (preserveBNodes) {
                        RDFParser parser = Rio.createParser((RDFFormat)format);
                        parser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                        RDFInserter inserter = new RDFInserter(this.txnConnection);
                        inserter.setPreserveBNodeIDs(true);
                        if (contexts.length > 0) {
                            inserter.enforceContext(contexts);
                        }
                        parser.setRDFHandler((RDFHandler)inserter);
                        parser.parse(inputStream, baseURI);
                    } else {
                        this.txnConnection.add(inputStream, baseURI, format, contexts);
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(RDFFormat contentType, InputStream inputStream, String baseURI) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                logger.debug("executing delete operation");
                RDFParser parser = Rio.createParser((RDFFormat)contentType, (ValueFactory)this.txnConnection.getValueFactory());
                parser.setRDFHandler((RDFHandler)new WildcardRDFRemover(this.txnConnection));
                parser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                try {
                    parser.parse(inputStream, baseURI);
                    return true;
                }
                catch (IOException e) {
                    logger.error("error during txn delete operation", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeUpdate(QueryLanguage queryLn, String sparqlUpdateString, String baseURI, boolean includeInferred, Dataset dataset, Map<String, Value> bindings) throws InterruptedException, ExecutionException {
        Future<Boolean> result;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            result = this.executor.submit(() -> {
                Update update = this.txnConnection.prepareUpdate(queryLn, sparqlUpdateString);
                update.setIncludeInferred(includeInferred);
                if (dataset != null) {
                    update.setDataset(dataset);
                }
                for (String bindingName : bindings.keySet()) {
                    update.setBinding(bindingName, (Value)bindings.get(bindingName));
                }
                update.execute();
                return true;
            });
            this.futures.add(result);
        }
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveOperations() {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            for (Future<?> future : this.futures) {
                if (future.isDone()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws InterruptedException, ExecutionException {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Future<Boolean> result;
                List<Future<?>> list = this.futures;
                synchronized (list) {
                    result = this.executor.submit(() -> {
                        this.txnConnection.close();
                        return true;
                    });
                    this.futures.add(result);
                }
                result.get();
            }
            finally {
                this.executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryConnection getTransactionConnection() throws InterruptedException, ExecutionException {
        Future<RepositoryConnection> future;
        List<Future<?>> list = this.futures;
        synchronized (list) {
            future = this.executor.submit(() -> {
                RepositoryConnection conn = this.rep.getConnection();
                ParserConfig config = conn.getParserConfig();
                config.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
                config.addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
                return conn;
            });
            this.futures.add(future);
        }
        return future.get();
    }

    private static class WildcardRDFRemover
    extends AbstractRDFHandler {
        private final RepositoryConnection conn;

        public WildcardRDFRemover(RepositoryConnection conn) {
            this.conn = conn;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            Resource subject = SESAME.WILDCARD.equals((Object)st.getSubject()) ? null : st.getSubject();
            IRI predicate = SESAME.WILDCARD.equals((Object)st.getPredicate()) ? null : st.getPredicate();
            Value object = SESAME.WILDCARD.equals((Object)st.getObject()) ? null : st.getObject();
            boolean clearAllTriples = subject == null && predicate == null && object == null;
            try {
                Resource context = st.getContext();
                if (context != null) {
                    if (clearAllTriples) {
                        this.conn.clear(new Resource[]{context});
                    } else {
                        this.conn.remove(subject, predicate, object, new Resource[]{context});
                    }
                } else if (clearAllTriples) {
                    this.conn.clear(new Resource[0]);
                } else {
                    this.conn.remove(subject, predicate, object, new Resource[0]);
                }
            }
            catch (RepositoryException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }
}

