/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ActiveTransactionRegistry {
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(ActiveTransactionRegistry.class);
    public static final String CACHE_TIMEOUT_PROPERTY = "rdf4j.server.txn.registry.timeout";
    public static final int DEFAULT_TIMEOUT = 60;
    private final Cache<UUID, CacheEntry> primaryCache;
    private final Cache<UUID, CacheEntry> secondaryCache;

    private ActiveTransactionRegistry() {
        int timeout = 60;
        String configuredValue = System.getProperty(CACHE_TIMEOUT_PROPERTY);
        if (configuredValue != null) {
            try {
                timeout = Integer.parseInt(configuredValue);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Expected integer value for property {}. Timeout will default to {} seconds. ", (Object)CACHE_TIMEOUT_PROPERTY, (Object)60);
            }
        }
        this.primaryCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<UUID, CacheEntry>(){

            public void onRemoval(RemovalNotification<UUID, CacheEntry> notification) {
                CacheEntry entry = (CacheEntry)notification.getValue();
                try {
                    entry.getConnection().close();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }).build();
        this.secondaryCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<UUID, CacheEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<UUID, CacheEntry> notification) {
                if (RemovalCause.EXPIRED.equals((Object)notification.getCause())) {
                    UUID transactionId = (UUID)notification.getKey();
                    CacheEntry entry = (CacheEntry)notification.getValue();
                    Cache cache = ActiveTransactionRegistry.this.primaryCache;
                    synchronized (cache) {
                        if (!entry.getLock().isLocked()) {
                            ActiveTransactionRegistry.this.primaryCache.invalidate((Object)transactionId);
                            ActiveTransactionRegistry.this.logger.warn("deregistered expired transaction {}", (Object)transactionId);
                        } else {
                            ActiveTransactionRegistry.this.secondaryCache.put((Object)transactionId, (Object)entry);
                        }
                    }
                }
            }
        }).expireAfterAccess((long)timeout, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UUID transactionId, RepositoryConnection conn) throws RepositoryException {
        Cache<UUID, CacheEntry> cache = this.primaryCache;
        synchronized (cache) {
            if (this.primaryCache.getIfPresent((Object)transactionId) != null) {
                this.logger.error("transaction already registered: {}", (Object)transactionId);
                throw new RepositoryException("transaction with id " + transactionId.toString() + " already registered.");
            }
            CacheEntry cacheEntry = new CacheEntry(conn);
            this.primaryCache.put((Object)transactionId, (Object)cacheEntry);
            this.secondaryCache.put((Object)transactionId, (Object)cacheEntry);
            this.logger.debug("registered transaction {} ", (Object)transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(UUID transactionId) throws RepositoryException {
        Cache<UUID, CacheEntry> cache = this.primaryCache;
        synchronized (cache) {
            CacheEntry entry = (CacheEntry)this.primaryCache.getIfPresent((Object)transactionId);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transactionId.toString() + " not registered.");
            }
            this.primaryCache.invalidate((Object)transactionId);
            this.secondaryCache.invalidate((Object)transactionId);
            this.logger.debug("deregistered transaction {}", (Object)transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection getTransactionConnection(UUID transactionId) throws RepositoryException, InterruptedException {
        ReentrantLock txnLock = null;
        Cache<UUID, CacheEntry> cache = this.primaryCache;
        synchronized (cache) {
            CacheEntry entry = (CacheEntry)this.primaryCache.getIfPresent((Object)transactionId);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transactionId.toString() + " not registered.");
            }
            txnLock = entry.getLock();
        }
        txnLock.lockInterruptibly();
        CacheEntry entry = (CacheEntry)this.primaryCache.getIfPresent((Object)transactionId);
        if (entry == null) {
            throw new RepositoryException("transaction with id " + transactionId + " is no longer registered!");
        }
        this.updateSecondaryCache(transactionId, entry);
        return entry.getConnection();
    }

    public void returnTransactionConnection(UUID transactionId) {
        CacheEntry entry = (CacheEntry)this.primaryCache.getIfPresent((Object)transactionId);
        if (entry != null) {
            this.updateSecondaryCache(transactionId, entry);
            ReentrantLock txnLock = entry.getLock();
            if (txnLock.isHeldByCurrentThread()) {
                txnLock.unlock();
            }
        }
    }

    private void updateSecondaryCache(UUID transactionId, final CacheEntry entry) {
        try {
            this.secondaryCache.get((Object)transactionId, (Callable)new Callable<CacheEntry>(){

                @Override
                public CacheEntry call() throws Exception {
                    return entry;
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static class CacheEntry {
        private final RepositoryConnection connection;
        private final ReentrantLock lock = new ReentrantLock();

        public CacheEntry(RepositoryConnection connection) {
            this.connection = connection;
        }

        public RepositoryConnection getConnection() {
            return this.connection;
        }

        public ReentrantLock getLock() {
            return this.lock;
        }
    }
}

