/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.navigation;

import java.io.IOException;
import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.rdf4j.common.webapp.navigation.Group;
import org.eclipse.rdf4j.common.webapp.navigation.NavigationModel;
import org.eclipse.rdf4j.common.webapp.navigation.NavigationNode;
import org.eclipse.rdf4j.common.webapp.navigation.View;
import org.eclipse.rdf4j.common.xml.DocumentUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NavigationXmlParser {
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public NavigationModel parse(URL navigationXml) {
        NavigationModel result = new NavigationModel();
        this.parseInto(result, navigationXml);
        return result;
    }

    public void parseInto(NavigationModel result, URL navigationXml) {
        try {
            Document document = DocumentUtil.getDocument((URL)navigationXml);
            Node rootNode = (Node)this.xpath.evaluate("/navigation", document, XPathConstants.NODE);
            this.fillModel(result, rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void fillModel(NavigationModel result, Node modelNode) throws XPathExpressionException {
        String i18nSuffix;
        String i18nSeparator;
        String i18nPrefix;
        String iconSuffix;
        String iconSeparator;
        String iconPrefix;
        String pathSeparator;
        String id = this.xpath.evaluate("@id", modelNode);
        result.setId(id);
        String pathPrefix = this.xpath.evaluate("path-prefix", modelNode);
        if (!"".equals(pathPrefix)) {
            result.setPathPrefix(pathPrefix);
        }
        if (!"".equals(pathSeparator = this.xpath.evaluate("path-separator", modelNode))) {
            result.setPathSeparator(pathSeparator);
        }
        if (!"".equals(iconPrefix = this.xpath.evaluate("icon-prefix", modelNode))) {
            result.setIconPrefix(iconPrefix);
        }
        if (!"".equals(iconSeparator = this.xpath.evaluate("icon-separator", modelNode))) {
            result.setIconSeparator(iconSeparator);
        }
        if (!"".equals(iconSuffix = this.xpath.evaluate("icon-suffix", modelNode))) {
            result.setIconSuffix(iconSuffix);
        }
        if (!"".equals(i18nPrefix = this.xpath.evaluate("i18n-prefix", modelNode))) {
            result.setI18nPrefix(i18nPrefix);
        }
        if (!"".equals(i18nSeparator = this.xpath.evaluate("i18n-separator", modelNode))) {
            result.setI18nSeparator(i18nSeparator);
        }
        if (!"".equals(i18nSuffix = this.xpath.evaluate("i18n-suffix", modelNode))) {
            result.setI18nSuffix(i18nSuffix);
        }
        this.setAttributes(result, modelNode);
        this.setGroupsAndViews(result, modelNode);
    }

    private void setAttributes(NavigationNode navNode, Node xmlNode) throws XPathExpressionException {
        String viewSuffix;
        String i18n;
        String icon;
        boolean hidden = this.getBooleanAttribute(this.xpath.evaluate("@hidden", xmlNode), false);
        navNode.setHidden(hidden);
        boolean enabled = this.getBooleanAttribute(this.xpath.evaluate("@enabled", xmlNode), true);
        navNode.setEnabled(enabled);
        String path = this.xpath.evaluate("path", xmlNode);
        if (!"".equals(path)) {
            navNode.setPath(path);
        }
        if (!"".equals(icon = this.xpath.evaluate("icon", xmlNode))) {
            navNode.setIcon(icon);
        }
        if (!"".equals(i18n = this.xpath.evaluate("i18n", xmlNode))) {
            navNode.setI18n(i18n);
        }
        if (!"".equals(viewSuffix = this.xpath.evaluate("view-suffix", xmlNode))) {
            navNode.setViewSuffix(viewSuffix);
        }
    }

    private void setGroupsAndViews(Group parent, Node xmlNode) throws XPathExpressionException {
        NodeList groupList = (NodeList)this.xpath.evaluate("group", xmlNode, XPathConstants.NODESET);
        int groupCount = groupList.getLength();
        for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            Node groupNode = groupList.item(groupIndex);
            Group group = new Group(this.xpath.evaluate("@id", groupNode));
            parent.addGroup(group);
            this.setAttributes(group, groupNode);
            this.setGroupsAndViews(group, groupNode);
        }
        NodeList viewList = (NodeList)this.xpath.evaluate("view", xmlNode, XPathConstants.NODESET);
        int viewCount = viewList.getLength();
        for (int viewIndex = 0; viewIndex < viewCount; ++viewIndex) {
            Node viewNode = viewList.item(viewIndex);
            View view = new View(this.xpath.evaluate("@id", viewNode));
            parent.addView(view);
            this.setAttributes(view, viewNode);
        }
    }

    private boolean getBooleanAttribute(String attrValue, boolean defaultValue) {
        boolean result = defaultValue;
        if (attrValue != null && !attrValue.trim().equals("")) {
            result = attrValue.equalsIgnoreCase("true") || attrValue.equalsIgnoreCase("yes") || attrValue.equalsIgnoreCase("on");
        }
        return result;
    }
}

