/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultCollectionFactory;
import org.eclipse.rdf4j.collection.factory.mapdb.BindingSetKeySerializer;
import org.eclipse.rdf4j.collection.factory.mapdb.BindingSetSerializer;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3BindingSetKey;
import org.eclipse.rdf4j.collection.factory.mapdb.ValueSerializer;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerJava;

public class MapDb3CollectionFactory
implements CollectionFactory {
    private static final int SWITCH_TO_DISK_BASED_SET_AT_SIZE = 16;
    protected volatile DB db;
    protected volatile long colectionId = 0L;
    protected final long iterationCacheSyncThreshold;
    private final CollectionFactory delegate;
    private static final boolean ON_32_BIT_VM = "32".equals(System.getProperty("sun.arch.data.model"));

    public MapDb3CollectionFactory(long iterationCacheSyncThreshold) {
        this(iterationCacheSyncThreshold, (CollectionFactory)new DefaultCollectionFactory());
    }

    public MapDb3CollectionFactory(long iterationCacheSyncThreshold, CollectionFactory delegate) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.db == null) {
            MapDb3CollectionFactory mapDb3CollectionFactory = this;
            synchronized (mapDb3CollectionFactory) {
                if (this.db == null) {
                    try {
                        DBMaker.Maker dbmaker = DBMaker.tempFileDB().closeOnJvmShutdown();
                        if (!ON_32_BIT_VM) {
                            dbmaker.fileMmapEnable();
                        }
                        this.db = dbmaker.make();
                    }
                    catch (DBException e) {
                        throw new RDF4jMapDB3Exception("could not initialize temp db", (Exception)((Object)e));
                    }
                }
            }
        }
    }

    public <T> List<T> createList() {
        return this.delegate.createList();
    }

    public List<Value> createValueList() {
        return this.delegate.createValueList();
    }

    public Set<BindingSet> createSetOfBindingSets(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getget, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer<BindingSet> serializer = this.createBindingSetSerializer(create, getHas, getget, getSet);
            MemoryTillSizeXSet<BindingSet> set = new MemoryTillSizeXSet<BindingSet>(this.colectionId++, this.delegate.createSetOfBindingSets(), serializer);
            return new CommitingSet<BindingSet>(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createSetOfBindingSets();
    }

    public <T> Set<T> createSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer<T> serializer = this.createAnySerializer();
            MemoryTillSizeXSet<T> set = new MemoryTillSizeXSet<T>(this.colectionId++, this.delegate.createSet(), serializer);
            return new CommitingSet<T>(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createSet();
    }

    public Set<Value> createValueSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer<Value> serializer = this.createValueSerializer();
            MemoryTillSizeXSet<Value> set = new MemoryTillSizeXSet<Value>(this.colectionId++, this.delegate.createValueSet(), serializer);
            return new CommitingSet<Value>(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createValueSet();
    }

    public <K, V> Map<K, V> createMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer keySerializer = this.createAnySerializer();
            Serializer valueSerializer = this.createAnySerializer();
            DB.HashMapMaker hashMap = this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer);
            HTreeMap create = hashMap.create();
            return new CommitingMap(create, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createMap();
    }

    public <V> Map<Value, V> createValueKeyedMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer<Value> keySerializer = this.createValueSerializer();
            Serializer valueSerializer = this.createAnySerializer();
            return new CommitingMap(this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer).create(), this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createValueKeyedMap();
    }

    public <T> Queue<T> createQueue() {
        return this.delegate.createQueue();
    }

    public Queue<Value> createValueQueue() {
        return this.delegate.createValueQueue();
    }

    public void close() throws RDF4JException {
        if (this.db != null) {
            this.db.close();
        }
    }

    public <E> Map<BindingSetKey, E> createGroupByMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            Serializer<BindingSetKey> keySerializer = this.createBindingSetKeySerializer();
            Serializer valueSerializer = this.createAnySerializer();
            return new CommitingMap(this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer).create(), this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createGroupByMap();
    }

    public final BindingSetKey createBindingSetKey(BindingSet bindingSet, List<Function<BindingSet, Value>> getValues, ToIntFunction<BindingSet> hashOfBindingSetCalculator) {
        ArrayList<Value> values = new ArrayList<Value>(getValues.size());
        for (int i = 0; i < getValues.size(); ++i) {
            values.add(getValues.get(i).apply(bindingSet));
        }
        return new MapDb3BindingSetKey(values, hashOfBindingSetCalculator.applyAsInt(bindingSet));
    }

    protected Serializer<BindingSet> createBindingSetSerializer(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getGet, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        return new BindingSetSerializer(this.createValueSerializer(), create, getHas, getGet, getSet);
    }

    protected <T> Serializer<T> createAnySerializer() {
        return new SerializerJava();
    }

    protected Serializer<Value> createValueSerializer() {
        return new ValueSerializer();
    }

    protected final Serializer<BindingSetKey> createBindingSetKeySerializer() {
        return new BindingSetKeySerializer(this.createValueSerializer());
    }

    protected class MemoryTillSizeXSet<V>
    extends AbstractSet<V> {
        private Set<V> wrapped;
        private final long setName;
        private final Serializer<V> valueSerializer;

        public MemoryTillSizeXSet(long setName, Set<V> wrapped, Serializer<V> valueSerializer) {
            this.setName = setName;
            this.wrapped = wrapped;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public boolean add(V e) {
            if (this.wrapped instanceof HashSet && this.wrapped.size() > 16) {
                Set disk = (Set)MapDb3CollectionFactory.this.db.hashSet(Long.toHexString(this.setName), this.valueSerializer).create();
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends V> arg0) {
            if (this.wrapped instanceof HashSet && arg0.size() > 16) {
                Set disk = (Set)MapDb3CollectionFactory.this.db.hashSet(Long.toHexString(this.setName), this.valueSerializer).create();
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.addAll(arg0);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.wrapped.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            return this.wrapped.remove(o);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.wrapped.toArray(arg0);
        }

        @Override
        public Iterator<V> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    protected static final class CommitingMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingMap(Map<K, V> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public V put(K k, V v) {
            V res = this.wrapped.put(k, v);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.wrapped.entrySet();
        }
    }

    protected static final class CommitingSet<T>
    extends AbstractSet<T> {
        private final Set<T> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingSet(Set<T> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public boolean add(T e) {
            boolean res = this.wrapped.add(e);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean res = this.wrapped.addAll(c);
            if (this.iterationCount + (long)c.size() % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    protected static final class RDF4jMapDB3Exception
    extends RDF4JException {
        private static final long serialVersionUID = 1L;

        public RDF4jMapDB3Exception(String string, Exception e) {
            super(string, (Throwable)e);
        }
    }
}

