/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark.rio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.rdf4j.common.io.IOUtil;

public enum RDFTestDataset {
    BSBM("bsbm.nt", "dataset.nt", "https://hobbitdata.informatik.uni-leipzig.de/benchmarks-data/datasets-dumps/bsbm-dump.zip"),
    FISHMARK("fishmark.nt", "fishmark-size1.nt", "https://hobbitdata.informatik.uni-leipzig.de/benchmarks-data/datasets-dumps/fishmark-dump.zip"),
    SP2BENCH("sp2b.n3", "sp2b.n3", "https://hobbitdata.informatik.uni-leipzig.de/benchmarks-data/datasets-dumps/sp2bench-dump.zip"),
    SWDF("swdf.nt", "SWDF.nt", "https://hobbitdata.informatik.uni-leipzig.de/benchmarks-data/datasets-dumps/swdf-dump.zip"),
    GENE2GO("gene2go.nq", "https://download.bio2rdf.org/files/release/3/ncbigene/gene2go.nq.gz"),
    LEXVO("lexvo_latest.rdf", "http://www.lexvo.org/resources/lexvo_latest.rdf.gz"),
    DATAGOVBE("datagovbe.nt", "https://github.com/Fedict/dcat/raw/master/all/datagovbe.nt.gz");

    private final String fileName;
    private final String archiveEntryName;
    private final URL url;

    private RDFTestDataset(String fileName, String url) {
        this(fileName, null, url);
    }

    private RDFTestDataset(String fileName, String archiveEntryName, String url) {
        this.archiveEntryName = archiveEntryName;
        this.fileName = fileName;
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Statically defiled URL " + url + " is unexpectedly malformed", e);
        }
    }

    public File download() {
        File downloadDir = new File(System.getProperty("java.io.tmpdir"), "rdf4j-benchmark-datasets");
        File dataFile = new File(downloadDir, this.fileName);
        if (dataFile.exists()) {
            return dataFile;
        }
        try {
            Files.createDirectories(downloadDir.toPath(), new FileAttribute[0]);
            File downloadFile = new File(downloadDir, Paths.get(this.url.getPath(), new String[0]).getFileName().toString());
            if (!downloadFile.exists()) {
                this.downloadTo(downloadFile);
            }
            if (!downloadFile.equals(dataFile)) {
                this.extract(downloadFile, dataFile);
                downloadFile.delete();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return dataFile;
    }

    private void downloadTo(File downloadFile) throws IOException {
        System.out.println("Downloading " + String.valueOf(this.url));
        try (BufferedInputStream is = new BufferedInputStream(this.url.openStream());){
            IOUtil.transfer((InputStream)is, (File)downloadFile);
        }
    }

    private void extract(File downloadFile, File dataFile) throws IOException {
        String downloadFileName = downloadFile.getName();
        if (downloadFileName.endsWith(".zip")) {
            this.extractFromZip(downloadFile, dataFile);
        } else if (downloadFileName.endsWith(".gz")) {
            this.extractFromGzip(downloadFile, dataFile);
        }
    }

    private void extractFromZip(File downloadFile, File dataFile) throws IOException {
        System.out.println("Extracting " + this.archiveEntryName + " from " + String.valueOf(downloadFile) + " to " + dataFile.getName());
        try (ZipFile zf = new ZipFile(downloadFile);){
            ZipEntry entry = zf.getEntry(this.archiveEntryName);
            try (InputStream in = zf.getInputStream(entry);){
                IOUtil.writeStream((InputStream)in, (File)dataFile);
            }
        }
    }

    private void extractFromGzip(File downloadFile, File dataFile) throws IOException {
        System.out.println("Extracting " + String.valueOf(downloadFile) + " to " + dataFile.getName());
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(downloadFile));
        IOUtil.writeStream((InputStream)in, (File)dataFile);
    }
}

