/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark.rio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.benchmark.rio.util.BlackHoleRDFHandler;
import org.eclipse.rdf4j.benchmark.rio.util.DataSetGenerator;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, jvmArgs={"-Xms4g", "-Xmx4g", "-XX:+UseSerialGC"})
public abstract class ParserBenchmark {
    public static final int TOTAL_STATEMENTS = 1000000;
    public static final int MIN_STRING_LENGTH = 100;
    public static final int MAX_STRING_LENGTH = 300;
    public static final int PERCENT_BNODE = 30;
    public static final int PERCENT_LITERALS = 50;
    public static final boolean TEXT_ONLY = false;
    private File toReadFrom;
    private BlackHoleRDFHandler rdfHandler;
    private RDFParser parser;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        this.parser = this.getParser();
        RDFFormat format = this.parser.getRDFFormat();
        this.rdfHandler = new BlackHoleRDFHandler();
        if (this.toReadFrom == null) {
            DataSetGenerator generator = new DataSetGenerator();
            this.toReadFrom = Files.createTempFile("rdf4j-parser-benchmark", "." + format.getDefaultFileExtension(), new FileAttribute[0]).toFile();
            this.toReadFrom.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(this.toReadFrom);){
                RDFWriter writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
                generator.generateStatements((RDFHandler)writer, 30, 50, 100, 300, 1000000, false, true);
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void parseStream(Blackhole blackhole) throws IOException {
        try (FileInputStream stream = new FileInputStream(this.toReadFrom);){
            this.parser.setRDFHandler((RDFHandler)this.rdfHandler);
            this.rdfHandler.setBlackHoleConsumer(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
            this.parser.parse((InputStream)stream, "http://example.com/gererator/");
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void parseBufferedReader(Blackhole blackhole) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.toReadFrom)));){
            this.parser.setRDFHandler((RDFHandler)this.rdfHandler);
            this.rdfHandler.setBlackHoleConsumer(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
            this.parser.parse((Reader)reader, "http://example.com/gererator/");
        }
    }

    public abstract RDFParser getParser();
}

