/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark;

import java.io.File;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.assertj.core.util.Files;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Fork(value=1)
@State(value=Scope.Thread)
@Warmup(iterations=2)
@Measurement(iterations=4)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class QueryOrderBenchmark {
    private File dataDir;
    private final Random random = new Random(43252333L);
    private Repository repository;
    private RepositoryConnection conn;
    @Param(value={"10", "50", "100", "250"})
    public int countk = 10;
    @Param(value={"10", "100", "1000", "10000", "50000", "-1"})
    public int limit = 10;
    @Param(value={"0", "10000"})
    public int syncThreshold = 10;

    @Setup
    public void setup() {
        this.dataDir = Files.newTemporaryFolder();
        NativeStore sail = new NativeStore(this.dataDir, "spoc,posc");
        sail.setIterationCacheSyncThreshold((long)this.syncThreshold);
        this.repository = new SailRepository((Sail)sail);
        this.initialize();
        this.conn = this.repository.getConnection();
    }

    private void initialize() {
        try (RepositoryConnection conn = this.repository.getConnection();){
            ValueFactory vf = conn.getValueFactory();
            for (int i = 0; i < this.countk; ++i) {
                conn.begin();
                for (int j = 0; j < 1000; ++j) {
                    IRI subj = vf.createIRI("urn:test:" + Double.toHexString(this.random.nextDouble()));
                    Literal val = vf.createLiteral(Double.toHexString(this.random.nextDouble()));
                    conn.add((Resource)subj, RDF.VALUE, (Value)val, new Resource[0]);
                }
                conn.commit();
            }
        }
    }

    @TearDown
    public void tearDown() throws Exception {
        this.conn.close();
        this.repository.shutDown();
        FileUtils.deleteDirectory((File)this.dataDir);
    }

    @Benchmark
    public void selectAll() {
        StringBuilder rq = new StringBuilder("SELECT * { ?s ?p ?o } ORDER BY ?o");
        if (this.limit > 0) {
            rq = rq.append(" LIMIT ").append(this.limit);
        }
        long count = 0L;
        try (TupleQueryResult result = this.conn.prepareTupleQuery(rq.toString()).evaluate();){
            while (result.hasNext()) {
                result.next();
                ++count;
                if (this.limit > 0 && this.limit < this.countk * 1000 ? !$assertionsDisabled && count > (long)this.limit : !$assertionsDisabled && count > (long)(this.countk * 1000)) {
                    throw new AssertionError();
                }
            }
        }
        if (this.limit > 0 && this.limit < this.countk * 1000 ? !$assertionsDisabled && count != (long)this.limit : !$assertionsDisabled && count != (long)(this.countk * 1000)) {
            throw new AssertionError();
        }
    }

    @Benchmark
    public void selectDistinct() {
        StringBuilder rq = new StringBuilder("SELECT DISTINCT ?s ?o { ?s ?p ?o } ORDER BY ?o");
        if (this.limit > 0) {
            rq = rq.append(" LIMIT ").append(this.limit);
        }
        long count = 0L;
        try (TupleQueryResult result = this.conn.prepareTupleQuery(rq.toString()).evaluate();){
            while (result.hasNext()) {
                result.next();
                ++count;
                if (this.limit > 0 && this.limit < this.countk * 1000 ? !$assertionsDisabled && count > (long)this.limit : !$assertionsDisabled && count > (long)(this.countk * 1000)) {
                    throw new AssertionError();
                }
            }
        }
        if (this.limit > 0 && this.limit < this.countk * 1000 ? !$assertionsDisabled && count != (long)this.limit : !$assertionsDisabled && count != (long)(this.countk * 1000)) {
            throw new AssertionError();
        }
    }

    public static void main(String[] args) throws RunnerException {
        String regexp = ".*" + QueryOrderBenchmark.class.getSimpleName() + ".*";
        new Runner(new OptionsBuilder().include(regexp).build()).run();
    }
}

