/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark.rio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.benchmark.rio.util.DataSetGenerator;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.ContextStatementCollector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.util.NullOutputStream;

@State(value=Scope.Benchmark)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, jvmArgs={"-Xms4g", "-Xmx4g", "-XX:+UseSerialGC"})
public class WriterBenchmark {
    public static final int TOTAL_STATEMENTS = 100000;
    public static final int MIN_STRING_LENGTH = 10;
    public static final int MAX_STRING_LENGTH = 300;
    public static final int PERCENT_BNODE = 30;
    public static final int PERCENT_LITERALS = 50;
    public static final boolean TEXT_ONLY = false;
    @Param(value={"brf", "jsonld", "n3", "nq", "nt", "rdf", "rj", "trig", "trix", "ttl"})
    public String format;
    private RDFFormat writerFormat;
    private Model model;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        this.writerFormat = (RDFFormat)Rio.getWriterFormatForFileName((String)("dummy." + this.format)).orElseThrow();
        this.model = new LinkedHashModel();
        SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
        ContextStatementCollector handler = new ContextStatementCollector((Collection)this.model, (ValueFactory)valueFactory, new Resource[0]);
        DataSetGenerator generator = new DataSetGenerator();
        generator.generateStatements((RDFHandler)handler, 30, 50, 10, 300, 100000, false, true);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void writer() {
        NullOutputStream out = new NullOutputStream();
        Rio.write((Iterable)this.model, (OutputStream)out, (RDFFormat)this.writerFormat);
    }
}

