/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=10)
@Warmup(iterations=20)
@Fork(value=1)
@State(value=Scope.Thread)
public class ReasoningUpdateBenchmark {
    private int expectedCount;
    @Param(value={"moreRdfs::12180"})
    public String param;
    private static final IRI schemaGraph = SimpleValueFactory.getInstance().createIRI("http://example.org/schemaGraph");
    Map<String, String> cache = new HashMap<String, String>();

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[]{schemaGraph});
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    private void checkSize(SailRepository sail) {
        assert (this.getSize(sail) == this.expectedCount) : "Was " + this.getSize(sail) + " but expected " + this.expectedCount;
    }

    private int getSize(SailRepository sail) {
        try (SailRepositoryConnection connection = sail.getConnection();){
            int n;
            block12: {
                TupleQueryResult evaluate = connection.prepareTupleQuery("select (count (*) as ?count) where {?a ?b ?c}").evaluate();
                try {
                    n = ((Literal)((BindingSet)evaluate.next()).getBinding("count").getValue()).intValue();
                    if (evaluate == null) break block12;
                }
                catch (Throwable throwable) {
                    if (evaluate != null) {
                        try {
                            evaluate.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                evaluate.close();
            }
            return n;
        }
    }

    private void addAllDataMultipleTransactions(SailRepositoryConnection connection) throws IOException {
        for (int i = 0; i <= 9; ++i) {
            connection.begin();
            try (Stream stream = connection.getStatements(null, null, null, new Resource[0]).stream();){
                stream.findFirst().ifPresent(x$0 -> connection.remove(x$0, new Resource[0]));
            }
            connection.commit();
            connection.begin();
            connection.add(this.resourceAsStream("data" + i++ + ".ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
    }

    private InputStream resourceAsStream(String resourceName) {
        String[] split = this.param.split("\\:\\:");
        this.expectedCount = Integer.parseInt(split[1]);
        String filename = split[0] + "/" + resourceName;
        String content = this.cache.computeIfAbsent(filename, fn -> {
            try {
                return IOUtils.toString((InputStream)ReasoningUpdateBenchmark.class.getClassLoader().getResourceAsStream((String)fn), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }
}

