/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark.rio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.benchmark.rio.RDFTestDataset;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.binary.BinaryRDFWriterSettings;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class RDFSizeBenchmarks {
    public static void main(String[] args) throws IOException {
        List<File> datasets = List.of(RDFTestDataset.SWDF.download(), RDFTestDataset.LEXVO.download(), RDFTestDataset.DATAGOVBE.download(), RDFTestDataset.FISHMARK.download(), RDFTestDataset.SP2BENCH.download(), RDFTestDataset.GENE2GO.download(), RDFTestDataset.BSBM.download());
        LinkedHashMap<String, Pair<RDFFormat, WriterConfig>> writers = new LinkedHashMap<String, Pair<RDFFormat, WriterConfig>>();
        writers.put("binary v1, buffer size = 100", RDFSizeBenchmarks.binaryV1(100L));
        writers.put("binary v1, buffer size =  8k", RDFSizeBenchmarks.binaryV1(8192L));
        writers.put("binary v2, buffer size = 100, UTF-16", RDFSizeBenchmarks.binaryV2(100L, StandardCharsets.UTF_16, false));
        writers.put("binary v2, buffer size =  8k, UTF-16", RDFSizeBenchmarks.binaryV2(8192L, StandardCharsets.UTF_16, false));
        writers.put("binary v2, buffer size = 100, UTF-8", RDFSizeBenchmarks.binaryV2(100L, StandardCharsets.UTF_8, false));
        writers.put("binary v2, buffer size =  8k, UTF-8", RDFSizeBenchmarks.binaryV2(8192L, StandardCharsets.UTF_8, false));
        writers.put("binary v2, buffer size = 100, UTF-16, with id-recycling", RDFSizeBenchmarks.binaryV2(100L, StandardCharsets.UTF_16, true));
        writers.put("binary v2, buffer size =  8k, UTF-16, with id-recycling", RDFSizeBenchmarks.binaryV2(8192L, StandardCharsets.UTF_16, true));
        writers.put("binary v2, buffer size = 100, UTF-8, with id-recycling", RDFSizeBenchmarks.binaryV2(100L, StandardCharsets.UTF_8, true));
        writers.put("binary v2, buffer size =  8k, UTF-8, with id-recycling", RDFSizeBenchmarks.binaryV2(8192L, StandardCharsets.UTF_8, true));
        for (File dataset : datasets) {
            for (Map.Entry writer : writers.entrySet()) {
                System.gc();
                RDFSizeBenchmarks.reportSize(dataset, (String)writer.getKey(), (RDFFormat)((Pair)writer.getValue()).getKey(), (WriterConfig)((Pair)writer.getValue()).getValue());
            }
        }
    }

    private static Pair<RDFFormat, WriterConfig> binaryV1(long bufferSize) {
        return Pair.of((Object)RDFFormat.BINARY, (Object)new WriterConfig().set(BinaryRDFWriterSettings.VERSION, (Object)1L).set(BinaryRDFWriterSettings.BUFFER_SIZE, (Object)bufferSize));
    }

    private static Pair<RDFFormat, WriterConfig> binaryV2(long bufferSize, Charset charset, boolean recycleIds) {
        WriterConfig config = new WriterConfig().set(BinaryRDFWriterSettings.VERSION, (Object)2L).set(BinaryRDFWriterSettings.BUFFER_SIZE, (Object)bufferSize).set(BinaryRDFWriterSettings.CHARSET, (Object)charset.name()).set(BinaryRDFWriterSettings.RECYCLE_IDS, (Object)recycleIds);
        return Pair.of((Object)RDFFormat.BINARY, (Object)config);
    }

    private static void reportSize(File path, String description, RDFFormat outputFormat, WriterConfig writerConfig) throws IOException {
        String fileName = path.getName();
        RDFFormat inputFormat = (RDFFormat)Rio.getParserFormatForFileName((String)fileName).orElseThrow(() -> new IllegalArgumentException("No format available for " + fileName));
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));){
            RDFSizeBenchmarks.reportSize(fileName, is, description, inputFormat, outputFormat, writerConfig);
        }
    }

    private static void reportSize(String dataset, InputStream is, String description, RDFFormat inputFormat, RDFFormat outputFormat, WriterConfig writerConfig) throws IOException {
        CountingOutputStream os = new CountingOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        RDFWriter writer = Rio.createWriter((RDFFormat)outputFormat, (OutputStream)os);
        writer.setWriterConfig(writerConfig);
        RDFParser parser = Rio.createParser((RDFFormat)inputFormat);
        parser.setRDFHandler((RDFHandler)writer);
        parser.setParserConfig(new ParserConfig().set(BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)false).set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false).set(BasicParserSettings.VERIFY_URI_SYNTAX, (Object)false));
        Instant start = Instant.now();
        parser.parse(is);
        Instant end = Instant.now();
        Duration duration = Duration.between(start, end);
        long size = os.getByteCount();
        System.out.printf("%20s %8.2f MB in %-14s - %s%n", dataset, Float.valueOf((float)(size / 1024L) / 1024.0f), duration, description);
    }
}

