/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark.rio.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;

public class DataSetGenerator {
    public static final String NAMESPACE = "http://example.com/gererator/";
    private static final String WORD_DIR = "generated-data/words.txt";
    private static final int TOTAL_PREDS = 500;
    private static final int AVG_GRAPH_SIZE = 500;
    private final ValueFactory factory;
    private final StringBuilder valueBuilder;
    private final AtomicInteger contextCount = new AtomicInteger(0);
    private final AtomicInteger maxCurrentContextCount = new AtomicInteger(0);
    private ArrayList<String> dictionary;
    private ArrayList<IRI> predicateIRIs;
    private ArrayList<IRI> contextIRIs;
    private Random randomResource;
    private Random randomProbability;
    private BNode prevBNode;
    private IRI currentContext;
    private int totalWords;
    private int avgWordSize = 0;

    public DataSetGenerator() {
        this.factory = SimpleValueFactory.getInstance();
        this.valueBuilder = new StringBuilder();
        this.randomResource = new Random(64L);
        this.randomProbability = new Random(64L);
        this.fetchWords();
        this.generatePredicateList();
    }

    public void generateStatements(RDFHandler handler, int percentBNodes, int percentLiterals, int textMinLength, int textMaxLength, int totalStatements, boolean isTextOnly, boolean withContext) {
        if (percentBNodes + percentLiterals > 100 || totalStatements <= 0 || textMaxLength <= 0 || textMinLength >= textMaxLength) {
            throw new IllegalArgumentException("Invalid data set variables");
        }
        if (withContext) {
            this.generateContextList(totalStatements);
            this.writeBinaryStatementsWithContext(handler, percentBNodes, percentLiterals, textMinLength, textMaxLength, totalStatements, isTextOnly);
            this.maxCurrentContextCount.set(0);
            this.contextCount.set(0);
            this.currentContext = null;
        } else {
            this.writeBinaryStatementsWithoutContext(handler, percentBNodes, percentLiterals, textMinLength, textMaxLength, totalStatements, isTextOnly);
        }
        this.prevBNode = null;
        this.randomResource = new Random(64L);
        this.randomProbability = new Random(64L);
    }

    private void writeBinaryStatementsWithContext(RDFHandler handler, int percentBNodes, int percentLiterals, int textMinLength, int textMaxLength, int totalStatements, boolean isTextOnly) {
        handler.startRDF();
        for (int i = 0; i < totalStatements; ++i) {
            handler.handleStatement(this.fetchStatementWithContext(isTextOnly, textMinLength, textMaxLength, percentBNodes, percentLiterals));
        }
        handler.endRDF();
    }

    private void writeBinaryStatementsWithoutContext(RDFHandler handler, int percentBNodes, int percentLiterals, int textMinLength, int textMaxLength, int totalStatements, boolean isTextOnly) {
        handler.startRDF();
        for (int i = 0; i < totalStatements; ++i) {
            handler.handleStatement(this.fetchStatementWithoutContext(isTextOnly, textMinLength, textMaxLength, percentBNodes, percentLiterals));
        }
        handler.endRDF();
    }

    private Statement fetchStatementWithContext(boolean isTextOnly, int textMinLength, int textMaxLength, int percentBNodes, int percentLiterals) {
        if (this.prevBNode != null) {
            Statement statement = this.generateStatement(this.prevBNode, this.currentContext, isTextOnly, textMinLength, textMaxLength, percentLiterals, true);
            if (this.getPercentProbability() >= percentBNodes) {
                this.prevBNode = null;
            }
            return statement;
        }
        if (this.getPercentProbability() < percentBNodes) {
            this.updateContext();
            this.prevBNode = this.createBNode();
            return this.generateStatement(this.prevBNode, this.currentContext, isTextOnly, textMinLength, textMaxLength, percentLiterals, false);
        }
        this.updateContext();
        return this.generateStatement(null, this.currentContext, isTextOnly, textMinLength, textMaxLength, percentLiterals, false);
    }

    private Statement fetchStatementWithoutContext(boolean isTextOnly, int textMinLength, int textMaxLength, int percentBNodes, int percentLiterals) {
        if (this.prevBNode != null) {
            Statement statement = this.generateStatement(this.prevBNode, null, isTextOnly, textMinLength, textMaxLength, percentLiterals, true);
            if (this.getPercentProbability() >= percentBNodes) {
                this.prevBNode = null;
            }
            return statement;
        }
        if (this.getPercentProbability() < percentBNodes) {
            this.prevBNode = this.createBNode();
            return this.generateStatement(this.prevBNode, null, isTextOnly, textMinLength, textMaxLength, percentLiterals, false);
        }
        return this.generateStatement(null, null, isTextOnly, textMinLength, textMaxLength, percentLiterals, false);
    }

    private void updateContext() {
        if (this.contextCount.get() < this.maxCurrentContextCount.get()) {
            this.contextCount.incrementAndGet();
        } else {
            this.resetContext();
        }
    }

    private void resetContext() {
        this.maxCurrentContextCount.set(this.randomResource.nextInt(1800) + 200);
        this.contextCount.set(0);
        this.currentContext = this.fetchRandomContext();
    }

    private Statement generateStatement(BNode bNode, IRI context, boolean isTextOnly, int textMinLength, int textMaxLength, int percentLiterals, boolean isBNodeSubj) {
        if (context != null) {
            return this.createStatementWithContext(bNode, isTextOnly, textMinLength, textMaxLength, percentLiterals, isBNodeSubj, context);
        }
        return this.createStatementWithoutContext(bNode, isTextOnly, textMinLength, textMaxLength, percentLiterals, isBNodeSubj);
    }

    private Statement createStatementWithContext(BNode bNode, boolean isTextOnly, int textMinLength, int textMaxLength, int percentLiterals, boolean isBNodeSubj, IRI context) {
        boolean shouldCreateLiteral;
        boolean bl = shouldCreateLiteral = this.getPercentProbability() < percentLiterals;
        if (shouldCreateLiteral && bNode == null) {
            return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)this.generateLiteral(isTextOnly, textMinLength, textMaxLength), (Resource)context);
        }
        if (shouldCreateLiteral && isBNodeSubj) {
            return this.factory.createStatement((Resource)bNode, this.fetchRandomPredicate(), (Value)this.generateLiteral(isTextOnly, textMinLength, textMaxLength), (Resource)context);
        }
        if (bNode == null) {
            return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)this.generateIri(), (Resource)context);
        }
        return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)bNode, (Resource)context);
    }

    private Statement createStatementWithoutContext(BNode bNode, boolean isTextOnly, int textMinLength, int textMaxLength, int percentLiterals, boolean isBNodeSubj) {
        boolean shouldCreateLiteral;
        boolean bl = shouldCreateLiteral = this.getPercentProbability() < percentLiterals;
        if (shouldCreateLiteral && bNode == null) {
            return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)this.generateLiteral(isTextOnly, textMinLength, textMaxLength));
        }
        if (shouldCreateLiteral && isBNodeSubj) {
            return this.factory.createStatement((Resource)bNode, this.fetchRandomPredicate(), (Value)this.generateLiteral(isTextOnly, textMinLength, textMaxLength));
        }
        if (bNode == null) {
            return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)this.generateIri());
        }
        return this.factory.createStatement((Resource)this.generateIri(), this.fetchRandomPredicate(), (Value)bNode);
    }

    private IRI fetchRandomPredicate() {
        return this.predicateIRIs.get(this.getPredicateIndex());
    }

    private IRI fetchRandomContext() {
        return this.contextIRIs.get(this.getContextIndex());
    }

    private Literal generateLiteral(boolean isTextOnly, int minLength, int maxLength) {
        if (isTextOnly) {
            return this.createStringLiteral(minLength, maxLength);
        }
        if (this.getPercentProbability() < 50) {
            return this.createNumberLiteral();
        }
        return this.createStringLiteral(minLength, maxLength);
    }

    private Literal createNumberLiteral() {
        int i = this.randomResource.nextInt(4);
        switch (i) {
            case 0: {
                return this.factory.createLiteral(this.randomResource.nextDouble());
            }
            case 1: {
                return this.factory.createLiteral(this.randomResource.nextFloat());
            }
            case 2: {
                return this.factory.createLiteral(this.randomResource.nextInt());
            }
        }
        return this.factory.createLiteral(this.randomResource.nextLong());
    }

    private Literal createStringLiteral(int minLength, int maxLength) {
        String value;
        this.valueBuilder.setLength(0);
        this.valueBuilder.append(this.dictionary.get(this.getDictionaryIndex()));
        if (this.valueBuilder.length() > maxLength) {
            value = this.valueBuilder.substring(0, maxLength);
        } else if (this.valueBuilder.length() > minLength) {
            value = this.valueBuilder.toString();
        } else {
            int diffMinMax = maxLength - minLength;
            int addMaxWords = diffMinMax / this.avgWordSize;
            int wordsToAdd = this.randomResource.nextInt(addMaxWords) + 1;
            while (this.valueBuilder.length() < minLength) {
                for (int i = 0; i < wordsToAdd; ++i) {
                    this.valueBuilder.append(this.dictionary.get(this.getDictionaryIndex())).append(" ");
                }
            }
            value = this.valueBuilder.length() > maxLength ? this.valueBuilder.substring(0, maxLength) : this.valueBuilder.toString();
        }
        return this.factory.createLiteral(value);
    }

    private int getDictionaryIndex() {
        return this.randomResource.nextInt(this.totalWords);
    }

    private BNode createBNode() {
        return this.factory.createBNode();
    }

    private void fetchWords() {
        this.dictionary = new ArrayList(1024);
        try (BufferedReader reader = new BufferedReader(new FileReader(Objects.requireNonNull(this.getClass().getClassLoader().getResource(WORD_DIR)).getFile()));){
            reader.lines().forEach(line -> {
                this.avgWordSize += line.length();
                this.dictionary.add((String)line);
            });
            this.totalWords = this.dictionary.size();
            this.avgWordSize /= this.totalWords;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getPredicateIndex() {
        return this.randomResource.nextInt(500);
    }

    private void generatePredicateList() {
        this.predicateIRIs = new ArrayList(1024);
        for (int i = 0; i < 500; ++i) {
            this.predicateIRIs.add(this.generateIri());
        }
    }

    private IRI generateIri() {
        return this.factory.createIRI(NAMESPACE, "daf" + Math.abs(this.randomResource.nextLong()));
    }

    private int getContextIndex() {
        return this.randomResource.nextInt(this.contextIRIs.size());
    }

    private void generateContextList(int totalStatements) {
        this.contextIRIs = new ArrayList(1024);
        int totalContexts = totalStatements / 500;
        for (int i = 0; i < totalContexts; ++i) {
            this.contextIRIs.add(this.generateIri());
        }
    }

    private int getPercentProbability() {
        return this.randomProbability.nextInt(101);
    }
}

