/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=10)
@Warmup(iterations=20)
@Fork(value=1)
@State(value=Scope.Thread)
public class ReasoningBenchmark {
    private int expectedCount;
    @Param(value={"moreRdfs::12180", "longChain::5803", "medium::544", "simple::152"})
    public String param;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void noReasoning() throws IOException {
        SailRepository sail = new SailRepository((Sail)new MemoryStore());
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void noReasoningMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new MemoryStore());
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingRDFSInferencerMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
        this.checkSize(sail);
    }

    private void checkSize(SailRepository sail) {
        assert (this.getSize(sail) == this.expectedCount) : "Was " + this.getSize(sail) + " but expected " + this.expectedCount;
    }

    private int getSize(SailRepository sail) {
        try (SailRepositoryConnection connection = sail.getConnection();){
            int n;
            block12: {
                TupleQueryResult evaluate = connection.prepareTupleQuery("select (count (*) as ?count) where {?a ?b ?c}").evaluate();
                try {
                    n = ((Literal)((BindingSet)evaluate.next()).getBinding("count").getValue()).intValue();
                    if (evaluate == null) break block12;
                }
                catch (Throwable throwable) {
                    if (evaluate != null) {
                        try {
                            evaluate.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                evaluate.close();
            }
            return n;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerSchema() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore(), (Repository)this.createSchema()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
        this.checkSize(sail);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerMultipleTransactionsSchema() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore(), (Repository)this.createSchema()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    private SailRepository createSchema() throws IOException {
        SailRepository schema = new SailRepository((Sail)new MemoryStore());
        try (SailRepositoryConnection schemaConnection = schema.getConnection();){
            schemaConnection.begin();
            schemaConnection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            schemaConnection.commit();
        }
        return schema;
    }

    private void addAllDataSingleTransaction(SailRepositoryConnection connection) throws IOException {
        InputStream data = this.resourceAsStream("data.ttl");
        if (data != null) {
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
        }
        int counter = 0;
        while ((data = this.resourceAsStream("data" + counter++ + ".ttl")) != null) {
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
        }
    }

    private void addAllDataMultipleTransactions(SailRepositoryConnection connection) throws IOException {
        InputStream data = this.resourceAsStream("data.ttl");
        if (data != null) {
            connection.begin();
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
        int counter = 0;
        while ((data = this.resourceAsStream("data" + counter++ + ".ttl")) != null) {
            connection.begin();
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
    }

    private InputStream resourceAsStream(String resourceName) {
        String[] split = this.param.split("\\:\\:");
        this.expectedCount = Integer.parseInt(split[1]);
        return ReasoningBenchmark.class.getClassLoader().getResourceAsStream(split[0] + "/" + resourceName);
    }
}

