/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=10)
@Warmup(iterations=20)
@Fork(value=1)
@State(value=Scope.Thread)
public class ReasoningUpdateBenchmark {
    private int expectedCount;
    @Param(value={"moreRdfs::12180"})
    public String param;
    private static final IRI schemaGraph = SimpleValueFactory.getInstance().createIRI("http://example.org/schemaGraph");
    Map<String, String> cache = new HashMap<String, String>();

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[]{schemaGraph});
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    private void checkSize(SailRepository sail) {
        assert (this.getSize(sail) == this.expectedCount) : "Was " + this.getSize(sail) + " but expected " + this.expectedCount;
    }

    /*
     * Exception decompiling
     */
    private int getSize(SailRepository sail) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addAllDataMultipleTransactions(SailRepositoryConnection connection) throws IOException {
        for (int i = 0; i <= 9; ++i) {
            connection.begin();
            try (Stream stream = connection.getStatements(null, null, null, new Resource[0]).stream();){
                stream.findFirst().ifPresent(x$0 -> connection.remove(x$0, new Resource[0]));
            }
            connection.commit();
            connection.begin();
            connection.add(this.resourceAsStream("data" + i++ + ".ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
    }

    private InputStream resourceAsStream(String resourceName) {
        String[] split = this.param.split("\\:\\:");
        this.expectedCount = Integer.parseInt(split[1]);
        String filename = split[0] + "/" + resourceName;
        String content = this.cache.computeIfAbsent(filename, fn -> {
            try {
                return IOUtils.toString((InputStream)ReasoningUpdateBenchmark.class.getClassLoader().getResourceAsStream((String)fn), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }
}

