/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IRegistryWriter;
import org.eclipse.urischeme.internal.registration.IWinRegistry;
import org.eclipse.urischeme.internal.registration.Util;
import org.eclipse.urischeme.internal.registration.WinRegistry;
import org.eclipse.urischeme.internal.registration.WinRegistryException;

public class RegistryWriter
implements IRegistryWriter {
    private String key_software_classes;
    private String key_shell;
    private String key_open;
    private String key_command;
    String launcherPath;
    private static final String ATTRIBUTE_DEFAULT = null;
    private static final String ATTRIBUTE_EXECUTABLE = "Executable";
    private static final String ATTRIBUTE_PROTOCOL_MARKER = "URL Protocol";
    private IWinRegistry winRegistry = null;
    private IFileProvider fileProvider = null;

    public RegistryWriter() {
        this(new WinRegistry(), new FileProvider());
    }

    public RegistryWriter(IWinRegistry winRegistry, IFileProvider fileProvider) {
        String launcher = System.getProperty("eclipse.launcher");
        String homeLocation = System.getProperty("eclipse.home.location");
        Assert.isNotNull((Object)homeLocation, (String)"home location must not be null");
        this.winRegistry = winRegistry;
        this.fileProvider = fileProvider;
        URI homeLocURI = RegistryWriter.filePathToURI(homeLocation);
        this.setLauncherPath(this.getLauncher(launcher, homeLocURI));
    }

    @Override
    public void addScheme(String scheme) throws WinRegistryException {
        Util.assertUriSchemeIsLegal(scheme);
        this.getRegisteredHandlerPath(scheme);
        this.winRegistry.setValueForKey(this.key_software_classes, ATTRIBUTE_PROTOCOL_MARKER, "");
        this.winRegistry.setValueForKey(this.key_software_classes, ATTRIBUTE_DEFAULT, "URL:" + scheme);
        this.winRegistry.setValueForKey(this.key_command, ATTRIBUTE_EXECUTABLE, this.getLauncherPath());
        String openCommand = String.valueOf(IRegistryWriter.quote(this.getLauncherPath())) + " " + IRegistryWriter.quote("%1");
        this.winRegistry.setValueForKey(this.key_command, ATTRIBUTE_DEFAULT, openCommand);
    }

    @Override
    public void removeScheme(String scheme) throws WinRegistryException {
        Util.assertUriSchemeIsLegal(scheme);
        if (this.getRegisteredHandlerPath(scheme) == null) {
            return;
        }
        this.winRegistry.deleteKey(this.key_command);
        this.winRegistry.deleteKey(this.key_open);
        this.winRegistry.deleteKey(this.key_shell);
        this.winRegistry.deleteKey(this.key_software_classes);
    }

    @Override
    public String getRegisteredHandlerPath(String scheme) throws WinRegistryException {
        this.changeKeys(scheme);
        String marker = this.winRegistry.getValueForKey(this.key_software_classes, ATTRIBUTE_PROTOCOL_MARKER);
        if (marker == null) {
            return null;
        }
        String command = this.winRegistry.getValueForKey(this.key_command, ATTRIBUTE_DEFAULT);
        if (command == null) {
            return null;
        }
        String exec = this.winRegistry.getValueForKey(this.key_command, ATTRIBUTE_EXECUTABLE);
        if (exec == null) {
            return null;
        }
        if (!this.fileProvider.fileExists(exec)) {
            return null;
        }
        return exec;
    }

    void changeKeys(String scheme) {
        this.key_software_classes = "Software\\Classes\\";
        this.key_software_classes = String.valueOf(this.key_software_classes) + scheme;
        this.key_shell = String.valueOf(this.key_software_classes) + "\\shell";
        this.key_open = String.valueOf(this.key_shell) + "\\open";
        this.key_command = String.valueOf(this.key_open) + "\\command";
    }

    String getLauncherPath() {
        return this.launcherPath;
    }

    void setLauncherPath(String launcherPath) {
        this.launcherPath = launcherPath;
    }

    static URI filePathToURI(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (path.startsWith("file:")) {
                String strippedPath = RegistryWriter.stripProtocol(path);
                return new File(strippedPath).toURI();
            }
            return new File(path).toURI();
        }
    }

    static String stripProtocol(String path) {
        return new Path(path).setDevice(null).makeRelative().toOSString();
    }

    private String getLauncher(String launcher, URI homeLocation) {
        if (launcher != null && this.fileProvider.fileExists(launcher) && !this.fileProvider.isDirectory(launcher)) {
            return launcher;
        }
        return RegistryWriter.getLauncherFromHomeLocation(homeLocation);
    }

    static String getLauncherFromHomeLocation(URI homeLocation) {
        File homeLoc;
        if (homeLocation != null && (homeLoc = new File(homeLocation)).exists() && homeLoc.isDirectory()) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(homeLoc.toPath(), "*.exe");){
                    Iterator<java.nio.file.Path> iterator = stream.iterator();
                    if (iterator.hasNext()) {
                        java.nio.file.Path path = iterator.next();
                        String fetchedPath = path.toString();
                        stream.close();
                        return fetchedPath;
                    }
                    stream.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            File parentFile = homeLoc.getParentFile();
            if (parentFile != null) {
                return RegistryWriter.getLauncherFromHomeLocation(parentFile.toURI());
            }
        }
        return null;
    }
}

