/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.ui.CompareResultDialog;
import org.eclipse.unittest.internal.ui.FailureTraceUIBlock;
import org.eclipse.unittest.internal.ui.Images;
import org.eclipse.unittest.internal.ui.Messages;

public class CompareResultsAction
extends Action {
    private final FailureTraceUIBlock fView;
    private CompareResultDialog fOpenDialog;

    public CompareResultsAction(FailureTraceUIBlock view) {
        super(Messages.CompareResultsAction_label);
        this.setDescription(Messages.CompareResultsAction_description);
        this.setToolTipText(Messages.CompareResultsAction_tooltip);
        this.setImageDescriptor(Images.getImageDescriptor("elcl16/compare.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.unittest.ui.enable_filter_action_context");
        this.fView = view;
    }

    public void run() {
        TestElement failedTest = this.fView.getFailedTest();
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
            this.fOpenDialog.getShell().setActive();
        } else {
            this.fOpenDialog = new CompareResultDialog(this.fView.getShell(), failedTest);
            this.fOpenDialog.create();
            this.fOpenDialog.getShell().addDisposeListener(e -> {
                CompareResultDialog compareResultDialog = this.fOpenDialog = null;
            });
            this.fOpenDialog.setBlockOnOpen(false);
            this.fOpenDialog.open();
        }
    }

    public void updateOpenDialog(TestElement failedTest) {
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
        }
    }
}

