/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.model;

import java.time.Duration;
import java.util.Objects;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

public interface ITestElement {
    public String getId();

    public String getData();

    public ITestRunSession getTestRunSession();

    public Duration getDuration();

    public FailureTrace getFailureTrace();

    public ITestSuiteElement getParent();

    public String getTestName();

    public String getDisplayName();

    public static final class FailureTrace {
        private final String fActual;
        private final String fExpected;
        private final String fTrace;

        public FailureTrace(String trace, String expected, String actual) {
            this.fActual = actual;
            this.fExpected = expected;
            this.fTrace = trace;
        }

        public String getTrace() {
            return this.fTrace;
        }

        public String getExpected() {
            return this.fExpected;
        }

        public String getActual() {
            return this.fActual;
        }

        public boolean isComparisonFailure() {
            return (this.fExpected != null || this.fActual != null) && !Objects.equals(this.fActual, this.fExpected);
        }
    }

    public static enum Result {
        UNDEFINED("Undefined"),
        OK("OK"),
        ERROR("Error"),
        FAILURE("Failure"),
        IGNORED("Ignored");

        private final String fName;

        private Result(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

