/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.junitXmlReport;

import java.time.Duration;
import java.time.Instant;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.ModelMessages;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.model.ITestElement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestRunHandler
extends DefaultHandler {
    private int fId;
    private TestRunSession fTestRunSession;
    private TestSuiteElement fTestSuite;
    private TestCaseElement fTestCase;
    private final Stack<Boolean> fNotRun = new Stack();
    private StringBuilder fFailureBuffer;
    private boolean fInExpected;
    private boolean fInActual;
    private StringBuilder fExpectedBuffer;
    private StringBuilder fActualBuffer;
    private Locator fLocator;
    private ITestElement.Result fStatus;
    private final IProgressMonitor fMonitor;
    private int fLastReportedLine;

    public TestRunHandler() {
        this.fMonitor = new NullProgressMonitor();
    }

    public TestRunHandler(IProgressMonitor monitor) {
        this.fMonitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int line;
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fLocator != null && (line = this.fLocator.getLineNumber()) - 20 >= this.fLastReportedLine) {
            line -= line % 20;
            this.fLastReportedLine = line;
            this.fMonitor.subTask(NLS.bind((String)ModelMessages.TestRunHandler_lines_read, (Object)line));
        }
        if (Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        switch (qName) {
            case "testrun": {
                if (this.fTestRunSession == null) {
                    String name = attributes.getValue("name");
                    String launchConfigName = attributes.getValue("launch_config_name");
                    ILaunchConfiguration launchConfiguration = null;
                    if (launchConfigName != null) {
                        try {
                            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                            int n = iLaunchConfigurationArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                                if (config.getName().equals(launchConfigName)) {
                                    launchConfiguration = config;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            UnitTestPlugin.log(e);
                        }
                    }
                    this.fTestRunSession = new TestRunSession(name, Instant.parse(attributes.getValue("startTime")), launchConfiguration);
                    this.readDuration(this.fTestRunSession, attributes);
                } else {
                    this.fTestRunSession.reset();
                }
                this.fTestSuite = this.fTestRunSession;
                break;
            }
            case "testsuite": {
                String name = attributes.getValue("name");
                String pack = attributes.getValue("package");
                String suiteName = pack == null ? name : pack + "." + name;
                String displayName = attributes.getValue("displayname");
                String data = attributes.getValue("data");
                if (data != null && data.isBlank()) {
                    data = null;
                }
                this.fTestSuite = (TestSuiteElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), suiteName, true, null, false, displayName, data);
                this.readDuration(this.fTestSuite, attributes);
                this.fNotRun.push(Boolean.valueOf(attributes.getValue("incomplete")));
                break;
            }
            case "testcase": {
                String name = attributes.getValue("name");
                String classname = attributes.getValue("classname");
                String testName = name + "(" + classname + ")";
                boolean isDynamicTest = Boolean.valueOf(attributes.getValue("dynamicTest"));
                String displayName = attributes.getValue("displayname");
                String data = attributes.getValue("data");
                if (data != null && data.isBlank()) {
                    data = null;
                }
                this.fTestCase = (TestCaseElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), testName, false, 1, isDynamicTest, displayName, data);
                this.fNotRun.push(Boolean.valueOf(attributes.getValue("incomplete")));
                this.fTestCase.setIgnored(Boolean.parseBoolean(attributes.getValue("ignored")));
                this.readDuration(this.fTestCase, attributes);
                break;
            }
            case "error": {
                this.fStatus = ITestElement.Result.ERROR;
                this.fFailureBuffer = new StringBuilder();
                break;
            }
            case "failure": {
                this.fStatus = ITestElement.Result.FAILURE;
                this.fFailureBuffer = new StringBuilder();
                break;
            }
            case "expected": {
                this.fInExpected = true;
                this.fExpectedBuffer = new StringBuilder();
                break;
            }
            case "actual": {
                this.fInActual = true;
                this.fActualBuffer = new StringBuilder();
                break;
            }
            case "skipped": {
                this.fStatus = ITestElement.Result.OK;
                this.fFailureBuffer = new StringBuilder();
                String message = attributes.getValue("message");
                if (message == null) break;
                this.fFailureBuffer.append(message).append('\n');
                break;
            }
            default: {
                throw new SAXParseException("unknown node '" + qName + "'", this.fLocator);
            }
            case "testsuites": 
            case "property": 
            case "properties": 
            case "system-err": 
            case "system-out": 
        }
    }

    private void readDuration(ITestElement testElement, Attributes attributes) {
        if (testElement instanceof TestElement) {
            TestElement element = (TestElement)testElement;
            String timeString = attributes.getValue("time");
            if (timeString != null) {
                try {
                    double seconds = Double.parseDouble(timeString);
                    long millis = (long)(seconds * 1000.0);
                    element.setDuration(Duration.ofMillis(millis));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fInExpected) {
            this.fExpectedBuffer.append(ch, start, length);
        } else if (this.fInActual) {
            this.fActualBuffer.append(ch, start, length);
        } else if (this.fFailureBuffer != null) {
            this.fFailureBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "testsuite": {
                this.handleTestElementEnd(this.fTestSuite);
                this.fTestSuite = this.fTestSuite.getParent();
                break;
            }
            case "testcase": {
                this.handleTestElementEnd(this.fTestCase);
                this.fTestCase = null;
                break;
            }
            case "failure": 
            case "error": {
                TestElement testElement = this.fTestCase;
                if (testElement == null) {
                    testElement = this.fTestSuite;
                }
                this.handleFailure(testElement);
                break;
            }
            case "expected": {
                this.fInExpected = false;
                if (this.fFailureBuffer == null) break;
                this.fFailureBuffer.setLength(0);
                break;
            }
            case "actual": {
                this.fInActual = false;
                if (this.fFailureBuffer == null) break;
                this.fFailureBuffer.setLength(0);
                break;
            }
            case "skipped": {
                TestElement testElement = this.fTestCase;
                if (testElement == null) {
                    testElement = this.fTestSuite;
                }
                if (this.fFailureBuffer != null && this.fFailureBuffer.length() > 0) {
                    this.handleFailure(testElement);
                    testElement.setAssumptionFailed(true);
                    break;
                }
                if (this.fTestCase != null) {
                    this.fTestCase.setIgnored(true);
                    break;
                }
                testElement.setAssumptionFailed(true);
                break;
            }
            default: {
                this.handleUnknownNode(qName);
            }
            case "testsuites": 
            case "testrun": 
            case "property": 
            case "properties": 
            case "system-err": 
            case "system-out": 
        }
    }

    private void handleTestElementEnd(ITestElement testElement) {
        boolean completed = this.fNotRun.pop() == false;
        this.fTestRunSession.registerTestEnded((TestElement)testElement, completed);
    }

    private void handleFailure(ITestElement testElement) {
        if (this.fFailureBuffer != null) {
            this.fTestRunSession.registerTestFailureStatus((TestElement)testElement, this.fStatus, new ITestElement.FailureTrace(this.fFailureBuffer.toString(), this.toString(this.fExpectedBuffer), this.toString(this.fActualBuffer)));
            this.fFailureBuffer = null;
            this.fExpectedBuffer = null;
            this.fActualBuffer = null;
            this.fStatus = null;
        }
    }

    private String toString(StringBuilder buffer) {
        return buffer != null ? buffer.toString() : null;
    }

    private void handleUnknownNode(String qName) throws SAXException {
        String msg = "unknown node '" + qName + "'";
        if (this.fLocator != null) {
            msg = msg + " at line " + this.fLocator.getLineNumber() + ", column " + this.fLocator.getColumnNumber();
        }
        throw new SAXException(msg);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    private String getNextId() {
        return Integer.toString(this.fId++);
    }

    public TestRunSession getTestRunSession() {
        return this.fTestRunSession;
    }
}

