/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.util.SequenceResolver;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.internal.intro.impl.model.ExtensionMap;
import org.eclipse.ui.internal.intro.universal.CustomizeAction;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.IUniversalIntroConstants;
import org.eclipse.ui.internal.intro.universal.IntroData;
import org.eclipse.ui.internal.intro.universal.Messages;
import org.eclipse.ui.internal.intro.universal.PageData;
import org.eclipse.ui.internal.intro.universal.UniversalIntroPlugin;
import org.eclipse.ui.internal.intro.universal.contentdetect.ContentDetector;
import org.eclipse.ui.internal.intro.universal.util.ImageUtil;
import org.eclipse.ui.internal.intro.universal.util.PreferenceArbiter;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IntroConfigurer;
import org.eclipse.ui.intro.config.IntroElement;
import org.osgi.framework.Bundle;

public class UniversalIntroConfigurer
extends IntroConfigurer
implements IUniversalIntroConstants {
    private IntroData primaryIntroData;
    private IntroData[] secondaryIntroData;
    private SequenceResolver<IntroElement> sequenceResolver;

    public UniversalIntroConfigurer() {
        this.loadData();
    }

    public String getVariable(String variableName) {
        if (variableName.equals("high-contrast")) {
            boolean highContrast = ImageUtil.isHighContrast();
            if (highContrast) {
                return variableName;
            }
            return "";
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            String value = this.getProductProperty(product, variableName);
            if (value != null) {
                value = this.resolveVariable(product.getDefiningBundle(), value);
                return value;
            }
            if (variableName.startsWith("introDescription")) {
                return "";
            }
            String key = String.valueOf(product.getId()) + "_" + variableName;
            value = Platform.getPreferencesService().getString("org.eclipse.ui.intro.universal", key, "", null);
            if (value.length() == 0) {
                key = variableName;
                value = Platform.getPreferencesService().getString("org.eclipse.ui.intro.universal", key, "", null);
            }
            value = value.length() > 0 ? this.resolveVariable(product.getDefiningBundle(), value) : this.getThemeProperty(variableName);
            return value;
        }
        return null;
    }

    public String getMixinStyle(String pageId, String extensionId) {
        int importance;
        if (this.primaryIntroData != null && (importance = this.getImportance(this.primaryIntroData, pageId, extensionId)) >= 0) {
            return ExtensionData.IMPORTANCE_STYLE_TABLE[importance];
        }
        int[] importanceRefs = new int[ExtensionData.IMPORTANCE_TABLE.length];
        int i = 0;
        while (i < this.secondaryIntroData.length) {
            IntroData data = this.secondaryIntroData[i];
            int importance2 = this.getImportance(data, pageId, extensionId);
            if (importance2 >= 0) {
                int n = importance2;
                importanceRefs[n] = importanceRefs[n] + 1;
            }
            ++i;
        }
        int maxIndex = 0;
        int i2 = 1;
        while (i2 < importanceRefs.length) {
            if (importanceRefs[i2] > importanceRefs[maxIndex]) {
                maxIndex = i2;
            }
            ++i2;
        }
        if (importanceRefs[maxIndex] > 0) {
            return ExtensionData.IMPORTANCE_STYLE_TABLE[maxIndex];
        }
        return null;
    }

    private int getImportance(IntroData data, String pageId, String extensionId) {
        ExtensionData ed;
        String pluginId = ExtensionMap.getInstance().getPluginId(extensionId);
        if (ContentDetector.isNew(pluginId)) {
            this.updateStartPage(pageId);
            return 4;
        }
        PageData pdata = data.getPage(pageId);
        if (pdata != null && (ed = pdata.findExtension(extensionId, false)) != null) {
            return ed.getImportance();
        }
        return -1;
    }

    private void updateStartPage(String pageId) {
        String currentStartPage = ExtensionMap.getInstance().getStartPage();
        String ids = this.getVariable("INTRO_ROOT_PAGES");
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                if (id.equals(pageId)) {
                    ExtensionMap.getInstance().setStartPage(pageId);
                    return;
                }
                if (!id.equals(currentStartPage)) continue;
                return;
            }
        }
    }

    private String resolveVariable(Bundle bundle, String value) {
        if (value == null) {
            return null;
        }
        try {
            if (value.startsWith("intro:")) {
                bundle = UniversalIntroPlugin.getDefault().getBundle();
                return this.resolveFile(bundle, value.substring(6));
            }
            if (value.startsWith("product:")) {
                return this.resolveFile(bundle, value.substring(8));
            }
        }
        catch (IOException iOException) {}
        return value;
    }

    private String resolveFile(Bundle bundle, String path) throws IOException {
        String prefixedPath = this.getThemePrefixedPath(path);
        URL url = null;
        if (prefixedPath != null) {
            url = bundle.getEntry(prefixedPath);
        }
        if (url == null) {
            url = bundle.getEntry(path);
        }
        if (url != null) {
            URL localURL = FileLocator.toFileURL((URL)url);
            return localURL.toString();
        }
        return null;
    }

    private String getThemePrefixedPath(String path) {
        String prefix = this.themeProperties != null ? (String)this.themeProperties.get("id") : null;
        String string = prefix = prefix == null ? "" : prefix.trim();
        if (prefix.length() == 0) {
            return null;
        }
        return String.valueOf(prefix) + '/' + path;
    }

    private String getProductProperty(IProduct product, String variableName) {
        String value = product.getProperty(variableName);
        if (value == null && variableName.equals("INTRO_BACKGROUND_IMAGE")) {
            return "css/graphics/root/welcomebckgrd.jpg";
        }
        return value;
    }

    public IntroElement[] getGroupChildren(String pageId, String groupId) {
        boolean rootLike;
        boolean bl = rootLike = pageId.equals("root") || this.isStartPage(pageId) || pageId.equals("standby");
        if (rootLike && groupId.equals("page-links")) {
            return this.getRootPageLinks(pageId.equals("standby"));
        }
        if (rootLike && groupId.equals("action-links")) {
            return this.getRootPageActionLinks(pageId.equals("standby"));
        }
        if (groupId.equals("page-links")) {
            return this.getNavLinks(pageId);
        }
        if (groupId.equals("top-left") || groupId.equals("top-right") || groupId.equals("bottom-left") || groupId.equals("bottom-right")) {
            return this.getContent(pageId, groupId);
        }
        return new IntroElement[0];
    }

    public IntroElement[] getLaunchBarShortcuts() {
        ArrayList<IntroElement> links = new ArrayList<IntroElement>();
        String ids = this.getVariable("INTRO_ROOT_PAGES");
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                IntroElement page = this.createLaunchBarShortcut(id);
                if (page == null) continue;
                links.add(page);
            }
        }
        return links.toArray(new IntroElement[links.size()]);
    }

    private IntroElement[] getRootPageLinks(boolean standby) {
        IntroElement page;
        String wb;
        ArrayList<IntroElement> links = new ArrayList<IntroElement>();
        String ids = this.getVariable("INTRO_ROOT_PAGES");
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                IntroElement page2 = this.createRootPageLink(id, standby);
                if (page2 == null) continue;
                links.add(page2);
            }
        }
        if ((wb = this.getVariable("workbenchAsRootLink")) != null && wb.equalsIgnoreCase("true") && (page = this.createRootPageLink("workbench", standby)) != null) {
            links.add(page);
        }
        return links.toArray(new IntroElement[links.size()]);
    }

    private IntroElement[] getRootPageActionLinks(boolean standby) {
        IntroElement page;
        String wb = this.getVariable("workbenchAsRootLink");
        if (!(wb != null && wb.equalsIgnoreCase("true") || (page = this.createRootPageLink("workbench", standby)) == null)) {
            return new IntroElement[]{page};
        }
        return new IntroElement[0];
    }

    private IntroElement[] getNavLinks(String pageId) {
        ArrayList<IntroElement> links = new ArrayList<IntroElement>();
        String ids = this.getVariable("INTRO_ROOT_PAGES");
        if (ImageUtil.isHighContrast()) {
            ids = String.valueOf(ids) + ',' + "workbench";
        }
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            int[] counter = new int[1];
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                IntroElement page = this.createNavLink(id, pageId, counter);
                if (page == null) continue;
                links.add(page);
            }
        }
        return links.toArray(new IntroElement[links.size()]);
    }

    private IntroElement createRootPageLink(String id, boolean standby) {
        if (id.equals("overview")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_overview_name, this.createPageURL(id, standby), id, "overview_img", "$theme$/graphics/root/overview.gif", Messages.SharedIntroConfigurer_overview_alt, Messages.SharedIntroConfigurer_overview_tooltip, "left");
        }
        if (id.equals("firststeps")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_firststeps_name, this.createPageURL(id, standby), id, "firststeps_img", "$theme$/graphics/root/firststeps.gif", Messages.SharedIntroConfigurer_firststeps_alt, Messages.SharedIntroConfigurer_firststeps_tooltip, "left");
        }
        if (id.equals("tutorials")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_tutorials_name, this.createPageURL(id, standby), id, "tutorials_img", "$theme$/graphics/root/tutorials.gif", Messages.SharedIntroConfigurer_tutorials_alt, Messages.SharedIntroConfigurer_tutorials_tooltip, "left");
        }
        if (id.equals("samples")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_samples_name, this.createPageURL(id, standby), id, "samples_img", "$theme$/graphics/root/samples.gif", Messages.SharedIntroConfigurer_samples_alt, Messages.SharedIntroConfigurer_samples_tooltip, "right");
        }
        if (id.equals("whatsnew")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_whatsnew_name, this.createPageURL(id, standby), id, "whatsnew_img", "$theme$/graphics/root/whatsnew.gif", Messages.SharedIntroConfigurer_whatsnew_alt, Messages.SharedIntroConfigurer_whatsnew_tooltip, "right");
        }
        if (id.equals("migrate")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_migrate_name, this.createPageURL(id, standby), id, "migrate_img", "$theme$/graphics/root/migrate.gif", Messages.SharedIntroConfigurer_migrate_alt, Messages.SharedIntroConfigurer_migrate_tooltip, "right");
        }
        if (id.equals("webresources")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_webresources_name, this.createPageURL(id, standby), id, "webresources_img", "css/graphics/root/webresources.gif", Messages.SharedIntroConfigurer_webresources_alt, Messages.SharedIntroConfigurer_webresources_tooltip, "right");
        }
        if (id.equals("workbench")) {
            return this.createRootLink(Messages.SharedIntroConfigurer_workbench_name, "http://org.eclipse.ui.intro/switchToLaunchBar", id, "workbench_img", "css/graphics/root/workbench.gif", Messages.SharedIntroConfigurer_workbench_alt, Messages.SharedIntroConfigurer_workbench_tooltip, "right");
        }
        return null;
    }

    private IntroElement createNavLink(String id, String pageId, int[] counter) {
        if (id.equals("overview")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_overview_nav, this.createPageURL(id, false), id, "left nav_link" + counter[0]);
        }
        if (id.equals("firststeps")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_firststeps_nav, this.createPageURL(id, false), id, "left  nav_link" + counter[0]);
        }
        if (id.equals("tutorials")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_tutorials_nav, this.createPageURL(id, false), id, "left nav_link" + counter[0]);
        }
        if (id.equals("samples")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_samples_nav, this.createPageURL(id, false), id, "right nav_link" + counter[0]);
        }
        if (id.equals("whatsnew")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_whatsnew_nav, this.createPageURL(id, false), id, "right nav_link" + counter[0]);
        }
        if (id.equals("migrate")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_migrate_nav, this.createPageURL(id, false), id, "right nav_link" + counter[0]);
        }
        if (id.equals("webresources")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_webresources_nav, this.createPageURL(id, false), id, "right nav_link" + counter[0]);
        }
        if (id.equals("workbench")) {
            counter[0] = counter[0] + 1;
            return this.createNavLink(Messages.SharedIntroConfigurer_workbench_name, "http://org.eclipse.ui.intro/switchToLaunchBar", id, "right nav_link" + counter[0]);
        }
        return null;
    }

    private String createPageURL(String id, boolean standby) {
        String url = "http://org.eclipse.ui.intro/showPage?id=" + id;
        if (standby) {
            url = String.valueOf(url) + "&standby=false";
        }
        return url;
    }

    private IntroElement createLaunchBarShortcut(String id) {
        if (id.equals("overview")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarOverviewIcon"), Messages.SharedIntroConfigurer_overview_nav, id);
        }
        if (id.equals("firststeps")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarFirststepsIcon"), Messages.SharedIntroConfigurer_firststeps_nav, id);
        }
        if (id.equals("tutorials")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarTutorialsIcon"), Messages.SharedIntroConfigurer_tutorials_nav, id);
        }
        if (id.equals("samples")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarSamplesIcon"), Messages.SharedIntroConfigurer_samples_nav, id);
        }
        if (id.equals("whatsnew")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarWhatsnewIcon"), Messages.SharedIntroConfigurer_whatsnew_nav, id);
        }
        if (id.equals("migrate")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarMigrateIcon"), Messages.SharedIntroConfigurer_migrate_nav, id);
        }
        if (id.equals("webresources")) {
            return this.createShortcutLink(this.getThemeProperty("launchbarWebresourcesIcon"), Messages.SharedIntroConfigurer_webresources_nav, id);
        }
        return null;
    }

    private IntroElement createRootLink(String name, String url, String id, String imgId, String imgSrc, String imgAlt, String imgText, String styleId) {
        String key;
        String value;
        IntroElement element = new IntroElement("link");
        element.setAttribute("label", name);
        element.setAttribute("url", url);
        element.setAttribute("id", id);
        element.setAttribute("style-id", styleId);
        IntroElement img = new IntroElement("img");
        img.setAttribute("id", imgId);
        img.setAttribute("style-id", "content-img");
        boolean highContrast = ImageUtil.isHighContrast();
        if (highContrast && (value = this.getVariable(key = "highContrast-" + id)) != null) {
            img.setAttribute("src", value);
        }
        img.setAttribute("alt", imgAlt);
        img.setAttribute("title", "");
        IntroElement text = new IntroElement("text");
        text.setValue(imgText);
        element.addChild(img);
        element.addChild(text);
        return element;
    }

    private IntroElement createNavLink(String label, String url, String id, String styleId) {
        IntroElement element = new IntroElement("link");
        element.setAttribute("label", label);
        element.setAttribute("url", url);
        element.setAttribute("id", id);
        boolean highContrast = ImageUtil.isHighContrast();
        if (highContrast) {
            IntroElement img = new IntroElement("img");
            img.setAttribute("style-id", "content-img");
            String key = "highContrastNav-" + id;
            String value = this.getVariable(key);
            if (value != null) {
                img.setAttribute("src", value);
            }
            img.setAttribute("alt", label);
            element.addChild(img);
            styleId = String.valueOf(styleId) + " high-contrast";
        }
        element.setAttribute("style-id", styleId);
        return element;
    }

    private IntroElement createShortcutLink(String icon, String tooltip, String id) {
        IntroElement element = new IntroElement("shortcut");
        element.setAttribute("icon", icon);
        element.setAttribute("tooltip", tooltip);
        element.setAttribute("url", this.createPageURL(id, false));
        return element;
    }

    private void loadData() {
        String dataFile;
        IProduct product = Platform.getProduct();
        if (product != null && (dataFile = this.getVariable("INTRO_DATA")) != null) {
            this.primaryIntroData = new IntroData(product.getId(), dataFile, true);
        }
        ArrayList<IntroData> result = new ArrayList<IntroData>();
        Properties[] prefs = ProductPreferences.getProductPreferences((boolean)false);
        int i = 0;
        while (i < prefs.length) {
            String pluginId;
            Bundle bundle;
            String key = "org.eclipse.ui.intro.universal/INTRO_DATA";
            String dataFile2 = prefs[i].getProperty(key);
            if (dataFile2 != null && (bundle = Platform.getBundle((String)(pluginId = ProductPreferences.getPluginId((Properties)prefs[i])))) != null) {
                String pid = ProductPreferences.getProductId((Properties)prefs[i]);
                dataFile2 = this.resolveVariable(bundle, dataFile2);
                result.add(new IntroData(pid, dataFile2, false));
            }
            ++i;
        }
        this.secondaryIntroData = result.toArray(new IntroData[result.size()]);
    }

    private IntroElement[] getContent(String pageId, String groupId) {
        List<IntroElement> anchors;
        ArrayList<IntroElement> result = new ArrayList<IntroElement>();
        if (!ContentDetector.getNewContributors().isEmpty()) {
            IntroElement fallback = new IntroElement("anchor");
            fallback.setAttribute("id", "newContentAnchor");
            result.add(fallback);
        }
        if ((anchors = this.getAnchors(pageId, groupId)) != null) {
            result.addAll(anchors);
        }
        IntroElement fallback = new IntroElement("anchor");
        fallback.setAttribute("id", "defaultAnchor");
        result.add(fallback);
        return result.toArray(new IntroElement[result.size()]);
    }

    private List<IntroElement> getAnchors(String pageId, String groupId) {
        List<Object> primaryAnchors = null;
        if (this.primaryIntroData != null) {
            primaryAnchors = this.getAnchors(this.primaryIntroData, pageId, groupId);
        }
        if (primaryAnchors == null) {
            primaryAnchors = Collections.emptyList();
        }
        ArrayList<List<IntroElement>> secondaryAnchorsList = new ArrayList<List<IntroElement>>();
        int i = 0;
        while (i < this.secondaryIntroData.length) {
            IntroData idata = this.secondaryIntroData[i];
            List<IntroElement> anchors = this.getAnchors(idata, pageId, groupId);
            if (anchors != null) {
                secondaryAnchorsList.add(anchors);
            }
            ++i;
        }
        List[] secondaryAnchors = secondaryAnchorsList.toArray(new List[secondaryAnchorsList.size()]);
        if (this.sequenceResolver == null) {
            this.sequenceResolver = new SequenceResolver();
        }
        return this.sequenceResolver.getSequence(primaryAnchors, secondaryAnchors);
    }

    private List<IntroElement> getAnchors(IntroData data, String pageId, String groupId) {
        PageData pdata = data.getPage(pageId);
        if (pdata != null) {
            ArrayList<IntroElement> anchors = new ArrayList<IntroElement>();
            pdata.addAnchors(anchors, groupId);
            return anchors;
        }
        return null;
    }

    public String resolvePath(String extensionId, String path) {
        boolean extensionRelativePath = false;
        Path ipath = new Path(path);
        String pageId = ipath.segment(0);
        String s2 = ipath.segment(1);
        if (s2.startsWith("@") && s2.length() > 1) {
            extensionId = s2.substring(1);
        }
        if (!s2.equals("@")) {
            extensionRelativePath = true;
        }
        if (!this.isHidden(extensionId, pageId)) {
            String resolvedPath = this.resolveExtensionPath(extensionId, pageId);
            if (resolvedPath != null) {
                if (extensionRelativePath) {
                    Path p2 = new Path(resolvedPath);
                    IPath p1 = ipath.removeFirstSegments(2);
                    resolvedPath = p2.removeLastSegments(1).append(p1).toString();
                }
                return resolvedPath;
            }
            return String.valueOf(pageId) + "/page-content/bottom-left/defaultAnchor";
        }
        return null;
    }

    private String resolveExtensionPath(String extensionId, String pageId) {
        String path;
        PageData pdata;
        if (this.primaryIntroData != null && (pdata = this.primaryIntroData.getPage(pageId)) != null && (path = pdata.resolvePath(extensionId)) != null) {
            return path;
        }
        PreferenceArbiter arbiter = new PreferenceArbiter();
        int i = 0;
        while (i < this.secondaryIntroData.length) {
            IntroData idata = this.secondaryIntroData[i];
            PageData pdata2 = idata.getPage(pageId);
            if (pdata2 != null) {
                arbiter.consider(pdata2.resolvePath(extensionId));
            }
            ++i;
        }
        String path2 = (String)arbiter.getWinner();
        if (path2 != null) {
            return path2;
        }
        return this.resolveDefaultPath(pageId, extensionId);
    }

    private String resolveDefaultPath(String pageId, String extensionId) {
        String path;
        PageData pdata;
        String pluginId = ExtensionMap.getInstance().getPluginId(extensionId);
        if (ContentDetector.isNew(pluginId)) {
            return String.valueOf(pageId) + "/page-content/top-left/newContentAnchor";
        }
        if (this.primaryIntroData != null && (pdata = this.primaryIntroData.getPage(pageId)) != null && (path = pdata.resolveDefaultPath()) != null) {
            return path;
        }
        PreferenceArbiter arbiter = new PreferenceArbiter();
        int i = 0;
        while (i < this.secondaryIntroData.length) {
            IntroData idata = this.secondaryIntroData[i];
            PageData pdata2 = idata.getPage(pageId);
            if (pdata2 != null) {
                arbiter.consider(pdata2.resolveDefaultPath());
            }
            ++i;
        }
        return (String)arbiter.getWinner();
    }

    private boolean isHidden(String extensionId, String pageId) {
        PageData pdata;
        if (this.primaryIntroData != null && (pdata = this.primaryIntroData.getPage(pageId)) != null) {
            return pdata.isHidden(extensionId);
        }
        return false;
    }

    public void init(IIntroSite site, Map<String, String> themeProperties) {
        super.init(site, themeProperties);
        CustomizeAction customizeAction = new CustomizeAction(site);
        customizeAction.setText(Messages.SharedIntroConfigurer_customize_label);
        customizeAction.setToolTipText(Messages.SharedIntroConfigurer_customize_text);
        customizeAction.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/configure.png"));
        site.getActionBars().getToolBarManager().appendToGroup("additions", (IAction)customizeAction);
    }
}

