/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.examples.filesystem.Policy;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NestedProjectCreator {
    private IRunnableContext context = PlatformUI.getWorkbench().getProgressService();
    protected boolean excludeOverlap = true;
    protected final IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public void createNestedProjects(IProject[] projects, Shell parentShell) {
        try {
            this.doCreateNestedProjects(projects, parentShell);
        }
        catch (InvocationTargetException e) {
            IStatus status = this.getStatus(e.getTargetException());
            Policy.log(status);
            ErrorDialog.openError((Shell)parentShell, null, null, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void doCreateNestedProjects(final IProject[] projects, Shell shell) throws InvocationTargetException, InterruptedException {
        final Object[] result = new Object[1];
        this.context.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                result[0] = NestedProjectCreator.this.findNestedProjects(projects);
            }
        });
        if (result[0] == null) {
            return;
        }
        IProjectDescription[] rawDescriptions = (IProjectDescription[])result[0];
        if (rawDescriptions.length == 0) {
            return;
        }
        final IProjectDescription[] finalDescriptions = this.promptForCreation(shell, rawDescriptions);
        if (finalDescriptions.length == 0) {
            return;
        }
        String message = "Should the folder corresponding to the created projects be excluded from the existing parent project?";
        this.excludeOverlap = MessageDialog.openQuestion((Shell)shell, (String)"Exclude overlapping resources?", (String)message);
        final IWorkspaceRoot root = this.workspace.getRoot();
        this.context.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("Creating Projects", finalDescriptions.length * 2);
                    int i = 0;
                    while (i < finalDescriptions.length) {
                        IProject project = root.getProject(finalDescriptions[i].getName());
                        if (NestedProjectCreator.this.excludeOverlap) {
                            NestedProjectCreator.this.excludeOverlap(finalDescriptions[i]);
                        }
                        project.create(finalDescriptions[i], (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                        project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    protected void excludeOverlap(IProjectDescription description) throws CoreException {
        URI nullURI;
        URI location = description.getLocationURI();
        if (location == null) {
            URI rootLocation = this.workspace.getRoot().getLocationURI();
            location = EFS.getStore((URI)rootLocation).getChild(description.getName()).toURI();
        }
        IContainer[] containers = this.workspace.getRoot().findContainersForLocationURI(location);
        try {
            nullURI = new URI("null", null, "/", null, null);
        }
        catch (URISyntaxException e) {
            Policy.log("Cannot exclude resource due to missing null file system", e);
            return;
        }
        int i = 0;
        while (i < containers.length) {
            IFolder folder;
            if (containers[i].getType() == 2 && !(folder = (IFolder)containers[i]).isLinked()) {
                folder.createLink(nullURI, 272, null);
            }
            ++i;
        }
    }

    public IProjectDescription[] findNestedProjects(IProject[] projects) {
        final ArrayList descriptions = new ArrayList();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                try {
                    projects[i].accept(new IResourceProxyVisitor(){

                        private void addDescription(ArrayList<IProjectDescription> descriptions2, IProjectDescription description) {
                            IProject project = NestedProjectCreator.this.workspace.getRoot().getProject(description.getName());
                            if (!project.exists()) {
                                descriptions2.add(description);
                            }
                        }

                        private void searchInLink(IResource link) {
                            IFileStore projectStore;
                            IProject project = link.getProject();
                            if (project == null || !project.isAccessible()) {
                                return;
                            }
                            try {
                                projectStore = EFS.getStore((URI)project.getLocationURI());
                            }
                            catch (CoreException coreException) {
                                return;
                            }
                            IFileStore linkStore = projectStore.getFileStore(link.getProjectRelativePath());
                            this.searchInStore(linkStore);
                        }

                        private void searchInStore(IFileStore store) {
                            try {
                                IFileInfo info;
                                if (store.getName().equals(".project") && !(info = store.fetchInfo()).isDirectory()) {
                                    try {
                                        Throwable throwable = null;
                                        Object var4_6 = null;
                                        try (InputStream input = store.openInputStream(0, null);){
                                            IProjectDescription description = NestedProjectCreator.this.workspace.loadProjectDescription(input);
                                            description.setLocationURI(store.getParent().toURI());
                                            this.addDescription(descriptions, description);
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                                IFileStore[] children = store.childStores(0, null);
                                int j = 0;
                                while (j < children.length) {
                                    this.searchInStore(children[j]);
                                    ++j;
                                }
                            }
                            catch (CoreException coreException) {}
                        }

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getType() == 1 && proxy.getName().equals(".project")) {
                                IFile file = (IFile)proxy.requestResource();
                                try {
                                    Throwable throwable = null;
                                    Object var4_5 = null;
                                    try (InputStream input = file.getContents();){
                                        IProjectDescription description = NestedProjectCreator.this.workspace.loadProjectDescription(input);
                                        description.setLocationURI(file.getParent().getLocationURI());
                                        this.addDescription(descriptions, description);
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException | CoreException throwable) {}
                            } else if (proxy.isLinked()) {
                                this.searchInLink(proxy.requestResource());
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return descriptions.toArray(new IProjectDescription[descriptions.size()]);
    }

    private ILabelProvider getProjectDescriptionLabelProvider() {
        return new LabelProvider(){
            private final LabelProvider realProvider = new WorkbenchLabelProvider();
            private final IWorkspaceRoot root;
            {
                this.root = NestedProjectCreator.this.workspace.getRoot();
            }

            public Image getImage(Object element) {
                return this.realProvider.getImage(this.getProject(element));
            }

            private Object getProject(Object element) {
                if (element instanceof IProjectDescription) {
                    return this.root.getProject(((IProjectDescription)element).getName());
                }
                return null;
            }

            public String getText(Object element) {
                return this.realProvider.getText(this.getProject(element));
            }
        };
    }

    private IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            return ((CoreException)t).getStatus();
        }
        return new Status(4, "org.eclipse.ui.examples.filesystem", 1, "Internal Error", t);
    }

    public IProjectDescription[] promptForCreation(Shell parentShell, IProjectDescription[] descriptions) {
        String message = "The following projects were found. Select the projects to be created.";
        ListSelectionDialog dialog = ListSelectionDialog.of((Object)descriptions).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).labelProvider(this.getProjectDescriptionLabelProvider()).message(message).create(parentShell);
        dialog.open();
        Object[] result = dialog.getResult();
        IProjectDescription[] castedResult = new IProjectDescription[result.length];
        System.arraycopy(result, 0, castedResult, 0, result.length);
        return castedResult;
    }

    public void setRunnableContext(IRunnableContext rc) {
        this.context = rc != null ? rc : PlatformUI.getWorkbench().getProgressService();
    }
}

