/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.filesystem;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExpandZipHandler
extends AbstractHandler {
    private void expandZip(IFile file, Shell shell) {
        try {
            URI zipURI = new URI("zip", null, "/", file.getLocationURI().toString(), null);
            IFolder link = file.getParent().getFolder((IPath)new Path(file.getName()));
            link.createLink(zipURI, 256, null);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error opening zip file");
            e.printStackTrace();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IFile)) {
            return null;
        }
        this.expandZip((IFile)element, shell);
        return null;
    }
}

