/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.memory;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.memory.MemoryFileStore;
import org.eclipse.core.internal.filesystem.memory.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MemoryTreeSelectionDialog
extends SelectionDialog {
    private static final int CREATE_FILE_ID = 16;
    private static final int CREATE_FOLDER_ID = 17;
    private Text nameField;
    TreeViewer tree;

    protected MemoryTreeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 16 || buttonId == 17) {
            try {
                IFileStore parent = this.getSelectedFileStore();
                Object toCreate = parent != null ? parent.getChild(this.nameField.getText()) : new MemoryFileStore(Path.ROOT.append(this.nameField.getText()));
                if (buttonId == 16) {
                    toCreate.openOutputStream(0, null).close();
                } else {
                    toCreate.mkdir(0, null);
                }
                this.tree.refresh();
            }
            catch (Exception e) {
                IStatus status = Policy.createStatus(e);
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
                Policy.log(status);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select an element from the in-memory file system");
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.tree = new TreeViewer(top, 2052);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tree.setInput((Object)new MemoryFileStore((IPath)Path.ROOT));
        this.createNewElementArea(parent);
        return top;
    }

    private void createNewElementArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        new Label(area, 0).setText("Name: ");
        this.nameField = new Text(area, 2052);
        GridData data = new GridData();
        data.widthHint = 200;
        this.nameField.setLayoutData((Object)data);
        this.createButton(area, 16, "New File", false);
        this.createButton(area, 17, "New Folder", false);
    }

    private IFileStore getSelectedFileStore() {
        IFileStore selected;
        ISelection selection = this.tree.getSelection();
        if (selection instanceof IStructuredSelection && (selected = (IFileStore)((IStructuredSelection)selection).getFirstElement()) != null) {
            return selected;
        }
        return null;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tree.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

