/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.memory;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.memory.MemoryFileSystem;
import org.eclipse.core.internal.filesystem.memory.MemoryTreeSelectionDialog;
import org.eclipse.core.internal.filesystem.memory.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class MemoryFileSystemContributor
extends FileSystemContributor {
    public URI browseFileSystem(String initialPath, Shell shell) {
        MemoryTreeSelectionDialog dialog = new MemoryTreeSelectionDialog(shell);
        if (dialog.open() != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result.length == 0) {
            return null;
        }
        return ((IFileStore)result[0]).toURI();
    }

    public URI getURI(String string) {
        try {
            if (string.startsWith("memory")) {
                return new URI(string);
            }
        }
        catch (URISyntaxException e) {
            Policy.log(Policy.createStatus(e));
            e.printStackTrace();
        }
        return MemoryFileSystem.toURI((IPath)new Path(string));
    }
}

