/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.memory;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.filesystem.memory.MemoryFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MemoryFileSystem
extends FileSystem {
    public static final String SCHEME_MEMORY = "memory";

    public static URI toURI(IPath path) {
        try {
            return new URI(SCHEME_MEMORY, null, path.setDevice(null).toPortableString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFileStore getStore(URI uri) {
        return new MemoryFileStore(Path.fromPortableString((String)uri.getSchemeSpecificPart()));
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

