/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public abstract class BrandingProperties {
    public static Optional<URL> getUrl(String value, Bundle definingBundle) {
        block3: {
            try {
                if (value != null) {
                    return Optional.of(new URL(value));
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (definingBundle == null) break block3;
                URL bundlePath = FileLocator.find((Bundle)definingBundle, (IPath)IPath.fromOSString((String)value));
                return Optional.of(bundlePath);
            }
        }
        return Optional.empty();
    }

    protected static Optional<ImageDescriptor> getImage(String value, Bundle definingBundle) {
        Optional<URL> url = BrandingProperties.getUrl(value, definingBundle);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url.get());
        return url.isPresent() ? Optional.of(imageDescriptor) : Optional.empty();
    }

    private static List<URL> getURLs(String value, Bundle definingBundle) {
        if (value == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        ArrayList<URL> array = new ArrayList<URL>(10);
        while (tokens.hasMoreTokens()) {
            Optional<URL> urlToken = BrandingProperties.getUrl(tokens.nextToken().trim(), definingBundle);
            if (!urlToken.isPresent()) continue;
            array.add(urlToken.get());
        }
        return array;
    }

    protected static List<ImageDescriptor> getImages(String value, Bundle definingBundle) {
        List<URL> urls = BrandingProperties.getURLs(value, definingBundle);
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        return urls.stream().map(ImageDescriptor::createFromURL).collect(Collectors.toList());
    }
}

