/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class RelationTableMechanism
implements Cloneable,
Serializable {
    protected DatabaseTable relationTable;
    protected List<DatabaseField> sourceKeyFields;
    protected List<DatabaseField> targetKeyFields;
    protected List<DatabaseField> sourceRelationKeyFields;
    protected List<DatabaseField> targetRelationKeyFields;
    protected DataModifyQuery deleteQuery;
    protected boolean hasCustomDeleteQuery = false;
    protected DataModifyQuery insertQuery = new DataModifyQuery();
    protected boolean hasCustomInsertQuery = false;
    protected ReadQuery lockRelationTableQuery;

    public RelationTableMechanism() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = new ArrayList<DatabaseField>(1);
        this.targetRelationKeyFields = new ArrayList<DatabaseField>(1);
        this.sourceKeyFields = new ArrayList<DatabaseField>(1);
        this.targetKeyFields = new ArrayList<DatabaseField>(1);
    }

    public void addSourceRelationKeyField(DatabaseField sourceRelationKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceRelationKeyFields().add(sourceRelationKeyField);
        this.getSourceKeyFields().add(sourcePrimaryKeyField);
    }

    public void addSourceRelationKeyFieldName(String sourceRelationKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addSourceRelationKeyField(new DatabaseField(sourceRelationKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    public void addTargetRelationKeyField(DatabaseField targetRelationKeyField, DatabaseField targetPrimaryKeyField) {
        this.getTargetRelationKeyFields().add(targetRelationKeyField);
        this.getTargetKeyFields().add(targetPrimaryKeyField);
    }

    public void addTargetRelationKeyFieldName(String targetRelationKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addTargetRelationKeyField(new DatabaseField(targetRelationKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    Expression buildSelectionCriteria(ForeignReferenceMapping mapping, Expression criteria) {
        return this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, criteria, true, false);
    }

    Expression buildSelectionCriteriaAndAddFieldsToQuery(ForeignReferenceMapping mapping, Expression criteria) {
        return this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, criteria, true, true);
    }

    public Expression buildSelectionCriteriaAndAddFieldsToQueryInternal(ForeignReferenceMapping mapping, Expression criteria, boolean shouldAddTargetFields, boolean shouldAddFieldsToQuery) {
        Expression expression;
        DatabaseField relationKey;
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression linkTable = ((Expression)builder).getTable(this.relationTable);
        if (shouldAddTargetFields) {
            Iterator<DatabaseField> targetKeyIterator = this.getTargetKeyFields().iterator();
            Iterator<DatabaseField> relationKeyIterator = this.getTargetRelationKeyFields().iterator();
            while (targetKeyIterator.hasNext()) {
                relationKey = relationKeyIterator.next();
                DatabaseField targetKey = targetKeyIterator.next();
                expression = ((Expression)builder).getField(targetKey).equal(linkTable.getField(relationKey));
                if (criteria == null) {
                    criteria = expression;
                    continue;
                }
                criteria = expression.and(criteria);
            }
        }
        Iterator<DatabaseField> relationKeyIterator = this.getSourceRelationKeyFields().iterator();
        Iterator<DatabaseField> sourceKeyIterator = this.getSourceKeyFields().iterator();
        while (relationKeyIterator.hasNext()) {
            relationKey = relationKeyIterator.next();
            DatabaseField sourceKey = sourceKeyIterator.next();
            expression = linkTable.getField(relationKey).equal(builder.getParameter(sourceKey));
            if (criteria == null) {
                criteria = expression;
                continue;
            }
            criteria = expression.and(criteria);
        }
        if (shouldAddFieldsToQuery && mapping.isCollectionMapping()) {
            mapping.getContainerPolicy().addAdditionalFieldsToQuery(mapping.getSelectionQuery(), linkTable);
        }
        return criteria;
    }

    protected void collectQueryParameters(Set<DatabaseField> cacheFields) {
        cacheFields.addAll(this.getSourceKeyFields());
    }

    public Object clone() {
        RelationTableMechanism clone;
        try {
            clone = (RelationTableMechanism)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        clone.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        clone.setInsertQuery((DataModifyQuery)this.insertQuery.clone());
        clone.setDeleteQuery((DataModifyQuery)this.deleteQuery.clone());
        if (this.lockRelationTableQuery != null) {
            clone.lockRelationTableQuery = (DirectReadQuery)this.lockRelationTableQuery.clone();
        }
        return clone;
    }

    protected List<DatabaseField> cloneFields(List<DatabaseField> fields) {
        ArrayList<DatabaseField> clonedFields = new ArrayList<DatabaseField>();
        Iterator<DatabaseField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            clonedFields.add(iterator.next().clone());
        }
        return clonedFields;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    ReadQuery getLockRelationTableQueryClone(AbstractSession session, short lockMode) {
        DirectReadQuery lockRelationTableQueryClone = (DirectReadQuery)this.lockRelationTableQuery.clone();
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.relationTable);
        statement.addField(this.sourceRelationKeyFields.get(0).clone());
        statement.setWhereClause(this.lockRelationTableQuery.getSelectionCriteria().clone());
        statement.setLockingClause(new ForUpdateClause(lockMode));
        statement.normalize(session, null);
        lockRelationTableQueryClone.setSQLStatement(statement);
        lockRelationTableQueryClone.setIsExecutionClone(true);
        return lockRelationTableQueryClone;
    }

    public void setRelationTableLockingClause(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        ForUpdateOfClause lockingClause = new ForUpdateOfClause();
        lockingClause.setLockMode(sourceQuery.getLockMode());
        FieldExpression exp = (FieldExpression)targetQuery.getExpressionBuilder().getTable(this.relationTable).getField(this.sourceRelationKeyFields.get(0));
        lockingClause.addLockedExpression(exp);
        targetQuery.setLockingClause(lockingClause);
        targetQuery.setShouldOuterJoinSubclasses(true);
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    public List<String> getSourceKeyFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getSourceKeyFields().size());
        Iterator<DatabaseField> iterator = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            fieldNames.add(iterator.next().getQualifiedName());
        }
        return fieldNames;
    }

    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        Expression linkTable = builder.getTable(this.relationTable);
        Expression criteria = null;
        int size = this.targetRelationKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField relationKey = this.targetRelationKeyFields.get(index);
            DatabaseField targetKey = this.targetKeyFields.get(index);
            criteria = builder.getField(targetKey).equal(linkTable.getField(relationKey)).and(criteria);
        }
        size = this.sourceRelationKeyFields.size();
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField sourceRelationKeyField : this.sourceRelationKeyFields) {
                fields.add(linkTable.getField(sourceRelationKeyField));
            }
            return criteria.and(query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields));
        }
        return criteria.and(query.getSession().getPlatform().buildBatchCriteria(builder, linkTable.getField(this.sourceRelationKeyFields.get(0))));
    }

    public void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        mappingBatchQuery.setShouldIncludeData(true);
        Expression linkTable = mappingBatchQuery.getExpressionBuilder().getTable(this.relationTable);
        for (DatabaseField relationField : this.sourceRelationKeyFields) {
            mappingBatchQuery.getAdditionalFields().add(linkTable.getField(relationField));
        }
    }

    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        List<DatabaseField> sourceKeyFields = this.sourceKeyFields;
        int size = sourceKeyFields.size();
        Object[] key = new Object[size];
        for (int index = 0; index < size; ++index) {
            DatabaseField field = sourceKeyFields.get(index);
            Object value = row.get(field);
            key[index] = conversionManager.convertObject(value, field.getType());
        }
        return new CacheId(key);
    }

    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        int size = this.getSourceRelationKeyFields().size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField relationField = this.sourceRelationKeyFields.get(index);
            DatabaseField sourceField = this.sourceKeyFields.get(index);
            Object value = row.get(relationField);
            key[index] = value = conversionManager.convertObject(value, sourceField.getType());
        }
        return new CacheId(key);
    }

    public List<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public List<String> getSourceRelationKeyFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getSourceRelationKeyFields().size());
        Iterator<DatabaseField> iterator = this.getSourceRelationKeyFields().iterator();
        while (iterator.hasNext()) {
            fieldNames.add(iterator.next().getQualifiedName());
        }
        return fieldNames;
    }

    public List<DatabaseField> getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public List<String> getTargetKeyFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getTargetKeyFields().size());
        Iterator<DatabaseField> iterator = this.getTargetKeyFields().iterator();
        while (iterator.hasNext()) {
            fieldNames.add(iterator.next().getQualifiedName());
        }
        return fieldNames;
    }

    public DatabaseField getRelationFieldForTargetField(DatabaseField targetField) {
        int index = this.targetKeyFields.indexOf(targetField);
        if (index == -1) {
            return null;
        }
        return this.targetRelationKeyFields.get(index);
    }

    public List<DatabaseField> getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public List<String> getTargetRelationKeyFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getTargetRelationKeyFields().size());
        Iterator<DatabaseField> iterator = this.getTargetRelationKeyFields().iterator();
        while (iterator.hasNext()) {
            fieldNames.add(iterator.next().getQualifiedName());
        }
        return fieldNames;
    }

    public List<DatabaseField> getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    public boolean hasRelationTable() {
        return this.relationTable != null && !this.relationTable.getName().isEmpty();
    }

    public void initialize(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        this.initializeRelationTable(session, mapping);
        this.initializeSourceRelationKeys(mapping);
        this.initializeTargetRelationKeys(mapping);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(mapping);
        } else {
            this.initializeSourceKeys(mapping);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(session, mapping);
        } else {
            this.initializeTargetKeys(session, mapping);
        }
        if (this.getRelationTable().getName().indexOf(32) != -1) {
            String beginQuote = session.getDatasourcePlatform().getStartDelimiter();
            String endQuote = session.getDatasourcePlatform().getEndDelimiter();
            if (!this.getRelationTable().getName().contains(beginQuote)) {
                this.getRelationTable().setName(beginQuote + this.getRelationTable().getName() + endQuote);
            }
        }
        if (mapping.isCollectionMapping()) {
            mapping.getContainerPolicy().initialize(session, this.getRelationTable());
        }
        this.initializeInsertQuery(session, mapping);
        this.initializeDeleteQuery(session, mapping);
        if (mapping.extendPessimisticLockScope != ForeignReferenceMapping.ExtendPessimisticLockScope.NONE) {
            this.initializeExtendPessimisticLockScope(session, mapping);
        }
    }

    protected void initializeDeleteQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        Expression expression;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.getDeleteQuery().getPartitioningPolicy() == null) {
            this.getDeleteQuery().setPartitioningPolicy(mapping.getPartitioningPolicy());
        }
        this.getInsertQuery().setName(mapping.getAttributeName());
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField relationKey : this.getSourceRelationKeyFields()) {
            expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
            whereClause = expression.and(whereClause);
        }
        if (mapping.isCollectionMapping()) {
            for (DatabaseField relationKey : this.getTargetRelationKeyFields()) {
                expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
                whereClause = expression.and(whereClause);
            }
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        statement.setTable(this.getRelationTable());
        statement.setWhereClause(whereClause);
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeExtendPessimisticLockScope(AbstractSession session, ForeignReferenceMapping mapping) {
        mapping.extendPessimisticLockScope = mapping.usesIndirection() ? (session.getPlatform().isForUpdateCompatibleWithDistinct() && session.getPlatform().supportsLockingQueriesWithMultipleTables() ? ForeignReferenceMapping.ExtendPessimisticLockScope.SOURCE_QUERY : ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY) : (session.getPlatform().supportsIndividualTableLocking() && session.getPlatform().supportsLockingQueriesWithMultipleTables() ? ForeignReferenceMapping.ExtendPessimisticLockScope.TARGET_QUERY : ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY);
        if (mapping.extendPessimisticLockScope == ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY) {
            Expression startCriteria = mapping.getSelectionQuery().getSelectionCriteria();
            if (startCriteria != null) {
                startCriteria = startCriteria.clone();
            }
            this.initializeLockRelationTableQuery(session, mapping, startCriteria);
        }
    }

    protected void initializeInsertQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.getInsertQuery().getPartitioningPolicy() == null) {
            this.getInsertQuery().setPartitioningPolicy(mapping.getPartitioningPolicy());
        }
        this.getInsertQuery().setName(mapping.getAttributeName());
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getRelationTable());
        DatabaseRecord joinRow = new DatabaseRecord();
        for (DatabaseField field : this.getTargetRelationKeyFields()) {
            joinRow.put(field, (Object)null);
        }
        for (DatabaseField field : this.getSourceRelationKeyFields()) {
            joinRow.put(field, (Object)null);
        }
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            if (collectionMapping.getListOrderField() != null) {
                joinRow.put(collectionMapping.getListOrderField(), (Object)null);
            }
            collectionMapping.getContainerPolicy().addFieldsForMapKey(joinRow);
        }
        statement.setModifyRow(joinRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(joinRow);
    }

    protected void initializeLockRelationTableQuery(AbstractSession session, ForeignReferenceMapping mapping, Expression startCriteria) {
        this.lockRelationTableQuery = new DirectReadQuery();
        Expression criteria = this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, startCriteria, false, false);
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.relationTable);
        statement.addField(this.sourceRelationKeyFields.get(0).clone());
        statement.setWhereClause(criteria);
        statement.normalize(session, null);
        this.lockRelationTableQuery.setSQLStatement(statement);
        this.lockRelationTableQuery.setSessionName(session.getName());
    }

    protected void initializeRelationTable(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (mapping.isReadOnly() && mapping.getReferenceDescriptor().hasTablePerMultitenantPolicy()) {
            this.setRelationTable(((TablePerMultitenantPolicy)mapping.getReferenceDescriptor().getMultitenantPolicy()).getTable(this.getRelationTable()));
        }
        if (!this.hasRelationTable()) {
            throw DescriptorException.noRelationTable(mapping);
        }
        if (!platform.getTableQualifier().isEmpty() && this.getRelationTable().getTableQualifier().isEmpty()) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSourceKeys(ForeignReferenceMapping mapping) {
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField field = mapping.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            if (mapping.usesIndirection()) {
                field.setKeepInRow(true);
            }
            this.getSourceKeyFields().set(index, field);
        }
    }

    protected void initializeSourceKeysWithDefaults(DatabaseMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField field = primaryKeyFields.get(index);
            if (((ForeignReferenceMapping)mapping).usesIndirection()) {
                field.setKeepInRow(true);
            }
            this.getSourceKeyFields().add(field);
        }
    }

    protected void initializeSourceRelationKeys(ForeignReferenceMapping mapping) throws DescriptorException {
        if (this.getSourceRelationKeyFields().isEmpty()) {
            throw DescriptorException.noSourceRelationKeysSpecified(mapping);
        }
        for (DatabaseField field : this.getSourceRelationKeyFields()) {
            ClassDescriptor sourceDescriptor = mapping.getDescriptor();
            if (sourceDescriptor.hasTablePerMultitenantPolicy()) {
                field.setTable(((TablePerMultitenantPolicy)sourceDescriptor.getMultitenantPolicy()).getTable(field.getTable()));
            }
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, mapping);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(AbstractSession session, ForeignReferenceMapping mapping) {
        for (int index = 0; index < this.getTargetKeyFields().size(); ++index) {
            DatabaseField field = mapping.getReferenceDescriptor().buildField(this.getTargetKeyFields().get(index));
            this.getTargetKeyFields().set(index, field);
        }
    }

    protected void initializeTargetKeysWithDefaults(AbstractSession session, ForeignReferenceMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getReferenceDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getTargetKeyFields().add(primaryKeyFields.get(index));
        }
    }

    protected void initializeTargetRelationKeys(ForeignReferenceMapping mapping) {
        if (this.getTargetRelationKeyFields().isEmpty()) {
            throw DescriptorException.noTargetRelationKeysSpecified(mapping);
        }
        for (DatabaseField field : this.getTargetRelationKeyFields()) {
            ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
            if (referenceDescriptor.hasTablePerMultitenantPolicy()) {
                field.setTable(((TablePerMultitenantPolicy)referenceDescriptor.getMultitenantPolicy()).getTable(field.getTable()));
            }
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, mapping);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    public Expression joinRelationTableField(Expression expression, Expression baseExpression) {
        return baseExpression.getField(this.sourceKeyFields.get(0)).equal(baseExpression.getTable(this.relationTable).getField(this.sourceRelationKeyFields.get(0))).and(expression);
    }

    public void setCustomDeleteQuery(DataModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteQuery(query);
    }

    protected void setHasCustomDeleteQuery(boolean hasCustomDeleteQuery) {
        this.hasCustomDeleteQuery = hasCustomDeleteQuery;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomInsertQuery(query);
    }

    public void setRelationTable(DatabaseTable relationTable) {
        this.relationTable = relationTable;
    }

    public void setRelationTableName(String tableName) {
        this.relationTable = new DatabaseTable(tableName);
    }

    public void setSessionName(String name) {
        this.getInsertQuery().setSessionName(name);
        this.getDeleteQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(List<String> fieldNames) {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(fieldNames.size());
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext()) {
            fields.add(new DatabaseField(iterator.next()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(List<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setSourceRelationKeyFieldName(String sourceRelationKeyFieldName) {
        this.getSourceRelationKeyFields().add(new DatabaseField(sourceRelationKeyFieldName));
    }

    public void setSourceRelationKeyFieldNames(List<String> fieldNames) {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(fieldNames.size());
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext()) {
            fields.add(new DatabaseField(iterator.next()));
        }
        this.setSourceRelationKeyFields(fields);
    }

    public void setSourceRelationKeyFields(List<DatabaseField> sourceRelationKeyFields) {
        this.sourceRelationKeyFields = sourceRelationKeyFields;
    }

    public void setTargetKeyFieldNames(List<String> fieldNames) {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(fieldNames.size());
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext()) {
            fields.add(new DatabaseField(iterator.next()));
        }
        this.setTargetKeyFields(fields);
    }

    public void setTargetKeyFields(List<DatabaseField> targetKeyFields) {
        this.targetKeyFields = targetKeyFields;
    }

    public void setTargetRelationKeyFieldName(String targetRelationKeyFieldName) {
        this.getTargetRelationKeyFields().add(new DatabaseField(targetRelationKeyFieldName));
    }

    public void setTargetRelationKeyFieldNames(List<String> fieldNames) {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(fieldNames.size());
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext()) {
            fields.add(new DatabaseField(iterator.next()));
        }
        this.setTargetRelationKeyFields(fields);
    }

    public void setTargetRelationKeyFields(List<DatabaseField> targetRelationKeyFields) {
        this.targetRelationKeyFields = targetRelationKeyFields;
    }

    public AbstractRecord buildRelationTableSourceRow(Object sourceObject, AbstractSession session, ForeignReferenceMapping mapping) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceObject, session, databaseRow, mapping);
    }

    public AbstractRecord addRelationTableSourceRow(Object sourceObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getDescriptor().getObjectBuilder();
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = builder.extractValueFromObjectForField(sourceObject, this.sourceKeyFields.get(i), session);
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceRow(AbstractRecord sourceRow) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceRow, databaseRow);
    }

    public AbstractRecord addRelationTableSourceRow(AbstractRecord sourceRow, AbstractRecord databaseRow) {
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = sourceRow.get(this.sourceKeyFields.get(i));
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord addRelationTableTargetRow(Object targetObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
        int size = this.targetKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = builder.extractValueFromObjectForField(targetObject, this.targetKeyFields.get(i), session);
            databaseRow.put(this.targetRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(Object sourceObject, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceObject, session, mapping);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(AbstractRecord sourceRow, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceRow);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }
}

