/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.ColumnResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.ConstructorResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends NamedQueryMetadata {
    private String m_resultSetMapping;
    private List<EntityResultMetadata> m_entityResults = new ArrayList<EntityResultMetadata>();
    private List<ConstructorResultMetadata> m_constructorResults = new ArrayList<ConstructorResultMetadata>();
    private List<ColumnResultMetadata> m_columnResults = new ArrayList<ColumnResultMetadata>();

    public NamedNativeQueryMetadata() {
        super("<named-native-query>");
    }

    public NamedNativeQueryMetadata(MetadataAnnotation namedNativeQuery, MetadataAccessor accessor) {
        super(namedNativeQuery, accessor);
        this.m_resultSetMapping = namedNativeQuery.getAttributeString("resultSetMapping");
        for (Object entityResult : namedNativeQuery.getAttributeArray("entities")) {
            this.m_entityResults.add(new EntityResultMetadata((MetadataAnnotation)entityResult, accessor));
        }
        for (Object constructorResult : namedNativeQuery.getAttributeArray("classes")) {
            this.m_constructorResults.add(new ConstructorResultMetadata((MetadataAnnotation)constructorResult, accessor));
        }
        for (Object columnResult : namedNativeQuery.getAttributeArray("columns")) {
            this.m_columnResults.add(new ColumnResultMetadata((MetadataAnnotation)columnResult, accessor));
        }
    }

    protected NamedNativeQueryMetadata(String javaClassName) {
        super(javaClassName);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata query = (NamedNativeQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_entityResults, query.getEntityResults())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnResults, query.getColumnResults())) {
                return false;
            }
            if (!this.valuesMatch(this.m_constructorResults, query.getConstructorResults())) {
                return false;
            }
            return this.valuesMatch(this.m_resultSetMapping, query.getResultSetMapping());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_resultSetMapping != null ? this.m_resultSetMapping.hashCode() : 0);
        result = 31 * result + (this.m_entityResults != null ? this.m_entityResults.hashCode() : 0);
        result = 31 * result + (this.m_columnResults != null ? this.m_columnResults.hashCode() : 0);
        result = 31 * result + (this.m_constructorResults != null ? this.m_constructorResults.hashCode() : 0);
        return result;
    }

    public List<ColumnResultMetadata> getColumnResults() {
        return this.m_columnResults;
    }

    public List<ConstructorResultMetadata> getConstructorResults() {
        return this.m_constructorResults;
    }

    public List<EntityResultMetadata> getEntityResults() {
        return this.m_entityResults;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    protected boolean hasResultSetMapping(AbstractSession session) {
        if (this.m_resultSetMapping != null && !this.m_resultSetMapping.isEmpty()) {
            if (session.getProject().hasSQLResultSetMapping(this.m_resultSetMapping)) {
                return true;
            }
            throw ValidationException.invalidSQLResultSetMapping(this.m_resultSetMapping, this.getName(), this.getLocation());
        }
        return false;
    }

    @Override
    public void process(AbstractSession session) {
        JPAQuery query = new JPAQuery(this.getName(), this.getQuery(), this.processQueryHints(session));
        if (!this.getResultClass().isVoid()) {
            query.setResultClassName(this.getJavaClassName(this.getResultClass()));
        } else if (this.hasResultSetMapping(session)) {
            query.addResultSetMapping(this.getResultSetMapping());
        }
        this.addJPAQuery(query, session);
    }

    public void setColumnResults(List<ColumnResultMetadata> columnResults) {
        this.m_columnResults = columnResults;
    }

    public void setConstructorResults(List<ConstructorResultMetadata> constructorResults) {
        this.m_constructorResults = constructorResults;
    }

    public void setEntityResults(List<EntityResultMetadata> entityResults) {
        this.m_entityResults = entityResults;
    }

    public void setResultSetMapping(String resultSetMapping) {
        this.m_resultSetMapping = resultSetMapping;
    }
}

