/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.persistence.sdo.helper.extension.Token;

public class OPStack {
    private int state;
    private Stack stack = new Stack();
    private ArrayList tokens = new ArrayList();
    private List out;

    private void removeOCpair() {
        this.stack.pop();
        this.stack.pop();
    }

    private void pushSpew(List outList, Token t) {
        while (!this.stack.empty() && ((Token)this.stack.peek()).getPriority() >= t.getPriority()) {
            outList.add(this.stack.pop());
        }
        this.stack.push(t);
    }

    private Token getNextToken() {
        if (!this.tokens.isEmpty()) {
            Token tok = (Token)this.tokens.get(0);
            this.tokens.remove(0);
            return tok;
        }
        return null;
    }

    private void parseExpression(String exp) {
        Token tok;
        StringBuilder sbuf = new StringBuilder();
        for (int i = 0; i < exp.length(); ++i) {
            char ch = exp.charAt(i);
            if (ch == ' ') {
                if (i + 2 < exp.length() && exp.charAt(i + 1) == 'o' && exp.charAt(i + 2) == 'r') {
                    tok = new Token(sbuf.toString(), 1);
                    this.tokens.add(tok);
                    sbuf = new StringBuilder();
                    sbuf.append(exp.charAt(++i));
                    sbuf.append(exp.charAt(++i));
                    tok = new Token(sbuf.toString(), 4, 10);
                    this.tokens.add(tok);
                    sbuf = new StringBuilder();
                    continue;
                }
                if (i + 3 >= exp.length() || exp.charAt(i + 1) != 'a' || exp.charAt(i + 2) != 'n' || exp.charAt(i + 3) != 'd') continue;
                tok = new Token(sbuf.toString(), 1);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                sbuf.append(exp.charAt(++i));
                sbuf.append(exp.charAt(++i));
                sbuf.append(exp.charAt(++i));
                tok = new Token(sbuf.toString(), 4, 11);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                continue;
            }
            if (ch == '=') {
                tok = new Token(sbuf.toString(), 1);
                this.tokens.add(tok);
                tok = new Token(Character.toString(ch), 4, 12);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                continue;
            }
            if (ch == '!' && i + 1 < exp.length() && exp.charAt(i + 1) == '=') {
                tok = new Token(sbuf.toString(), 1);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                sbuf.append(ch);
                sbuf.append(exp.charAt(++i));
                tok = new Token(sbuf.toString().trim(), 4, 13);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                continue;
            }
            if (ch == '<') {
                tok = new Token(sbuf.toString(), 1);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                sbuf.append(ch);
                if (i + 1 < exp.length() && exp.charAt(i + 1) == '=') {
                    sbuf.append(exp.charAt(++i));
                    tok = new Token(sbuf.toString().trim(), 4, 14);
                } else {
                    tok = new Token(sbuf.toString().trim(), 4, 15);
                }
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                continue;
            }
            if (ch == '>') {
                tok = new Token(sbuf.toString(), 1);
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                sbuf.append(ch);
                if (i + 1 < exp.length() && exp.charAt(i + 1) == '=') {
                    sbuf.append(exp.charAt(++i));
                    tok = new Token(sbuf.toString().trim(), 4, 16);
                } else {
                    tok = new Token(sbuf.toString().trim(), 4, 17);
                }
                this.tokens.add(tok);
                sbuf = new StringBuilder();
                continue;
            }
            if (ch == '(') {
                if (!sbuf.isEmpty()) {
                    tok = new Token(sbuf.toString(), 1);
                    this.tokens.add(tok);
                    sbuf = new StringBuilder();
                }
                tok = new Token(Character.toString(ch), 3);
                this.tokens.add(tok);
                continue;
            }
            if (ch == ')') {
                if (!sbuf.isEmpty()) {
                    tok = new Token(sbuf.toString(), 1);
                    this.tokens.add(tok);
                    sbuf = new StringBuilder();
                }
                tok = new Token(Character.toString(ch), 6);
                this.tokens.add(tok);
                continue;
            }
            if (ch == ' ') continue;
            sbuf.append(ch);
        }
        if (!sbuf.isEmpty()) {
            tok = new Token(sbuf.toString(), 1);
            this.tokens.add(tok);
            sbuf = new StringBuilder();
        }
    }

    public List processExpression(String exp) {
        Token t;
        this.parseExpression(exp);
        this.out = new ArrayList();
        this.state = 0;
        this.stack.push(Token.OpenExp);
        while ((t = this.getNextToken()) != null) {
            switch (t.getType()) {
                case 1: {
                    if (this.state != 0) {
                        this.out.clear();
                        return this.out;
                    }
                    this.out.add(t);
                    this.state = 1;
                    break;
                }
                case 2: {
                    if (this.state != 0) {
                        this.out.clear();
                        return this.out;
                    }
                    this.stack.push(t);
                    break;
                }
                case 3: {
                    this.stack.push(t);
                    break;
                }
                case 4: {
                    if (this.state != 1) {
                        this.out.clear();
                        return this.out;
                    }
                    this.pushSpew(this.out, t);
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (this.state != 1) {
                        this.out.clear();
                        return this.out;
                    }
                    this.pushSpew(this.out, t);
                    this.out.add(this.stack.pop());
                    break;
                }
                case 6: {
                    this.pushSpew(this.out, t);
                    this.removeOCpair();
                }
            }
        }
        this.pushSpew(this.out, Token.CloseExp);
        this.removeOCpair();
        if (this.state != 1) {
            this.out.clear();
        }
        return this.out;
    }
}

