/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.eclipse.persistence.internal.jpa.OptionUtils;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

class LockOptionUtils
extends OptionUtils {
    LockOptionUtils() {
    }

    static OptionUtils.Options parse(LockModeType lockMode, LockOption ... options) {
        return OptionsBuilder.build(null, lockMode, options);
    }

    private static final class OptionsBuilder
    extends OptionUtils.OptionsBuilder {
        private static final Map<Class<? extends LockOption>, BiConsumer<OptionsBuilder, LockOption>> ACTIONS = OptionsBuilder.initActions();

        private static Map<Class<? extends LockOption>, BiConsumer<OptionsBuilder, LockOption>> initActions() {
            HashMap<Class<? extends LockOption>, BiConsumer<OptionsBuilder, LockOption>> actions = new HashMap<Class<? extends LockOption>, BiConsumer<OptionsBuilder, LockOption>>(8);
            actions.put(PessimisticLockScope.class, OptionsBuilder::pessimisticLockScope);
            actions.put(Timeout.class, OptionsBuilder::timeout);
            return actions;
        }

        private OptionsBuilder(Map<String, Object> properties) {
            super(properties);
        }

        private static void pessimisticLockScope(OptionsBuilder builder, LockOption cacheStoreMode) {
            builder.putProperty("jakarta.persistence.lock.scope", cacheStoreMode);
        }

        private static void timeout(OptionsBuilder builder, LockOption timeout) {
            builder.putProperty("eclipselink.pessimistic.lock.timeout.unit", (Object)TimeUnit.MILLISECONDS);
            builder.putProperty("jakarta.persistence.lock.timeout", ((Timeout)timeout).milliseconds());
        }

        private static OptionUtils.Options build(Map<String, Object> properties, LockModeType lockMode, LockOption ... options) {
            OptionsBuilder builder = new OptionsBuilder(properties);
            for (LockOption option : options) {
                BiConsumer<OptionsBuilder, LockOption> action = ACTIONS.get(option.getClass());
                if (action != null) {
                    action.accept(builder, option);
                    continue;
                }
                if (option instanceof Timeout) {
                    OptionsBuilder.timeout(builder, option);
                    continue;
                }
                throw new PersistenceException(ExceptionLocalization.buildMessage("lock_option_class_unknown", new String[]{option.getClass().getName()}));
            }
            return new OptionUtils.Options(lockMode, Collections.unmodifiableMap(builder.getProperties()));
        }
    }
}

