/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.StringHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;

public class IndexMetadata
extends ORMetadata {
    private static final String INDEX = "INDEX";
    private static final char FIELD_SEP = '_';
    private Boolean m_unique;
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_table;
    private String m_columnList;
    private String m_options;
    private List<String> m_columnNames = new ArrayList<String>();

    public IndexMetadata() {
        super("<index>");
    }

    public IndexMetadata(MetadataAnnotation index, MetadataAccessor accessor) {
        super(index, accessor);
        this.m_name = index.getAttributeString("name");
        this.m_schema = index.getAttributeString("schema");
        this.m_catalog = index.getAttributeString("catalog");
        this.m_table = index.getAttributeString("table");
        this.m_unique = index.getAttributeBooleanDefaultFalse("unique");
        this.m_columnList = index.getAttributeString("columnList");
        this.m_options = index.getAttributeString("options");
        for (Object columnName : index.getAttributeArray("columnNames")) {
            this.m_columnNames.add((String)columnName);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof IndexMetadata) {
            IndexMetadata index = (IndexMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, index.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_unique, index.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, index.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, index.getCatalog())) {
                return false;
            }
            if (!this.valuesMatch(this.m_table, index.getTable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnList, index.getColumnList())) {
                return false;
            }
            if (!this.valuesMatch(this.m_options, index.getOptions())) {
                return false;
            }
            return this.m_columnNames.equals(index.getColumnNames());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_unique != null ? this.m_unique.hashCode() : 0);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_schema != null ? this.m_schema.hashCode() : 0);
        result = 31 * result + (this.m_catalog != null ? this.m_catalog.hashCode() : 0);
        result = 31 * result + (this.m_table != null ? this.m_table.hashCode() : 0);
        result = 31 * result + (this.m_columnList != null ? this.m_columnList.hashCode() : 0);
        result = 31 * result + (this.m_columnNames != null ? this.m_columnNames.hashCode() : 0);
        result = 31 * result + (this.m_options != null ? this.m_options.hashCode() : 0);
        return result;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getColumnList() {
        return this.m_columnList;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    @Override
    protected String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getOptions() {
        return this.m_options;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    protected boolean hasName() {
        return this.m_name != null && !this.m_name.isEmpty();
    }

    protected boolean isUnique() {
        return this.m_unique != null && this.m_unique != false;
    }

    public void process(DatabaseTable table) {
        IndexDefinition indexDefinition = new IndexDefinition();
        StringTokenizer st = new StringTokenizer(this.m_columnList, ",");
        while (st.hasMoreTokens()) {
            indexDefinition.addField(st.nextToken().trim());
        }
        indexDefinition.setName(this.processName(table, indexDefinition));
        indexDefinition.setIsUnique(this.isUnique());
        indexDefinition.setQualifier(table.getTableQualifier());
        indexDefinition.setTargetTable(table.getQualifiedName());
        table.addIndex(indexDefinition);
    }

    public void process(MetadataDescriptor descriptor, String defaultColumnName) {
        IndexDefinition indexDefinition = new IndexDefinition();
        DatabaseTable primaryTable = descriptor.getPrimaryTable();
        if (this.m_columnNames.isEmpty() && defaultColumnName != null) {
            indexDefinition.getFields().add(defaultColumnName);
        } else {
            indexDefinition.getFields().addAll(this.m_columnNames);
        }
        indexDefinition.setName(this.processName(primaryTable, indexDefinition));
        if (this.m_schema != null && !this.m_schema.isEmpty()) {
            indexDefinition.setQualifier(this.m_schema);
        } else if (descriptor.getDefaultSchema() != null && !descriptor.getDefaultSchema().isEmpty()) {
            indexDefinition.setQualifier(descriptor.getDefaultSchema());
        }
        if (this.m_catalog != null && !this.m_catalog.isEmpty()) {
            indexDefinition.setQualifier(this.m_catalog);
        } else if (descriptor.getDefaultCatalog() != null && !descriptor.getDefaultCatalog().isEmpty()) {
            indexDefinition.setQualifier(descriptor.getDefaultCatalog());
        }
        indexDefinition.setIsUnique(this.isUnique());
        if (this.m_table == null || this.m_table.isEmpty()) {
            indexDefinition.setTargetTable(primaryTable.getQualifiedName());
            primaryTable.addIndex(indexDefinition);
        } else if (this.m_table.equals(primaryTable.getQualifiedName()) || this.m_table.equals(primaryTable.getName())) {
            indexDefinition.setTargetTable(this.m_table);
            primaryTable.addIndex(indexDefinition);
        } else {
            indexDefinition.setTargetTable(this.m_table);
            boolean found = false;
            for (DatabaseTable databaseTable : descriptor.getClassDescriptor().getTables()) {
                if (!this.m_table.equals(databaseTable.getQualifiedName()) && !this.m_table.equals(databaseTable.getName())) continue;
                databaseTable.addIndex(indexDefinition);
                found = true;
            }
            if (!found) {
                primaryTable.addIndex(indexDefinition);
            }
        }
    }

    protected String processName(DatabaseTable table, IndexDefinition indexDefinition) {
        if (this.hasName()) {
            return this.m_name;
        }
        String tableName = StringHelper.nonNullString(table.getName());
        int length = INDEX.length() + 1 + tableName.length();
        for (String field : indexDefinition.getFields()) {
            ++length;
            length += StringHelper.nonNullString(field).length();
        }
        StringBuilder name = new StringBuilder(length);
        name.append(INDEX).append('_').append(tableName);
        for (String field : indexDefinition.getFields()) {
            name.append('_');
            name.append(StringHelper.nonNullString(field));
        }
        return name.toString();
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setColumnList(String columnList) {
        this.m_columnList = columnList;
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptions(String options) {
        this.m_options = options;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }
}

