/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;

public class SDOSequence
implements Sequence {
    private static final String TEXT_XPATH = "text()";
    private SDODataObject dataObject;
    private List<Setting> settings;
    private Map<Key, Setting> valuesToSettings;

    public SDOSequence(SDODataObject dataObject) {
        if (null == dataObject) {
            throw SDOException.sequenceDataObjectInstanceFieldIsNull();
        }
        this.dataObject = dataObject;
        this.settings = new ArrayList<Setting>();
        this.valuesToSettings = new HashMap<Key, Setting>();
    }

    public SDODataObject getDataObject() {
        return this.dataObject;
    }

    public List<Setting> getSettings() {
        return this.settings;
    }

    private Map<Key, Setting> getValuesToSettings() {
        return this.valuesToSettings;
    }

    @Override
    public void add(int index, int propertyIndex, Object value) {
        SDOProperty property = this.dataObject.getInstanceProperty(propertyIndex);
        this.add(index, property, value);
    }

    @Override
    public boolean add(int propertyIndex, Object value) {
        SDOProperty property = this.dataObject.getInstanceProperty(propertyIndex);
        return this.add(property, value);
    }

    @Override
    public void add(int index, Property property, Object value) {
        if (!this.isAllowedInSequence(property)) {
            return;
        }
        if (property != null && property.isOpenContent() && this.dataObject.getType().isOpen()) {
            this.dataObject.addOpenContentProperty(property);
        }
        if (property.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
            if (value instanceof List) {
                for (Object aValue : (List)value) {
                    Setting setting = this.convertToSetting(property, aValue);
                    this.valuesToSettings.put(new Key(property, aValue), setting);
                    this.settings.add(index++, setting);
                    listWrapper.add(aValue, false);
                }
            } else {
                Setting setting = this.convertToSetting(property, value);
                this.valuesToSettings.put(new Key(property, value), setting);
                this.settings.add(index, setting);
                int listIdx = this.getIndexInList(property, value);
                if (listIdx != -1) {
                    listWrapper.add(listIdx, value, false);
                } else {
                    listWrapper.add(value, false);
                }
            }
        } else {
            this.dataObject.setPropertyInternal((SDOProperty)property, value, false);
            Setting setting = this.convertToSetting(property, value);
            this.valuesToSettings.put(new Key(property, value), setting);
            this.settings.add(index, setting);
        }
    }

    private boolean isAllowedInSequence(Property property) {
        if (null == property) {
            return false;
        }
        if (property.isReadOnly()) {
            return false;
        }
        if (this.dataObject.getType().getHelperContext().getXSDHelper().isAttribute(property)) {
            throw SDOException.sequenceAttributePropertyNotSupported(property.getName());
        }
        if (property.isOpenContent() && !this.dataObject.getType().isOpen()) {
            return false;
        }
        if (property.isMany()) {
            return true;
        }
        if (this.dataObject.isSet(property)) {
            throw SDOException.sequenceDuplicateSettingNotSupportedForComplexSingleObject(this.getIndexForProperty(property), property.getName());
        }
        return true;
    }

    @Override
    public void add(int index, String propertyName, Object value) {
        Property property = this.dataObject.getInstanceProperty(propertyName);
        if (property == null) {
            property = this.dataObject.defineOpenContentProperty(propertyName, value);
            ((SDOProperty)property).setMany(true);
        }
        this.add(index, property, value);
    }

    @Override
    public void add(int index, String text) {
        this.addText(index, text);
    }

    @Override
    public boolean add(Property property, Object value) {
        if (this.addSettingWithoutModifyingDataObject(property, value)) {
            if (property != null && property.isOpenContent() && this.dataObject.getType().isOpen()) {
                this.dataObject.addOpenContentProperty(property);
            }
            if (value instanceof XMLRoot) {
                value = ((XMLRoot)value).getObject();
            }
            if (property.isMany()) {
                ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
                listWrapper.add(value, false);
            } else {
                this.dataObject.setPropertyInternal((SDOProperty)property, value, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String propertyName, Object value) {
        Property property = this.dataObject.getInstanceProperty(propertyName);
        if (property == null) {
            property = this.dataObject.defineOpenContentProperty(propertyName, value);
            ((SDOProperty)property).setMany(true);
        }
        return this.add(property, value);
    }

    @Override
    public void add(String text) {
        this.addText(text);
    }

    @Override
    public void addText(int index, String text) {
        this.dataObject._setModified(true);
        Setting textSetting = new Setting(null, TEXT_XPATH);
        textSetting.setObject(this.dataObject);
        textSetting.setValue(text, false);
        this.settings.add(index, textSetting);
    }

    @Override
    public void addText(String text) {
        this.dataObject._setModified(true);
        Setting textSetting = new Setting(null, TEXT_XPATH);
        textSetting.setObject(this.dataObject);
        textSetting.setValue(text, false);
        this.settings.add(textSetting);
    }

    @Override
    public SDOProperty getProperty(int index) {
        try {
            return this.getProperty(this.settings.get(index));
        }
        catch (IndexOutOfBoundsException iobex) {
            throw SDOException.invalidIndex(iobex, index);
        }
    }

    public SDOProperty getProperty(Setting setting) {
        CoreMapping mapping = setting.getMapping();
        if (null == mapping) {
            List<Setting> children = setting.getChildren();
            if (null != children && !children.isEmpty()) {
                return this.getProperty(children.get(0));
            }
        } else {
            SDOProperty property = null;
            if (null == setting.getName()) {
                Object value = setting.getValue();
                if (value instanceof SDODataObject) {
                    SDOProperty containmentProp = ((SDODataObject)value).getContainmentProperty();
                    if (containmentProp != null) {
                        property = this.dataObject.getInstanceProperty(containmentProp.getName());
                    }
                    if (property == null) {
                        XMLDescriptor desc = ((SDODataObject)value).getType().getXmlDescriptor();
                        String qualifiedName = desc.getDefaultRootElement();
                        int index = qualifiedName.indexOf(58);
                        String localName = null;
                        localName = index > -1 ? qualifiedName.substring(index + 1, qualifiedName.length()) : qualifiedName;
                        property = this.dataObject.getInstanceProperty(localName);
                    }
                } else {
                    XMLRoot xmlRoot = (XMLRoot)value;
                    if (null != xmlRoot) {
                        property = this.dataObject.getInstanceProperty(xmlRoot.getLocalName());
                    }
                }
            } else {
                property = this.dataObject.getInstanceProperty(mapping.getAttributeName());
            }
            return property;
        }
        return null;
    }

    @Override
    public Object getValue(int index) {
        try {
            return this.getValue(this.settings.get(index));
        }
        catch (IndexOutOfBoundsException iobex) {
            throw SDOException.invalidIndex(iobex, index);
        }
    }

    private Object getValue(Setting setting) {
        if (null != setting.getMapping() || setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
            Object value = setting.getValue();
            if (value instanceof XMLRoot) {
                value = ((XMLRoot)value).getObject();
            }
            return value;
        }
        if (null == setting.getChildren() || setting.getChildren().isEmpty()) {
            return null;
        }
        return this.getValue(setting.getChildren().get(0));
    }

    @Override
    public void move(int toIndex, int fromIndex) {
        if (toIndex == fromIndex) {
            return;
        }
        int size = this.settings.size();
        if (fromIndex < 0 || fromIndex >= size) {
            throw SDOException.invalidIndex(null, fromIndex);
        }
        if (toIndex < 0 || toIndex >= size) {
            throw SDOException.invalidIndex(null, toIndex);
        }
        this.dataObject._setModified(true);
        Setting setting = this.settings.remove(fromIndex);
        this.settings.add(toIndex, setting);
        SDOProperty prop = this.getProperty(setting);
        if (prop != null && prop.isMany()) {
            ListWrapper lw = (ListWrapper)this.dataObject.getList(prop);
            Object value = this.getValue(setting);
            int currentIndexInLw = lw.indexOf(value);
            lw.remove(currentIndexInLw, false);
            int newIndexInLw = this.getIndexInList(prop, value);
            lw.add(newIndexInLw, value, false);
        }
    }

    @Override
    public void remove(int index) {
        Setting setting = this.settings.get(index);
        this.remove(setting);
        this.settings.remove(setting);
    }

    private void remove(Setting setting) {
        CoreMapping mapping = setting.getMapping();
        if (null != mapping) {
            SDOProperty property = null;
            if (null == setting.getName()) {
                XMLRoot xmlRoot = (XMLRoot)setting.getValue();
                if (null != xmlRoot) {
                    property = this.dataObject.getInstanceProperty(xmlRoot.getLocalName());
                    this.valuesToSettings.remove(new Key(property, setting.getValue()));
                }
            } else {
                property = this.dataObject.getInstanceProperty(mapping.getAttributeName());
                this.valuesToSettings.remove(new Key(property, setting.getValue()));
            }
            if (property.isMany()) {
                ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
                listWrapper.remove(setting.getValue(), false, false);
            } else {
                this.dataObject.unset(property, false, false);
            }
        } else if (setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
            this.dataObject._setModified(true);
        }
        List<Setting> children = setting.getChildren();
        if (null != children) {
            int childrenSize = children.size();
            for (int x = 0; x < childrenSize; ++x) {
                this.remove(children.get(x));
            }
        }
    }

    public void addValueToSettings(Setting setting) {
        this.valuesToSettings.put(new Key(this.getProperty(setting), this.getValue(setting)), setting);
    }

    public void removeValueToSettings(Setting setting) {
        this.valuesToSettings.remove(new Key(this.getProperty(setting), this.getValue(setting)));
    }

    @Override
    public Object setValue(int index, Object value) {
        return this.setValue(this.settings.get(index), value);
    }

    private Object setValue(Setting setting, Object value) {
        if (null == setting.getMapping()) {
            if (setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
                this.dataObject._setModified(true);
                Object oldValue = setting.getValue();
                setting.setValue(value, false);
                return oldValue;
            }
            List<Setting> children = setting.getChildren();
            if (null != children && !children.isEmpty()) {
                return this.setValue(children.get(0), value);
            }
            return null;
        }
        SDOProperty property = this.getProperty(setting);
        Object oldValue = setting.getValue();
        if (property.isMany()) {
            ListWrapper listValue = (ListWrapper)this.dataObject.getList(property);
            int valueIndex = listValue.indexOf(oldValue);
            listValue.remove(oldValue, property.isContainment(), false);
            listValue.add(valueIndex, value, false);
            setting.setValue(value, false);
        } else {
            if (this.dataObject.isSet(property)) {
                this.updateSettingWithoutModifyingDataObject(property, this.dataObject.get(property), value);
                setting.setValue(value);
            } else {
                this.addSettingWithoutModifyingDataObject(property, value);
            }
            this.dataObject.setPropertyInternal(property, value, false);
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.settings.size();
    }

    private Setting convertToSetting(Property property, Object value) {
        SDOProperty sdoProperty = (SDOProperty)property;
        CoreMapping mapping = sdoProperty.getXmlMapping();
        Setting setting = new Setting();
        SDOType sdoType = this.dataObject.getType();
        XMLDescriptor xmlDescriptor = sdoType.getXmlDescriptor();
        if (null == mapping) {
            setting.setObject(this.dataObject);
            mapping = xmlDescriptor.getMappingForAttributeName("openContentProperties");
            setting.setMapping(mapping);
            XMLRoot xmlRoot = new XMLRoot();
            if (value instanceof XMLRoot) {
                xmlRoot.setLocalName(((XMLRoot)value).getLocalName());
                xmlRoot.setNamespaceURI(((XMLRoot)value).getNamespaceURI());
                xmlRoot.setObject(((XMLRoot)value).getObject());
            } else {
                QName schemaTypeQName;
                xmlRoot.setLocalName(sdoProperty.getName());
                xmlRoot.setNamespaceURI(sdoProperty.getUri());
                xmlRoot.setObject(value);
                SDOTypeHelper hlpr = (SDOTypeHelper)this.dataObject.getType().getHelperContext().getTypeHelper();
                if (hlpr.getOpenContentProperty(sdoProperty.getUri(), sdoProperty.getName()) == null && (schemaTypeQName = hlpr.getXSDTypeFromSDOType(property.getType())) != null && schemaTypeQName != XMLConstants.STRING_QNAME) {
                    xmlRoot.setSchemaType(schemaTypeQName);
                }
            }
            setting.setValue(xmlRoot, false);
        } else {
            setting = this.convertToSetting((DatabaseMapping)mapping, value);
        }
        return setting;
    }

    private Setting convertToSetting(DatabaseMapping mapping, Object value) {
        XMLDescriptor xmlDescriptor = (XMLDescriptor)mapping.getDescriptor();
        NamespaceResolver nsResolver = xmlDescriptor.getNamespaceResolver();
        Setting rootSetting = new Setting();
        XMLField xmlField = (XMLField)mapping.getField();
        if (xmlField == null) {
            if (mapping instanceof XMLObjectReferenceMapping) {
                xmlField = (XMLField)mapping.getFields().get(0);
            } else if (mapping instanceof XMLCollectionReferenceMapping) {
                xmlField = (XMLField)mapping.getFields().get(0);
            }
        }
        Setting setting = rootSetting;
        if (xmlField != null) {
            XPathFragment xPathFragment = xmlField.getXPathFragment();
            setting = rootSetting = this.convertToSetting(xPathFragment, nsResolver);
            while (xPathFragment.getNextFragment() != null) {
                xPathFragment = xPathFragment.getNextFragment();
                Setting childSetting = this.convertToSetting(xPathFragment, nsResolver);
                setting.addChild(childSetting);
                setting = childSetting;
            }
        }
        setting.setObject(this.dataObject);
        setting.setMapping(mapping);
        setting.setValue(value, false);
        return rootSetting;
    }

    private Setting convertToSetting(XPathFragment xPathFragment, NamespaceResolver nsResolver) {
        Setting setting = new Setting();
        String name = xPathFragment.getLocalName();
        if (null == name) {
            name = xPathFragment.getShortName();
        }
        setting.setName(name);
        if (xPathFragment.hasNamespace()) {
            setting.setNamespaceURI(nsResolver.resolveNamespacePrefix(xPathFragment.getPrefix()));
        }
        return setting;
    }

    public SDOSequence copy() {
        SDOSequence copy = new SDOSequence(this.dataObject);
        int size = this.settings.size();
        for (int index = 0; index < size; ++index) {
            Setting settingCopy = this.settings.get(index).copy();
            copy.getSettings().add(settingCopy);
            copy.getValuesToSettings().put(new Key(this.getProperty(settingCopy), this.getValue(settingCopy)), settingCopy);
        }
        return copy;
    }

    public boolean addSettingWithoutModifyingDataObject(int index, Property property, Object value) {
        Setting setting = this.convertToSetting(property, value);
        this.valuesToSettings.put(new Key(property, value), setting);
        if (index >= 0) {
            this.settings.add(index, setting);
        } else {
            this.settings.add(setting);
        }
        return true;
    }

    public boolean addSettingWithoutModifyingDataObject(Property property, Object value) {
        return this.addSettingWithoutModifyingDataObject(property, value, true);
    }

    public boolean addSettingWithoutModifyingDataObject(Property property, Object value, boolean checkAllowed) {
        if (checkAllowed && !this.isAllowedInSequence(property)) {
            return false;
        }
        Setting setting = this.convertToSetting(property, value);
        this.valuesToSettings.put(new Key(property, value), setting);
        this.settings.add(setting);
        return true;
    }

    public void updateSettingWithoutModifyingDataObject(Property property, Object oldValue, Object newValue) {
        Key key = new Key(property, oldValue);
        Setting setting = this.valuesToSettings.get(key);
        this.valuesToSettings.remove(key);
        this.valuesToSettings.put(new Key(property, newValue), setting);
        while (setting.getMapping() == null) {
            List<Setting> children = setting.getChildren();
            if (children == null || children.isEmpty()) continue;
            setting = children.get(0);
        }
        setting.setValue(newValue, false);
    }

    public void removeSettingWithoutModifyingDataObject(Property property, Object value) {
        this.settings.remove(this.valuesToSettings.remove(new Key(property, value)));
    }

    public void removeSettingWithoutModifyingDataObject(Property property) {
        ArrayList<Key> keys = new ArrayList<Key>(this.valuesToSettings.keySet());
        int size = this.valuesToSettings.keySet().size();
        for (int i = size - 1; i >= 0; --i) {
            Key nextKey = (Key)keys.get(i);
            if (nextKey.getProperty() != property) continue;
            this.settings.remove(this.valuesToSettings.remove(nextKey));
        }
    }

    public int getIndexForProperty(Property property) {
        ArrayList<Key> keys = new ArrayList<Key>(this.valuesToSettings.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            Key nextKey = (Key)keys.get(i);
            if (nextKey.getProperty() != property) continue;
            return this.settings.indexOf(this.valuesToSettings.get(nextKey));
        }
        return -1;
    }

    private int getIndexInList(Property manyProp, Object value) {
        int returnIndex = -1;
        for (int i = 0; i < this.settings.size(); ++i) {
            Setting nextSetting = this.settings.get(i);
            SDOProperty prop = this.getProperty(nextSetting);
            if (!prop.equals(manyProp)) continue;
            ++returnIndex;
            if (!value.equals(this.getValue(nextSetting))) continue;
            return returnIndex;
        }
        return returnIndex;
    }

    public static Setting getRootSetting(Setting setting) {
        Setting rootSetting = setting;
        while (rootSetting.getParent() != null) {
            rootSetting = rootSetting.getParent();
        }
        return rootSetting;
    }

    public void afterUnmarshal() {
        Iterator<Setting> setIt = this.getSettings().iterator();
        while (setIt.hasNext()) {
            this.addValueToSettings(setIt.next());
        }
    }

    private static class Key {
        private Property property;
        private Object value;

        public Key(Property property, Object value) {
            this.property = property;
            this.value = value;
        }

        protected Property getProperty() {
            return this.property;
        }

        protected Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            try {
                Key key = (Key)object;
                return this.property == key.getProperty() && this.value == key.getValue();
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            if (this.value == null) {
                return 0;
            }
            return this.value.hashCode();
        }
    }
}

