/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import jakarta.persistence.spi.PersistenceUnitInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.XMLParseException;
import org.eclipse.persistence.internal.helper.XMLHelper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.PersistenceContentHandler;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLException;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLExceptionHandler;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PersistenceUnitProcessor {
    public static ArchiveFactory ARCHIVE_FACTORY = null;
    private static final String WEBINF_CLASSES_STR = "WEB-INF/classes/";
    private static final int WEBINF_CLASSES_LEN = "WEB-INF/classes/".length();
    private static final String PU_NAME_SEPARATOR = "_";
    private static final String PU_HASH_SEPARATOR = "?";

    protected PersistenceUnitProcessor() {
    }

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo, Map properties) {
        HashSet<String> set = new HashSet<String>(persistenceUnitInfo.getManagedClassNames());
        ClassLoader loader = persistenceUnitInfo.getClassLoader();
        Iterator i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL((URL)i.next(), loader, properties));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), loader, properties));
        }
        return set;
    }

    public static Collection<MetadataClass> buildEntityList(MetadataProcessor processor, ClassLoader loader) {
        ArrayList<MetadataClass> entityList = new ArrayList<MetadataClass>();
        for (String className : processor.getProject().getWeavableClassNames()) {
            entityList.add(processor.getMetadataFactory().getMetadataClass(className));
        }
        return entityList;
    }

    public static URL computePURootURL(URL pxmlURL, String descriptorLocation) throws IOException, URISyntaxException {
        URL result;
        StringTokenizer tokenizer = new StringTokenizer(descriptorLocation, "/\\");
        int descriptorDepth = tokenizer.countTokens() - 1;
        String protocol = pxmlURL.getProtocol();
        if ("file".equals(protocol)) {
            StringBuilder path = new StringBuilder();
            boolean firstElement = true;
            for (int i = 0; i < descriptorDepth; ++i) {
                if (!firstElement) {
                    path.append("/");
                }
                path.append("..");
                firstElement = false;
            }
            result = new URL(pxmlURL, path.toString());
        } else if ("zip".equals(protocol) || "jar".equals(protocol) || "wsjar".equals(protocol)) {
            String entry;
            Object spec = "zip".equals(protocol) ? "file:" + pxmlURL.getFile() : pxmlURL.getFile();
            int separator = ((String)spec).lastIndexOf("!/");
            Object file = separator == -1 ? spec : ((String)spec).substring(0, separator);
            String string = entry = separator == -1 ? "" : ((String)spec).substring(separator + 2);
            if (!entry.endsWith(descriptorLocation)) {
                throw ValidationException.invalidPersistenceRootUrl(pxmlURL, descriptorLocation);
            }
            String rootEntry = entry.substring(0, entry.length() - descriptorLocation.length());
            URL uRL = result = !rootEntry.isEmpty() || "wsjar".equals(protocol) ? new URL("jar:" + (String)file + "!/" + rootEntry) : new URL((String)file);
            if (!PersistenceUnitProcessor.isValidRootInArchive((String)file, rootEntry)) {
                throw ValidationException.invalidPersistenceRootUrl(pxmlURL, descriptorLocation);
            }
        } else if ("bundleentry".equals(protocol)) {
            result = new URL("bundleentry://" + pxmlURL.getAuthority());
        } else if ("bundleresource".equals(protocol)) {
            result = new URL("bundleresource://" + pxmlURL.getAuthority());
        } else {
            StringBuilder path = new StringBuilder();
            path.append("../".repeat(Math.max(0, descriptorDepth)));
            result = new URL(pxmlURL, path.toString());
        }
        result = PersistenceUnitProcessor.fixUNC(result);
        return result;
    }

    private static URL fixUNC(URL url) throws URISyntaxException, MalformedURLException, UnsupportedEncodingException {
        String protocol = url.getProtocol();
        if (!"file".equalsIgnoreCase(protocol)) {
            return url;
        }
        String authority = url.getAuthority();
        String file = url.getFile();
        if (authority != null) {
            AbstractSessionLog.getLog().finer("fixUNC: before fixing: url = " + String.valueOf(url) + ", authority = " + authority + ", file = " + file);
            assert (url.getPort() == -1);
            String prefix = "";
            if (!authority.isEmpty()) {
                prefix = "////";
            } else if (file.startsWith("//")) {
                prefix = "//";
            }
            file = prefix.concat(authority).concat(file);
            url = new URL(protocol, null, file);
            AbstractSessionLog.getLog().finer("fixUNC: after fixing: url = " + String.valueOf(url) + ", authority = " + url.getAuthority() + ", file = " + url.getFile());
        }
        return url;
    }

    public static Set<Archive> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader) {
        String descriptorLocation = PrivilegedAccessHelper.getSystemProperty("eclipselink.persistencexml", "META-INF/persistence.xml");
        return PersistenceUnitProcessor.findPersistenceArchives(loader, descriptorLocation);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader, String descriptorPath) {
        Archive archive = null;
        HashSet<Archive> archives = new HashSet<Archive>();
        int splitPosition = descriptorPath.indexOf("!/");
        try {
            if (splitPosition == -1) {
                Enumeration<URL> resources = loader.getResources(descriptorPath);
                while (resources.hasMoreElements()) {
                    URL descUrl = resources.nextElement();
                    if (descUrl == null) continue;
                    URL puRootUrl = PersistenceUnitProcessor.computePURootURL(descUrl, descriptorPath);
                    archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(puRootUrl, descriptorPath, null);
                    if (archive == null) continue;
                    archives.add(archive);
                }
            } else {
                String jarPrefixPath = descriptorPath.substring(0, splitPosition);
                String descPath = descriptorPath.substring(splitPosition + 2);
                URL prefixUrl = loader.getResource(jarPrefixPath);
                archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(prefixUrl, descPath, null);
                if (archive != null) {
                    archives.add(archive);
                }
            }
        }
        catch (Exception ex) {
            for (Archive a : archives) {
                a.close();
            }
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, ex);
        }
        return archives;
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader, String descriptorPath, List<URL> jarFileUrls, Map properties) {
        Archive archive = null;
        HashSet<Archive> archives = new HashSet<Archive>();
        int splitPosition = descriptorPath.indexOf("!/");
        if (splitPosition != -1) {
            descriptorPath = descriptorPath.substring(splitPosition + 2);
        }
        try {
            for (int i = 0; i < jarFileUrls.size(); ++i) {
                URL puRootUrl = jarFileUrls.get(i);
                archive = PersistenceUnitProcessor.getArchiveFactory(loader, properties).createArchive(puRootUrl, descriptorPath, null);
                if (archive == null) continue;
                archives.add(archive);
            }
        }
        catch (Exception ex) {
            for (Archive a : archives) {
                a.close();
            }
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, ex);
        }
        return archives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SEPersistenceUnitInfo> getPersistenceUnits(ClassLoader loader, Map m, List<URL> jarFileUrls) {
        String descriptorPath = (String)m.get("eclipselink.persistencexml");
        if (descriptorPath == null) {
            descriptorPath = PrivilegedAccessHelper.getSystemProperty("eclipselink.persistencexml", "META-INF/persistence.xml");
        }
        Set<Archive> archives = PersistenceUnitProcessor.findPersistenceArchives(loader, descriptorPath, jarFileUrls, m);
        HashSet<SEPersistenceUnitInfo> puInfos = new HashSet<SEPersistenceUnitInfo>();
        try {
            for (Archive archive : archives) {
                List<SEPersistenceUnitInfo> puInfosFromArchive = PersistenceUnitProcessor.getPersistenceUnits(archive, loader);
                puInfos.addAll(puInfosFromArchive);
            }
        }
        finally {
            for (Archive archive : archives) {
                archive.close();
            }
        }
        return puInfos;
    }

    public static ArchiveFactory getArchiveFactory(ClassLoader loader) {
        return PersistenceUnitProcessor.getArchiveFactory(loader, null);
    }

    public static ArchiveFactory getArchiveFactory(ClassLoader loader, Map properties) {
        ArchiveFactory factory;
        block8: {
            Object name;
            String factoryClassName;
            if (ARCHIVE_FACTORY != null) {
                return ARCHIVE_FACTORY;
            }
            factory = null;
            String string = factoryClassName = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty("eclipselink.archive.factory")) : System.getProperty("eclipselink.archive.factory");
            if (factoryClassName == null && properties != null && (name = properties.get("eclipselink.archive.factory")) instanceof String) {
                factoryClassName = (String)name;
            }
            if (factoryClassName == null) {
                return new ArchiveFactoryImpl();
            }
            try {
                if (loader == null) break block8;
                Class<?> archiveClass = loader.loadClass(factoryClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        factory = (ArchiveFactory)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(archiveClass));
                        break block8;
                    }
                    catch (PrivilegedActionException exception) {
                        throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, exception);
                    }
                }
                factory = (ArchiveFactory)PrivilegedAccessHelper.newInstanceFromClass(archiveClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException cnfe) {
                throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, cnfe);
            }
        }
        return factory;
    }

    public static Set<String> getClassNamesFromURL(URL url, ClassLoader loader, Map properties) {
        HashSet<String> classNames = new HashSet<String>();
        try (Archive archive = null;){
            archive = PersistenceUnitProcessor.getArchiveFactory(loader, properties).createArchive(url, properties);
            if (archive != null) {
                Iterator<String> entries = archive.getEntries();
                while (entries.hasNext()) {
                    String entry = entries.next();
                    if (!entry.endsWith(".class")) continue;
                    classNames.add(PersistenceUnitProcessor.buildClassNameFromEntryString(entry));
                }
            }
        }
        return classNames;
    }

    public static MetadataAnnotation getConverterAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("jakarta.persistence.Converter");
    }

    public static MetadataAnnotation getEmbeddableAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("jakarta.persistence.Embeddable");
    }

    public static MetadataAnnotation getEntityAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("jakarta.persistence.Entity");
    }

    public static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(archive, loader);
    }

    public static MetadataAnnotation getMappedSuperclassAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("jakarta.persistence.MappedSuperclass");
    }

    public static MetadataAnnotation getStaticMetamodelAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("jakarta.persistence.metamodel.StaticMetamodel");
    }

    public static boolean isConverter(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("jakarta.persistence.Converter");
    }

    public static boolean isEmbeddable(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("jakarta.persistence.Embeddable");
    }

    public static boolean isEntity(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("jakarta.persistence.Entity");
    }

    public static boolean isStaticMetamodelClass(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("jakarta.persistence.metamodel.StaticMetamodel");
    }

    public static boolean isMappedSuperclass(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("jakarta.persistence.MappedSuperclass");
    }

    public static Class<?> loadClass(String className, ClassLoader loader, boolean throwExceptionIfNotFound, MetadataProject project) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            if (throwExceptionIfNotFound) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations(className, exc);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exc.getClass().getName(), (Object)exc.getLocalizedMessage(), (Object)className);
        }
        catch (NullPointerException npe) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class_weaving_disabled", (Object)loader, (Object)project.getPersistenceUnitInfo().getPersistenceUnitName(), (Object)className);
            project.disableWeaving();
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class", (Object)exception.getClass().getName(), (Object)exception.getLocalizedMessage(), (Object)className);
        }
        catch (Error error) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class", (Object)error.getClass().getName(), (Object)error.getLocalizedMessage(), (Object)className);
            throw error;
        }
        return candidateClass;
    }

    public static void processORMetadata(MetadataProcessor processor, boolean throwExceptionOnFail, Mode mode) {
        if (mode == Mode.ALL || mode == Mode.COMPOSITE_MEMBER_INITIAL) {
            processor.loadMappingFiles(throwExceptionOnFail);
        }
        processor.processEntityMappings(mode);
        processor.processORMMetadata(mode);
    }

    public static List<SEPersistenceUnitInfo> processPersistenceArchive(Archive archive, ClassLoader loader) {
        List<SEPersistenceUnitInfo> list;
        block8: {
            URL puRootURL = archive.getRootURL();
            InputStream descriptorStream = archive.getDescriptorStream();
            try {
                list = PersistenceUnitProcessor.processPersistenceXML(puRootURL, descriptorStream, loader);
                if (descriptorStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (descriptorStream != null) {
                        try {
                            descriptorStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(puRootURL.toString(), e);
                }
            }
            descriptorStream.close();
        }
        return list;
    }

    private static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = XMLHelper.createParserFactory(false);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader(baseURL, exc);
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, exc);
        }
        catch (SAXException exc) {
            // empty catch block
        }
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
            info.setClassLoader(loader);
            info.setNewTempClassLoader(loader);
        }
        return myContentHandler.getPersistenceUnits();
    }

    public static void setArchiveFactory(ArchiveFactory factory) {
        ARCHIVE_FACTORY = factory;
    }

    public static String buildPersistenceUnitName(URL rootURL, String puName, String hash) {
        String urlPrefix = URLDecoder.decode(rootURL.toString(), StandardCharsets.UTF_8);
        StringBuilder fullPuName = new StringBuilder(urlPrefix.length() + PU_NAME_SEPARATOR.length() + puName.length() + (hash != null ? PU_HASH_SEPARATOR.length() + hash.length() : 0)).append(urlPrefix).append(PU_NAME_SEPARATOR).append(puName);
        if (hash != null) {
            fullPuName.append(PU_HASH_SEPARATOR).append(hash);
        }
        return fullPuName.toString();
    }

    private static boolean isValidRootInArchive(String file, String rootEntry) {
        String extension = file.substring(Math.max(0, file.length() - 4));
        if (extension.equalsIgnoreCase(".jar")) {
            return rootEntry.isEmpty();
        }
        if (extension.equalsIgnoreCase(".war")) {
            return rootEntry.equals(WEBINF_CLASSES_STR) || rootEntry.isEmpty();
        }
        return false;
    }

    public static enum Mode {
        ALL,
        COMPOSITE_MEMBER_INITIAL,
        COMPOSITE_MEMBER_MIDDLE,
        COMPOSITE_MEMBER_FINAL;

    }
}

