/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.invalidation;

import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;

public class TimeToLiveCacheInvalidationPolicy
extends CacheInvalidationPolicy {
    protected long timeToLive = 0L;

    public TimeToLiveCacheInvalidationPolicy() {
    }

    public TimeToLiveCacheInvalidationPolicy(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public long getExpiryTimeInMillis(CacheKey key) {
        if (this.isInvalidationRandomized) {
            int randomDelta = this.random.nextInt((int)this.timeToLive / 10);
            return key.getReadTime() + (this.timeToLive - (long)randomDelta);
        }
        return key.getReadTime() + this.timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public boolean isInvalidated(CacheKey key, long currentTimeMillis) {
        if (key.getInvalidationState() == -1) {
            return true;
        }
        return this.getExpiryTimeInMillis(key) <= currentTimeMillis;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public Object clone() {
        TimeToLiveCacheInvalidationPolicy clone = null;
        try {
            clone = (TimeToLiveCacheInvalidationPolicy)super.clone();
            clone.timeToLive = this.timeToLive;
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
        return clone;
    }
}

