/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public abstract class SQLModifyAllStatementForTempTable
extends SQLModifyStatement {
    public static final int CREATE_TEMP_TABLE = 0;
    public static final int INSERT_INTO_TEMP_TABLE = 1;
    public static final int UPDATE_ORIGINAL_TABLE = 2;
    public static final int CLEANUP_TEMP_TABLE = 3;
    protected Collection allFields;
    protected List<DatabaseField> primaryKeyFields;
    protected SQLCall selectCall;
    protected int mode;

    protected abstract Collection getUsedFields();

    protected abstract void writeUpdateOriginalTable(AbstractSession var1, Writer var2) throws IOException;

    public void setAllFields(Collection allFields) {
        this.allFields = allFields;
    }

    public Collection getAllFields() {
        return this.allFields;
    }

    public void setSelectCall(SQLCall selectCall) {
        this.selectCall = selectCall;
    }

    public SQLCall getSelectCall() {
        return this.selectCall;
    }

    public void setPrimaryKeyFields(List<DatabaseField> primaryKeyFields) {
        this.primaryKeyFields = primaryKeyFields;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            if (this.mode == 0) {
                session.getPlatform().writeCreateTempTableSql(writer, this.table, session, new Vector<DatabaseField>(this.getPrimaryKeyFields()), this.getUsedFields(), new Vector<DatabaseField>(this.getAllFields()));
            } else if (this.mode == 1) {
                session.getPlatform().writeInsertIntoTableSql(writer, this.table, this.getUsedFields());
                call.getParameters().addAll(this.selectCall.getParameters());
                call.getParameterTypes().addAll(this.selectCall.getParameterTypes());
                String selectStr = this.selectCall.getSQLString();
                writer.write(selectStr);
            } else if (this.mode == 2) {
                this.writeUpdateOriginalTable(session, writer);
            } else if (this.mode == 3) {
                session.getPlatform().writeCleanUpTempTableSql(writer, this.table);
            }
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }
}

