/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;

public class SubSelectExpression
extends BaseExpression {
    protected boolean hasBeenNormalized;
    protected ReportQuery subQuery;
    protected String attribute;
    protected Class returnType;
    protected Expression criteriaBase;

    public SubSelectExpression() {
        this.subQuery = new ReportQuery();
    }

    public SubSelectExpression(ReportQuery query, Expression baseExpression) {
        super(baseExpression);
        this.subQuery = query;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public String descriptionOfNodeType() {
        return "SubSelect";
    }

    public ReportQuery getSubQuery() {
        this.initializeCountSubQuery();
        return this.subQuery;
    }

    protected void initializeCountSubQuery() {
        if (this.criteriaBase != null && (this.subQuery.getItems() == null || this.subQuery.getItems().isEmpty())) {
            if (this.baseExpression.getSession() != null && ((ObjectExpression)this.baseExpression).getDescriptor() != null) {
                DatabaseMapping mapping;
                Class sourceClass = ((ObjectExpression)this.baseExpression).getDescriptor().getJavaClass();
                ClassDescriptor descriptor = this.baseExpression.getSession().getDescriptor(sourceClass);
                if (descriptor != null && (mapping = descriptor.getMappingForAttributeName(this.attribute)) != null && mapping.isDirectCollectionMapping()) {
                    this.subQuery.setExpressionBuilder(this.baseExpression.getBuilder());
                    this.subQuery.setReferenceClass(sourceClass);
                    this.subQuery.addCount(this.attribute, this.subQuery.getExpressionBuilder().anyOf(this.attribute), this.returnType);
                    return;
                }
            }
            this.subQuery.addCount("COUNT", this.subQuery.getExpressionBuilder(), this.returnType);
            if (this.attribute != null) {
                this.subQuery.setSelectionCriteria(this.subQuery.getExpressionBuilder().equal(this.criteriaBase.anyOf(this.attribute)));
            } else {
                this.subQuery.setSelectionCriteria(this.subQuery.getExpressionBuilder().equal(this.criteriaBase));
            }
        }
    }

    @Override
    public boolean isSubSelectExpression() {
        return true;
    }

    @Override
    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
        if (iterator.shouldIterateOverSubSelects()) {
            if (this.getSubQuery().getSelectionCriteria() != null) {
                this.getSubQuery().getSelectionCriteria().iterateOn(iterator);
            } else {
                this.getSubQuery().getExpressionBuilder().iterateOn(iterator);
            }
        }
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized) {
            return this;
        }
        this.validateNode();
        normalizer.addSubSelectExpression(this);
        normalizer.getStatement().setRequiresAliases(true);
        return this;
    }

    public Expression normalizeSubSelect(ExpressionNormalizer normalizer, Map clonedExpressions) {
        if (this.hasBeenNormalized) {
            return this;
        }
        this.hasBeenNormalized = true;
        normalizer.getStatement().setRequiresAliases(true);
        if (!this.getSubQuery().isCallQuery() && this.getSubQuery().getReferenceClass() == null) {
            Expression rightChild;
            ReportQuery subQuery = this.getSubQuery();
            Expression criteria = subQuery.getSelectionCriteria();
            if (criteria instanceof LogicalExpression) {
                criteria = ((LogicalExpression)criteria).getFirstChild();
            }
            if (criteria instanceof RelationExpression && (rightChild = ((RelationExpression)criteria).getSecondChild()) instanceof QueryKeyExpression) {
                ClassDescriptor descriptor = ((QueryKeyExpression)rightChild).getDescriptor();
                if (descriptor == null) {
                    descriptor = ((ObjectExpression)((QueryKeyExpression)rightChild).getBaseExpression()).getDescriptor();
                }
                subQuery.setReferenceClass(descriptor.getJavaClass());
            }
        }
        this.validateNode();
        this.getSubQuery().prepareSubSelect(normalizer.getSession(), null, clonedExpressions);
        if (!this.getSubQuery().isCallQuery()) {
            SQLSelectStatement statement = (SQLSelectStatement)((StatementQueryMechanism)this.getSubQuery().getQueryMechanism()).getSQLStatement();
            statement.setRequiresAliases(true);
            statement.setParentStatement(normalizer.getStatement());
            statement.normalize(normalizer.getSession(), this.getSubQuery().getDescriptor(), clonedExpressions);
        }
        return this;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        this.initializeCountSubQuery();
        super.postCopyIn(alreadyDone);
        ReportQuery clonedQuery = (ReportQuery)this.getSubQuery().clone();
        if (!clonedQuery.isCallQuery()) {
            if (clonedQuery.getSelectionCriteria() != null) {
                clonedQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().copiedVersionFrom(alreadyDone));
                if (clonedQuery.getExpressionBuilder() != null) {
                    clonedQuery.setExpressionBuilder((ExpressionBuilder)clonedQuery.getExpressionBuilder().copiedVersionFrom(alreadyDone));
                }
            } else if (clonedQuery.getExpressionBuilder() != null) {
                clonedQuery.setExpressionBuilder((ExpressionBuilder)clonedQuery.getExpressionBuilder().copiedVersionFrom(alreadyDone));
            }
            clonedQuery.copyReportItems(alreadyDone);
        }
        this.setSubQuery(clonedQuery);
    }

    protected void printCustomSQL(ExpressionSQLPrinter printer) {
        SQLCall call = (SQLCall)this.getSubQuery().getCall();
        call.translateCustomQuery();
        printer.getCall().getParameters().addAll(call.getParameters());
        printer.getCall().getParameterTypes().addAll(call.getParameterTypes());
        printer.printString(call.getCallString());
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        ReportQuery query = this.getSubQuery();
        printer.printString("(");
        if (query.isCallQuery()) {
            this.printCustomSQL(printer);
        } else {
            SQLSelectStatement statement = (SQLSelectStatement)((ExpressionQueryMechanism)query.getQueryMechanism()).getSQLStatement();
            boolean isFirstElementPrinted = printer.isFirstElementPrinted();
            printer.setIsFirstElementPrinted(false);
            boolean requiresDistinct = printer.requiresDistinct();
            statement.printSQL(printer);
            printer.setIsFirstElementPrinted(isFirstElementPrinted);
            printer.setRequiresDistinct(requiresDistinct);
        }
        printer.printString(")");
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        SubSelectExpression subSelect = (SubSelectExpression)this.shallowClone();
        subSelect.setBaseExpression(this.getBaseExpression().rebuildOn(newBase));
        ReportQuery reportQuery = (ReportQuery)this.getSubQuery().clone();
        ArrayList<ReportItem> newItems = new ArrayList<ReportItem>(this.getSubQuery().getItems().size());
        for (ReportItem item : reportQuery.getItems()) {
            newItems.add(new ReportItem(item.getName(), item.getAttributeExpression().twistedForBaseAndContext(newBase, this.getBuilder(), this.getBaseExpression())));
        }
        reportQuery.setItems(newItems);
        if (reportQuery.hasGroupByExpressions()) {
            ArrayList<Expression> groupByExpressions = new ArrayList<Expression>(reportQuery.getGroupByExpressions().size());
            for (Expression groupByExpression : reportQuery.getGroupByExpressions()) {
                groupByExpressions.add(groupByExpression.twistedForBaseAndContext(newBase, this.getBuilder(), this.getBaseExpression()));
            }
            reportQuery.setGroupByExpressions(groupByExpressions);
        }
        if (reportQuery.hasOrderByExpressions()) {
            ArrayList<Expression> orderByExpressions = new ArrayList<Expression>(reportQuery.getOrderByExpressions().size());
            for (Expression orderByExpression : reportQuery.getOrderByExpressions()) {
                orderByExpressions.add(orderByExpression.twistedForBaseAndContext(newBase, this.getBuilder(), this.getBaseExpression()));
            }
            reportQuery.setOrderByExpressions(orderByExpressions);
        }
        if (reportQuery.hasUnionExpressions()) {
            ArrayList<Expression> unionExpressions = new ArrayList<Expression>(reportQuery.getUnionExpressions().size());
            for (Expression unionExpression : reportQuery.getUnionExpressions()) {
                unionExpressions.add(unionExpression.twistedForBaseAndContext(newBase, this.getBuilder(), this.getBaseExpression()));
            }
            reportQuery.setUnionExpressions(unionExpressions);
        }
        if (reportQuery.getSelectionCriteria() != null) {
            reportQuery.setSelectionCriteria(reportQuery.getSelectionCriteria().twistedForBaseAndContext(newBase, this.getBuilder(), this.getBaseExpression()));
        }
        subSelect.setSubQuery(reportQuery);
        return subSelect;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        if (this.baseExpression.isExpressionBuilder() && ((ExpressionBuilder)this.baseExpression).wasQueryClassSetInternally()) {
            this.baseExpression = queryBuilder;
            if (this.builder != null) {
                this.builder = queryBuilder;
            }
        } else {
            this.baseExpression.resetPlaceHolderBuilder(queryBuilder);
        }
    }

    public void setSubQuery(ReportQuery subQuery) {
        this.subQuery = subQuery;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        SubSelectExpression subSelect = (SubSelectExpression)this.shallowClone();
        subSelect.setBaseExpression(subSelect.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase));
        ReportQuery reportQuery = (ReportQuery)this.getSubQuery().clone();
        ArrayList<ReportItem> newItems = new ArrayList<ReportItem>(this.getSubQuery().getItems().size());
        for (ReportItem item : this.getSubQuery().getItems()) {
            newItems.add(new ReportItem(item.getName(), item.getAttributeExpression().twistedForBaseAndContext(newBase, context, this.getBaseExpression())));
        }
        reportQuery.setItems(newItems);
        if (this.getSubQuery().hasGroupByExpressions()) {
            ArrayList<Expression> groupByExpressions = new ArrayList<Expression>(this.getSubQuery().getGroupByExpressions().size());
            for (Expression groupByExpression : this.getSubQuery().getGroupByExpressions()) {
                groupByExpressions.add(groupByExpression.twistedForBaseAndContext(newBase, context, this.getBaseExpression()));
            }
            reportQuery.setGroupByExpressions(groupByExpressions);
        }
        if (this.getSubQuery().hasOrderByExpressions()) {
            ArrayList<Expression> orderByExpressions = new ArrayList<Expression>(this.getSubQuery().getOrderByExpressions().size());
            for (Expression orderByExpression : this.getSubQuery().getOrderByExpressions()) {
                orderByExpressions.add(orderByExpression.twistedForBaseAndContext(newBase, context, this.getBaseExpression()));
            }
            reportQuery.setOrderByExpressions(orderByExpressions);
        }
        if (this.getSubQuery().hasUnionExpressions()) {
            ArrayList<Expression> unionByExpressions = new ArrayList<Expression>(this.getSubQuery().getUnionExpressions().size());
            for (Expression unionExpression : this.getSubQuery().getUnionExpressions()) {
                unionByExpressions.add(unionExpression.twistedForBaseAndContext(newBase, context, this.getBaseExpression()));
            }
            reportQuery.setUnionExpressions(unionByExpressions);
        }
        if (this.getSubQuery().getSelectionCriteria() != null) {
            reportQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().twistedForBaseAndContext(newBase, context, this.getBaseExpression()));
        }
        subSelect.setSubQuery(reportQuery);
        return subSelect;
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.getSubQuery()));
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getSubQuery().getSelectionCriteria() != null) {
            this.getSubQuery().getSelectionCriteria().toString(writer, indent);
        }
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, List<DatabaseField> newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        DatabaseField field = new DatabaseField("*");
        field.setSqlType(Integer.MIN_VALUE);
        newFields.add(field);
        this.printSQL(printer);
    }

    public static SubSelectExpression createSubSelectExpressionForCount(Expression outerQueryBaseExpression, Expression outerQueryCriteria, String attribute, Class returnType) {
        SubSelectExpression expression = new SubSelectExpression();
        expression.setBaseExpression(outerQueryBaseExpression);
        expression.attribute = attribute;
        expression.criteriaBase = outerQueryCriteria;
        if (returnType != null) {
            expression.returnType = returnType;
        }
        return expression;
    }
}

