/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.ReadLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class ConcurrencyManager
implements Serializable {
    public static final Map<Thread, DeferredLockManager> DEFERRED_LOCK_MANAGERS = ConcurrencyManager.initializeDeferredLockManagers();
    private static final AtomicLong CONCURRENCY_MANAGER_ID = new AtomicLong(0L);
    protected static boolean shouldTrackStack = PrivilegedAccessHelper.getSystemProperty("eclipselink.cache.record-stack-on-lock") != null;
    protected AtomicInteger numberOfReaders;
    protected AtomicInteger depth;
    protected AtomicInteger numberOfWritersWaiting;
    protected volatile transient Thread activeThread;
    protected boolean lockedByMergeManager;
    protected Exception stack;
    private final long concurrencyManagerId = CONCURRENCY_MANAGER_ID.incrementAndGet();
    private final Date concurrencyManagerCreationDate = new Date();
    private final AtomicLong totalNumberOfKeysAcquiredForReading = new AtomicLong(0L);
    private final AtomicLong totalNumberOfKeysReleasedForReading = new AtomicLong(0L);
    private final AtomicLong totalNumberOfKeysReleasedForReadingBlewUpExceptionDueToCacheKeyHavingReachedCounterZero = new AtomicLong(0L);
    private static final Map<Thread, ConcurrencyManager> THREADS_TO_WAIT_ON_ACQUIRE_READ_LOCK = new ConcurrentHashMap<Thread, ConcurrencyManager>();
    private static final Map<Thread, ConcurrencyManager> THREADS_TO_WAIT_ON_ACQUIRE = new ConcurrentHashMap<Thread, ConcurrencyManager>();
    private static final Map<Thread, ReadLockManager> READ_LOCK_MANAGERS = new ConcurrentHashMap<Thread, ReadLockManager>();
    private static final Set<Thread> THREADS_WAITING_TO_RELEASE_DEFERRED_LOCKS = ConcurrentHashMap.newKeySet();

    public ConcurrencyManager() {
        this.depth = new AtomicInteger(0);
        this.numberOfReaders = new AtomicInteger(0);
        this.numberOfWritersWaiting = new AtomicInteger(0);
    }

    public void acquire() throws ConcurrencyException {
        this.acquire(false);
    }

    public synchronized void acquire(boolean forMerge) throws ConcurrencyException {
        boolean currentThreadWillEnterTheWhileWait;
        long whileStartTimeMillis = System.currentTimeMillis();
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        boolean bl = currentThreadWillEnterTheWhileWait = (this.activeThread != null || this.numberOfReaders.get() > 0) && this.activeThread != currentThread;
        if (currentThreadWillEnterTheWhileWait) {
            this.putThreadAsWaitingToAcquireLockForWriting(currentThread);
        }
        while ((this.activeThread != null || this.numberOfReaders.get() > 0) && this.activeThread != Thread.currentThread()) {
            try {
                this.numberOfWritersWaiting.incrementAndGet();
                this.wait(ConcurrencyUtil.SINGLETON.getAcquireWaitTime());
                ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(this, whileStartTimeMillis, lockManager, readLockManager, ConcurrencyUtil.SINGLETON.isAllowInterruptedExceptionFired());
            }
            catch (InterruptedException exception) {
                this.releaseAllLocksAcquiredByThread(lockManager);
                if (currentThreadWillEnterTheWhileWait) {
                    this.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
                }
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
            finally {
                this.numberOfWritersWaiting.decrementAndGet();
            }
        }
        if (currentThreadWillEnterTheWhileWait) {
            this.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
        }
        if (this.activeThread == null) {
            this.activeThread = Thread.currentThread();
            if (shouldTrackStack) {
                this.stack = new Exception();
            }
        }
        this.lockedByMergeManager = forMerge;
        this.depth.incrementAndGet();
    }

    public boolean acquireNoWait() throws ConcurrencyException {
        return this.acquireNoWait(false);
    }

    public synchronized boolean acquireNoWait(boolean forMerge) throws ConcurrencyException {
        if (this.activeThread == null && this.numberOfReaders.get() == 0 || this.activeThread == Thread.currentThread()) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireWithWait(boolean forMerge, int wait) throws ConcurrencyException {
        Thread currentThread = Thread.currentThread();
        if (this.activeThread == null && this.numberOfReaders.get() == 0 || this.activeThread == currentThread) {
            this.acquire(forMerge);
            return true;
        }
        try {
            this.putThreadAsWaitingToAcquireLockForWriting(currentThread);
            this.wait(wait);
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
        }
        if (this.activeThread == null && this.numberOfReaders.get() == 0 || this.activeThread == currentThread) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireIfUnownedNoWait(boolean forMerge) throws ConcurrencyException {
        if (this.activeThread == null && this.numberOfReaders.get() == 0) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDeferredLock() throws ConcurrencyException {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        if (lockManager == null) {
            lockManager = new DeferredLockManager();
            this.putDeferredLock(currentThread, lockManager);
        }
        lockManager.incrementDepth();
        ConcurrencyManager concurrencyManager = this;
        synchronized (concurrencyManager) {
            boolean currentThreadWillEnterTheWhileWait;
            long whileStartTimeMillis = System.currentTimeMillis();
            boolean bl = currentThreadWillEnterTheWhileWait = this.numberOfReaders.get() != 0;
            if (currentThreadWillEnterTheWhileWait) {
                this.putThreadAsWaitingToAcquireLockForWriting(currentThread);
            }
            while (this.numberOfReaders.get() != 0) {
                try {
                    this.numberOfWritersWaiting.incrementAndGet();
                    this.wait(ConcurrencyUtil.SINGLETON.getAcquireWaitTime());
                    ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(this, whileStartTimeMillis, lockManager, readLockManager, ConcurrencyUtil.SINGLETON.isAllowInterruptedExceptionFired());
                }
                catch (InterruptedException exception) {
                    this.releaseAllLocksAcquiredByThread(lockManager);
                    if (currentThreadWillEnterTheWhileWait) {
                        this.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
                    }
                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                }
                finally {
                    this.numberOfWritersWaiting.decrementAndGet();
                }
            }
            if (currentThreadWillEnterTheWhileWait) {
                this.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
            }
            if (this.activeThread == currentThread || !this.isAcquired()) {
                lockManager.addActiveLock(this);
                this.acquire();
            } else {
                lockManager.addDeferredLock(this);
                if (AbstractSessionLog.getLog().shouldLog(2) && this instanceof CacheKey) {
                    AbstractSessionLog.getLog().log(2, "cache", "acquiring_deferred_lock", ((CacheKey)this).getObject(), (Object)currentThread.getName());
                }
            }
        }
    }

    public void checkDeferredLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireDeferredLock();
        this.releaseDeferredLock();
    }

    public void checkReadLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireReadLock();
        this.releaseReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquireReadLock() throws ConcurrencyException {
        boolean currentThreadWillEnterTheWhileWait;
        Thread currentThread = Thread.currentThread();
        long whileStartTimeMillis = System.currentTimeMillis();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        boolean bl = currentThreadWillEnterTheWhileWait = this.activeThread != null && this.activeThread != currentThread;
        if (currentThreadWillEnterTheWhileWait) {
            THREADS_TO_WAIT_ON_ACQUIRE_READ_LOCK.put(currentThread, this);
        }
        while (this.activeThread != null && this.activeThread != Thread.currentThread()) {
            try {
                this.wait(ConcurrencyUtil.SINGLETON.getAcquireWaitTime());
                ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(this, whileStartTimeMillis, lockManager, readLockManager, ConcurrencyUtil.SINGLETON.isAllowInterruptedExceptionFired());
            }
            catch (InterruptedException exception) {
                this.releaseAllLocksAcquiredByThread(lockManager);
                if (currentThreadWillEnterTheWhileWait) {
                    THREADS_TO_WAIT_ON_ACQUIRE_READ_LOCK.remove(currentThread);
                }
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
        }
        if (currentThreadWillEnterTheWhileWait) {
            THREADS_TO_WAIT_ON_ACQUIRE_READ_LOCK.remove(currentThread);
        }
        try {
            this.addReadLockToReadLockManager();
        }
        finally {
            this.numberOfReaders.incrementAndGet();
            this.totalNumberOfKeysAcquiredForReading.incrementAndGet();
        }
    }

    public synchronized boolean acquireReadLockNoWait() {
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquireReadLock();
            return true;
        }
        return false;
    }

    public Thread getActiveThread() {
        return this.activeThread;
    }

    public static DeferredLockManager getDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().get(thread);
    }

    protected static Map<Thread, DeferredLockManager> getDeferredLockManagers() {
        return DEFERRED_LOCK_MANAGERS;
    }

    protected static Map initializeDeferredLockManagers() {
        return new ConcurrentHashMap();
    }

    public int getDepth() {
        return this.depth.get();
    }

    public int getNumberOfReaders() {
        return this.numberOfReaders.get();
    }

    public int getNumberOfWritersWaiting() {
        return this.numberOfWritersWaiting.get();
    }

    public boolean isAcquired() {
        return this.depth.get() > 0;
    }

    public boolean isLockedByMergeManager() {
        return this.lockedByMergeManager;
    }

    public static boolean isBuildObjectOnThreadComplete(Thread thread, Map recursiveSet) {
        if (recursiveSet.containsKey(thread)) {
            return true;
        }
        recursiveSet.put(thread, thread);
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (lockManager == null) {
            return true;
        }
        Vector deferredLocks = lockManager.getDeferredLocks();
        Enumeration deferredLocksEnum = deferredLocks.elements();
        while (deferredLocksEnum.hasMoreElements()) {
            ConcurrencyManager deferedLock = (ConcurrencyManager)deferredLocksEnum.nextElement();
            Thread activeThread = null;
            if (!deferedLock.isAcquired() || (activeThread = deferedLock.getActiveThread()) == null) continue;
            DeferredLockManager currentLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (currentLockManager == null) {
                return false;
            }
            if (currentLockManager.isThreadComplete()) {
                activeThread = deferedLock.getActiveThread();
                if (activeThread == null || ConcurrencyManager.isBuildObjectOnThreadComplete(activeThread, recursiveSet)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNested() {
        return this.depth.get() > 1;
    }

    public void putDeferredLock(Thread thread, DeferredLockManager lockManager) {
        ConcurrencyManager.getDeferredLockManagers().put(thread, lockManager);
    }

    public synchronized void release() throws ConcurrencyException {
        if (this.depth.get() == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        this.depth.decrementAndGet();
        if (this.depth.get() == 0) {
            this.activeThread = null;
            if (shouldTrackStack) {
                this.stack = null;
            }
            this.lockedByMergeManager = false;
            this.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void releaseDeferredLock() throws ConcurrencyException {
        currentThread = Thread.currentThread();
        lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        if (lockManager == null) {
            return;
        }
        depth = lockManager.getThreadDepth();
        if (depth > 1) {
            lockManager.decrementDepth();
            return;
        }
        if (!lockManager.hasDeferredLock()) {
            lockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(currentThread);
            return;
        }
        lockManager.setIsThreadComplete(true);
        whileStartTimeMillis = System.currentTimeMillis();
        releaseAllLocksAquiredByThreadAlreadyPerformed = false;
        currentThreadRegisteredAsWaitingForisBuildObjectOnThreadComplete = false;
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                if (ConcurrencyManager.isBuildObjectOnThreadComplete(currentThread, recursiveSet = new IdentityHashMap<K, V>())) {
                    if (currentThreadRegisteredAsWaitingForisBuildObjectOnThreadComplete) {
                        ConcurrencyManager.THREADS_WAITING_TO_RELEASE_DEFERRED_LOCKS.remove(currentThread);
                    }
                    lockManager.releaseActiveLocksOnThread();
                    ConcurrencyManager.removeDeferredLockManager(currentThread);
                    AbstractSessionLog.getLog().log(2, "cache", "deferred_locks_released", (Object)currentThread.getName());
                    return;
                }
                try {
                    if (!currentThreadRegisteredAsWaitingForisBuildObjectOnThreadComplete) {
                        currentThreadRegisteredAsWaitingForisBuildObjectOnThreadComplete = true;
                        ConcurrencyManager.THREADS_WAITING_TO_RELEASE_DEFERRED_LOCKS.add(currentThread);
                    }
                    Thread.sleep(20L);
                    ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(this, whileStartTimeMillis, lockManager, readLockManager, ConcurrencyUtil.SINGLETON.isAllowInterruptedExceptionFired());
                    continue;
                }
                catch (InterruptedException interrupted) {
                    AbstractSessionLog.getLog().logThrowable(7, "cache", interrupted);
                    this.releaseAllLocksAcquiredByThread(lockManager);
                    releaseAllLocksAquiredByThreadAlreadyPerformed = true;
                    throw ConcurrencyException.waitWasInterrupted(interrupted.getMessage());
                }
                break;
            }
        }
        catch (Error error) {
            if (!releaseAllLocksAquiredByThreadAlreadyPerformed) {
                AbstractSessionLog.getLog().logThrowable(7, "cache", error);
                this.releaseAllLocksAcquiredByThread(lockManager);
            }
            throw error;
        }
        {
            ** while (true)
        }
    }

    public synchronized void releaseReadLock() throws ConcurrencyException {
        if (this.numberOfReaders.get() == 0) {
            this.totalNumberOfKeysReleasedForReadingBlewUpExceptionDueToCacheKeyHavingReachedCounterZero.incrementAndGet();
            try {
                this.removeReadLockFromReadLockManager();
            }
            catch (Exception e) {
                AbstractSessionLog.getLog().logThrowable(7, "cache", e);
            }
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        try {
            this.removeReadLockFromReadLockManager();
        }
        finally {
            this.numberOfReaders.decrementAndGet();
            this.totalNumberOfKeysReleasedForReading.incrementAndGet();
        }
        if (this.numberOfReaders.get() == 0) {
            this.notifyAll();
        }
    }

    public static DeferredLockManager removeDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().remove(thread);
    }

    public void setActiveThread(Thread activeThread) {
        this.activeThread = activeThread;
    }

    protected void setDepth(int depth) {
        this.depth.set(depth);
    }

    public void setIsLockedByMergeManager(boolean state) {
        this.lockedByMergeManager = state;
    }

    protected void setNumberOfReaders(int numberOfReaders) {
        this.numberOfReaders.set(numberOfReaders);
    }

    protected void setNumberOfWritersWaiting(int numberOfWritersWaiting) {
        this.numberOfWritersWaiting.set(numberOfWritersWaiting);
    }

    public synchronized void transitionToDeferredLock() {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            lockManager = new DeferredLockManager();
            this.putDeferredLock(currentThread, lockManager);
        }
        lockManager.incrementDepth();
        lockManager.addActiveLock(this);
    }

    public void releaseAllLocksAcquiredByThread(DeferredLockManager lockManager) {
        Thread currentThread = Thread.currentThread();
        if (lockManager == null) {
            String cacheKeyToString = ConcurrencyUtil.SINGLETON.createToStringExplainingOwnedCacheKey(this);
            AbstractSessionLog.getLog().log(7, "cache", "concurrency_manager_release_locks_acquired_by_thread_1", (Object)currentThread.getName(), (Object)cacheKeyToString);
            return;
        }
        AbstractSessionLog.getLog().log(7, "cache", "concurrency_manager_release_locks_acquired_by_thread_2", (Object)currentThread.toString());
        lockManager.releaseActiveLocksOnThread();
        ConcurrencyManager.removeDeferredLockManager(currentThread);
    }

    protected static ReadLockManager getReadLockManager(Thread thread) {
        Map<Thread, ReadLockManager> readLockManagers = ConcurrencyManager.getReadLockManagers();
        return readLockManagers.get(thread);
    }

    protected static Map<Thread, ReadLockManager> getReadLockManagers() {
        return READ_LOCK_MANAGERS;
    }

    public String toString() {
        Object[] args = new Object[]{this.getDepth()};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("nest_level", args);
    }

    public Exception getStack() {
        return this.stack;
    }

    public void setStack(Exception stack) {
        this.stack = stack;
    }

    public static boolean shouldTrackStack() {
        return shouldTrackStack;
    }

    public static void setShouldTrackStack(boolean shouldTrackStack) {
        ConcurrencyManager.shouldTrackStack = shouldTrackStack;
    }

    private static String getPropertyRecordStackOnLock() {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty("eclipselink.cache.record-stack-on-lock")) : System.getProperty("eclipselink.cache.record-stack-on-lock");
    }

    public void putThreadAsWaitingToAcquireLockForWriting(Thread thread) {
        THREADS_TO_WAIT_ON_ACQUIRE.put(thread, this);
    }

    public void removeThreadNoLongerWaitingToAcquireLockForWriting(Thread thread) {
        THREADS_TO_WAIT_ON_ACQUIRE.remove(thread);
    }

    public long getConcurrencyManagerId() {
        return this.concurrencyManagerId;
    }

    public Date getConcurrencyManagerCreationDate() {
        return this.concurrencyManagerCreationDate;
    }

    public long getTotalNumberOfKeysAcquiredForReading() {
        return this.totalNumberOfKeysAcquiredForReading.get();
    }

    public long getTotalNumberOfKeysReleasedForReading() {
        return this.totalNumberOfKeysReleasedForReading.get();
    }

    public long getTotalNumberOfKeysReleasedForReadingBlewUpExceptionDueToCacheKeyHavingReachedCounterZero() {
        return this.totalNumberOfKeysReleasedForReadingBlewUpExceptionDueToCacheKeyHavingReachedCounterZero.get();
    }

    public static Map<Thread, ConcurrencyManager> getThreadsToWaitOnAcquire() {
        return new HashMap<Thread, ConcurrencyManager>(THREADS_TO_WAIT_ON_ACQUIRE);
    }

    public static Map<Thread, ConcurrencyManager> getThreadsToWaitOnAcquireReadLock() {
        return THREADS_TO_WAIT_ON_ACQUIRE_READ_LOCK;
    }

    public static Set<Thread> getThreadsWaitingToReleaseDeferredLocks() {
        return new HashSet<Thread>(THREADS_WAITING_TO_RELEASE_DEFERRED_LOCKS);
    }

    protected void addReadLockToReadLockManager() {
        Thread currentThread = Thread.currentThread();
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManagerEnsureResultIsNotNull(currentThread);
        ConcurrencyManager concurrencyManagerCacheKey = this;
        readLockManager.addReadLock(concurrencyManagerCacheKey);
    }

    protected void removeReadLockFromReadLockManager() {
        Thread currentThread = Thread.currentThread();
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        if (readLockManager != null) {
            ConcurrencyManager concurrencyManagerCacheKey = this;
            readLockManager.removeReadLock(concurrencyManagerCacheKey);
            ConcurrencyManager.removeReadLockManagerIfEmpty(currentThread);
        } else {
            int currentNumberOfReaders = this.numberOfReaders.get();
            int decrementedNumberOfReaders = currentNumberOfReaders - 1;
            String errorMessage = ConcurrencyUtil.SINGLETON.readLockManagerProblem01CreateLogErrorMessageToIndicateThatCurrentThreadHasNullReadLockManagerWhileDecrementingNumberOfReaders(currentNumberOfReaders, decrementedNumberOfReaders, this);
            readLockManager = ConcurrencyManager.getReadLockManagerEnsureResultIsNotNull(currentThread);
            readLockManager.addRemoveReadLockProblemsDetected(errorMessage);
        }
    }

    protected static ReadLockManager getReadLockManagerEnsureResultIsNotNull(Thread thread) {
        Map<Thread, ReadLockManager> readLockManagers = ConcurrencyManager.getReadLockManagers();
        if (!readLockManagers.containsKey(thread)) {
            ReadLockManager readLockManager = new ReadLockManager();
            readLockManagers.putIfAbsent(thread, readLockManager);
            return readLockManager;
        }
        return readLockManagers.get(thread);
    }

    protected static void removeReadLockManagerIfEmpty(Thread thread) {
        ReadLockManager readLockManager;
        Map<Thread, ReadLockManager> readLockManagers = ConcurrencyManager.getReadLockManagers();
        if (readLockManagers.containsKey(thread) && (readLockManager = readLockManagers.get(thread)).isEmpty()) {
            readLockManagers.remove(thread);
        }
    }
}

