/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Label;

public final class ModuleHashesAttribute
extends Attribute {
    public String algorithm;
    public List<String> modules;
    public List<byte[]> hashes;

    public ModuleHashesAttribute(String string, List<String> list, List<byte[]> list2) {
        super("ModuleHashes");
        this.algorithm = string;
        this.modules = list;
        this.hashes = list2;
    }

    public ModuleHashesAttribute() {
        this(null, null, null);
    }

    @Override
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        String string = classReader.readUTF8(n, cArray);
        int n4 = classReader.readUnsignedShort(n + 2);
        ArrayList<String> arrayList = new ArrayList<String>(n4);
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(n4);
        n += 4;
        for (int i = 0; i < n4; ++i) {
            String string2 = classReader.readModule(n, cArray);
            int n5 = classReader.readUnsignedShort(n + 2);
            n += 4;
            byte[] byArray = new byte[n5];
            for (int j = 0; j < n5; ++j) {
                byArray[j] = (byte)(classReader.readByte(n + j) & 0xFF);
            }
            n += n5;
            arrayList.add(string2);
            arrayList2.add(byArray);
        }
        return new ModuleHashesAttribute(string, arrayList, arrayList2);
    }

    @Override
    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        int n4 = classWriter.newUTF8(this.algorithm);
        byteVector.putShort(n4);
        int n5 = this.modules == null ? 0 : this.modules.size();
        byteVector.putShort(n5);
        for (int i = 0; i < n5; ++i) {
            String string = this.modules.get(i);
            byteVector.putShort(classWriter.newModule(string));
            byte[] byArray2 = this.hashes.get(i);
            byteVector.putShort(byArray2.length);
            for (byte by : byArray2) {
                byteVector.putByte(by);
            }
        }
        return byteVector;
    }
}

