/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collection;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

abstract class AbstractObjectLevelReadQueryVisitor
extends AbstractEclipseLinkExpressionVisitor {
    ObjectLevelReadQuery query;
    final JPQLQueryContext queryContext;

    AbstractObjectLevelReadQueryVisitor(JPQLQueryContext queryContext, ObjectLevelReadQuery query) {
        this.query = query;
        this.queryContext = queryContext;
    }

    @Override
    public void visit(org.eclipse.persistence.jpa.jpql.parser.AsOfClause expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression);
        AsOfClause asOfClause = expression.hasScn() ? new AsOfSCNClause(queryExpression) : new AsOfClause(queryExpression);
        this.query.setAsOfClause(asOfClause);
        this.query.setShouldMaintainCache(false);
    }

    @Override
    public void visit(CollectionExpression expression) {
        expression.acceptChildren(this);
    }

    @Override
    public void visit(FromClause expression) {
        this.visitAbstractFromClause(expression);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        this.visitIdentificationVariable(expression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(OrderByClause expression) {
        expression.getOrderByItems().accept(this);
    }

    @Override
    public void visit(OrderByItem expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression);
        this.query.addOrdering(queryExpression);
    }

    @Override
    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    @Override
    public void visit(SelectStatement expression) {
        this.visitAbstractSelectStatement(expression);
        if (expression.hasOrderByClause()) {
            expression.getOrderByClause().accept(this);
        }
        if (expression.hasUnionClauses()) {
            expression.getUnionClauses().accept(this);
        }
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.visitAbstractFromClause(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        this.visitAbstractSelectStatement(expression);
    }

    @Override
    public void visit(UnionClause expression) {
        ReportQuery subquery = this.queryContext.buildSubquery((SimpleSelectStatement)expression.getQuery());
        org.eclipse.persistence.expressions.Expression union = null;
        if (expression.isUnion()) {
            union = expression.hasAll() ? this.query.getExpressionBuilder().unionAll(subquery) : this.query.getExpressionBuilder().union(subquery);
        } else if (expression.isIntersect()) {
            union = expression.hasAll() ? this.query.getExpressionBuilder().intersectAll(subquery) : this.query.getExpressionBuilder().intersect(subquery);
        } else if (expression.isExcept()) {
            union = expression.hasAll() ? this.query.getExpressionBuilder().exceptAll(subquery) : this.query.getExpressionBuilder().except(subquery);
        }
        this.query.addUnionExpression(union);
    }

    @Override
    public void visit(WhereClause expression) {
        this.query.setSelectionCriteria(this.queryContext.buildExpression(expression));
    }

    void visitAbstractFromClause(AbstractFromClause expression) {
        org.eclipse.persistence.expressions.Expression baseExpression = this.queryContext.getBaseExpression();
        ExpressionBuilder expressionBuilder = baseExpression.getBuilder();
        this.query.setExpressionBuilder(expressionBuilder);
        if (this.query.getReferenceClass() == null) {
            this.query.setReferenceClass(expressionBuilder.getQueryClass());
            this.query.changeDescriptor(this.queryContext.getSession());
        }
        JoinVisitor visitor = new JoinVisitor();
        expression.accept(visitor);
        if (expression.hasAsOfClause()) {
            expression.getAsOfClause().accept(this);
        }
        if (expression.hasHierarchicalQueryClause()) {
            expression.getHierarchicalQueryClause().accept(this);
        }
    }

    void visitAbstractSelectClause(AbstractSelectClause expression) {
        EclipseLinkAnonymousExpressionVisitor visitor;
        if (expression.hasDistinct()) {
            visitor = new CountFunctionVisitor();
            expression.accept(visitor);
            if (!visitor.hasCountFunction) {
                this.query.useDistinct();
            }
        }
        visitor = new OneToOneSelectedVisitor();
        expression.accept(visitor);
        this.query.setShouldBuildNullForNullPk(((OneToOneSelectedVisitor)visitor).oneToOneSelected);
        expression.getSelectExpression().accept(this);
    }

    void visitAbstractSelectStatement(AbstractSelectStatement expression) {
        expression.getFromClause().accept(this);
        expression.getSelectClause().accept(this);
        if (expression.hasWhereClause()) {
            expression.getWhereClause().accept(this);
        }
    }

    void visitIdentificationVariable(IdentificationVariable expression) {
        String variableName = expression.getVariableName();
        Collection<Join> joinFetches = this.queryContext.getJoinFetches(variableName);
        if (joinFetches != null) {
            for (Join joinFetch : joinFetches) {
                String joinFetchVariableName = this.queryContext.literal(joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                if (!variableName.equals(joinFetchVariableName)) continue;
                org.eclipse.persistence.expressions.Expression queryExpression = null;
                if (joinFetch.hasIdentificationVariable()) {
                    String identificationVariable = this.queryContext.literal(joinFetch, LiteralType.IDENTIFICATION_VARIABLE);
                    queryExpression = this.queryContext.findQueryExpression(identificationVariable);
                }
                if (queryExpression == null) {
                    queryExpression = this.queryContext.buildExpression(joinFetch);
                }
                this.query.addJoinedAttribute(queryExpression);
            }
        }
    }

    private static class CountFunctionVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        boolean hasCountFunction;

        private CountFunctionVisitor() {
        }

        @Override
        public void visit(CountFunction expression) {
            this.hasCountFunction = true;
        }

        @Override
        protected void visit(Expression expression) {
            this.hasCountFunction = false;
        }

        @Override
        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }
    }

    private class JoinVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private org.eclipse.persistence.expressions.Expression baseExpression;

        private JoinVisitor() {
        }

        private org.eclipse.persistence.expressions.Expression addNonFetchJoinedAttribute(Expression expression, IdentificationVariable identificationVariable) {
            ObjectLevelReadQuery query;
            String variableName = identificationVariable.getVariableName();
            org.eclipse.persistence.expressions.Expression queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.getQueryExpression(variableName);
            if (queryExpression == null) {
                queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildExpression(expression);
                AbstractObjectLevelReadQueryVisitor.this.queryContext.addQueryExpression(variableName, queryExpression);
            }
            if ((query = (ObjectLevelReadQuery)AbstractObjectLevelReadQueryVisitor.this.queryContext.getDatabaseQuery()).getExpressionBuilder() != queryExpression) {
                query.addNonFetchJoinedAttribute(queryExpression);
            }
            return queryExpression;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            this.addNonFetchJoinedAttribute(expression, (IdentificationVariable)expression.getIdentificationVariable());
        }

        @Override
        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
            if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            }
        }

        @Override
        public void visit(Join expression) {
            if (expression.hasIdentificationVariable()) {
                IdentificationVariable identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
                org.eclipse.persistence.expressions.Expression queryExpression = null;
                if (expression.hasFetch()) {
                    String variableName = identificationVariable.getVariableName();
                    queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.getQueryExpression(variableName);
                    if (queryExpression == null) {
                        queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildExpression(expression);
                        AbstractObjectLevelReadQueryVisitor.this.queryContext.addQueryExpression(variableName, queryExpression);
                    }
                } else {
                    queryExpression = this.addNonFetchJoinedAttribute(expression, identificationVariable);
                }
                if (expression.hasOnClause()) {
                    org.eclipse.persistence.expressions.Expression onClause = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildExpression(expression.getOnClause());
                    if (expression.isLeftJoin()) {
                        queryExpression = this.baseExpression.leftJoin(queryExpression, onClause);
                    } else {
                        org.eclipse.persistence.expressions.Expression expression2 = this.baseExpression.join(queryExpression, onClause);
                    }
                }
            }
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            this.baseExpression = this.addNonFetchJoinedAttribute(expression, (IdentificationVariable)expression.getIdentificationVariable());
        }

        @Override
        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept(this);
        }
    }

    private class OneToOneSelectedVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        boolean oneToOneSelected;

        private OneToOneSelectedVisitor() {
        }

        @Override
        public void visit(AvgFunction expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(CollectionExpression expression) {
            for (Expression child : expression.children()) {
                child.accept(this);
                if (this.oneToOneSelected) break;
            }
        }

        @Override
        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept(this);
        }

        @Override
        public void visit(CountFunction expression) {
            this.oneToOneSelected = false;
        }

        @Override
        public void visit(IdentificationVariable expression) {
            this.oneToOneSelected = !AbstractObjectLevelReadQueryVisitor.this.queryContext.isRangeIdentificationVariable(expression.getVariableName());
        }

        @Override
        public void visit(KeyExpression expression) {
            this.oneToOneSelected = true;
        }

        @Override
        public void visit(MaxFunction expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(MinFunction expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(ObjectExpression expression) {
            expression.getExpression().accept(this);
        }

        @Override
        protected void visit(Expression expression) {
            this.oneToOneSelected = true;
        }

        @Override
        public void visit(ResultVariable expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            DatabaseMapping mapping = AbstractObjectLevelReadQueryVisitor.this.queryContext.resolveMapping(expression);
            this.oneToOneSelected = mapping != null && !mapping.isDirectToFieldMapping();
        }

        @Override
        public void visit(SumFunction expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(ValueExpression expression) {
            this.oneToOneSelected = true;
        }
    }
}

