/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MultiArgInstantiationPolicy
extends InstantiationPolicy {
    private String[] parameterTypeNames;
    private Class[] parameterTypes;
    private Object[] defaultValues;

    public void setParameterTypeNames(String[] parameterTypeNames) {
        this.parameterTypeNames = parameterTypeNames;
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setDefaultValues(Object[] values) {
        this.defaultValues = values;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader loader) {
        super.convertClassNamesToClasses(loader);
        if (this.parameterTypes == null && this.parameterTypeNames != null) {
            Class[] values = new Class[this.parameterTypeNames.length];
            int i = 0;
            while (i < values.length) {
                block7: {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                values[i] = AccessController.doPrivileged(new PrivilegedClassForName(this.parameterTypeNames[i], true, loader));
                                break block7;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.parameterTypeNames[i], exception.getException());
                            }
                        }
                        values[i] = PrivilegedAccessHelper.getClassForName(this.parameterTypeNames[i], true, loader);
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.factoryClassName, exc);
                    }
                }
                ++i;
            }
            this.parameterTypes = values;
        }
    }

    @Override
    protected void initializeMethod() throws DescriptorException {
        Class tempClass = this.getFactory() != null ? this.getFactory().getClass() : (this.getFactoryClass() == null ? this.getDescriptor().getJavaClass() : this.getFactoryClass());
        if (this.parameterTypes == null) {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), new Class[0]));
        } else {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), this.parameterTypes));
        }
    }

    @Override
    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), this.getFactory(), this.defaultValues));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), throwableException);
                    }
                    throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), throwableException);
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.getMethod(), this.getFactory(), this.defaultValues);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
    }
}

