/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class MarshalCallback {
    private Class domainClass;
    private String domainClassName;
    private Method beforeMarshalCallback;
    private Method afterMarshalCallback;
    private boolean hasBeforeMarshalCallback = false;
    private boolean hasAfterMarshalCallback = false;

    public Method getAfterMarshalCallback() {
        return this.afterMarshalCallback;
    }

    public Method getBeforeMarshalCallback() {
        return this.beforeMarshalCallback;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader loader) {
        block22: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.domainClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.domainClassName, true, loader));
                        break block22;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                this.domainClass = PrivilegedAccessHelper.getClassForName(this.domainClassName, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }
        Class[] params = new Class[]{Marshaller.class};
        if (this.hasBeforeMarshalCallback) {
            try {
                Method beforeMarshal = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        beforeMarshal = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "beforeMarshal", params, false));
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                } else {
                    beforeMarshal = PrivilegedAccessHelper.getMethod(this.domainClass, "beforeMarshal", params, false);
                }
                this.setBeforeMarshalCallback(beforeMarshal);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (this.hasAfterMarshalCallback) {
            try {
                Method afterMarshal = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        afterMarshal = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "afterMarshal", params, false));
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                } else {
                    afterMarshal = PrivilegedAccessHelper.getMethod(this.domainClass, "afterMarshal", params, false);
                }
                this.setAfterMarshalCallback(afterMarshal);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public void setAfterMarshalCallback(Method method) {
        this.afterMarshalCallback = method;
    }

    public void setHasAfterMarshalCallback() {
        this.hasAfterMarshalCallback = true;
    }

    public void setBeforeMarshalCallback(Method method) {
        this.beforeMarshalCallback = method;
    }

    public void setHasBeforeMarshalCallback() {
        this.hasBeforeMarshalCallback = true;
    }

    public void setDomainClass(Class clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String className) {
        this.domainClassName = className;
    }
}

