/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class WriterRecord
extends MarshalRecord {
    protected Writer writer;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    protected CharsetEncoder encoder;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument(String encoding, String version) {
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(version);
            this.writer.write(34);
            if (null != encoding) {
                this.writer.write(" encoding=\"");
                this.writer.write(encoding);
                this.writer.write(34);
            }
            this.writer.write("?>");
            this.writer.write(Helper.cr());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
            }
            this.isStartElementOpen = true;
            this.writer.write(60);
            this.writer.write(this.getNameForFragment(xPathFragment));
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(60);
            this.writer.write(this.getNameForFragment(frag));
            this.writer.write(47);
            this.writer.write(62);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(null, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment), value);
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        try {
            this.writer.write(32);
            this.writer.write(qName);
            this.writer.write(61);
            this.writer.write(34);
            this.writeValue(value, true, this.writer);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(47);
                this.writer.write(62);
                this.isStartElementOpen = false;
            } else {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(this.getNameForFragment(xPathFragment));
                this.writer.write(62);
            }
            this.isStartElementOpen = false;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            this.writeValue(value);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            this.writer.write("<![CDATA[");
            this.writer.write(value);
            this.writer.write("]]>");
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeValue(String value) {
        this.writeValue(value, false, this.writer);
    }

    protected void writeValue(String value, boolean isAttribute, Writer writer) {
        CharacterEscapeHandler escapeHandler = null;
        if (this.marshaller != null) {
            escapeHandler = this.marshaller.getCharacterEscapeHandler();
        }
        if (escapeHandler != null) {
            try {
                escapeHandler.escape(value.toCharArray(), 0, value.length(), isAttribute, writer);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
            return;
        }
        try {
            if (null != this.encoder && this.encoder.maxBytesPerChar() < 4.0f || value.indexOf(34) > -1 || value.indexOf(38) > -1 || value.indexOf(60) > -1) {
                block9: for (char character : value.toCharArray()) {
                    switch (character) {
                        case '&': {
                            writer.write("&amp;");
                            continue block9;
                        }
                        case '<': {
                            writer.write("&lt;");
                            continue block9;
                        }
                        case '\"': {
                            writer.write("&quot;");
                            continue block9;
                        }
                        default: {
                            if (this.encoder.canEncode(character)) {
                                writer.write(character);
                                continue block9;
                            }
                            writer.write("&#");
                            writer.write(String.valueOf((int)character));
                            writer.write(59);
                        }
                    }
                }
            } else {
                writer.write(value);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            String namespaceURI = attr.getNamespaceURI();
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                WriterRecordContentHandler wrcHandler = new WriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.encoder = Charset.forName(marshaller.getEncoding()).newEncoder();
    }

    protected class WriterRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        WriterRecordContentHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.writer.write(62);
                }
                WriterRecord.this.writer.write(60);
                WriterRecord.this.writer.write(qName);
                WriterRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.writer.write(47);
                    WriterRecord.this.writer.write(62);
                } else {
                    WriterRecord.this.writer.write(60);
                    WriterRecord.this.writer.write(47);
                    WriterRecord.this.writer.write(qName);
                    WriterRecord.this.writer.write(62);
                }
                WriterRecord.this.isStartElementOpen = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = WriterRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        public void characters(CharSequence characters) throws SAXException {
            if (WriterRecord.this.isProcessingCData) {
                WriterRecord.this.cdata(((Object)characters).toString());
                return;
            }
            if (WriterRecord.this.isStartElementOpen) {
                try {
                    WriterRecord.this.writer.write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            WriterRecord.this.writeValue(((Object)characters).toString());
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.writer.write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    Set<Map.Entry<String, String>> entries = this.prefixMappings.entrySet();
                    for (Map.Entry<String, String> nextEntry : entries) {
                        String prefix = nextEntry.getKey();
                        WriterRecord.this.writer.write(32);
                        WriterRecord.this.writer.write("xmlns");
                        if (null != prefix && prefix.length() > 0) {
                            WriterRecord.this.writer.write(58);
                            WriterRecord.this.writer.write(prefix);
                        }
                        WriterRecord.this.writer.write(61);
                        WriterRecord.this.writer.write(34);
                        String uri = nextEntry.getValue();
                        if (null != uri) {
                            WriterRecord.this.writer.write(uri);
                        }
                        WriterRecord.this.writer.write(34);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            int attsLength = atts.getLength();
            for (int i = 0; i < attsLength; ++i) {
                String qName = atts.getQName(i);
                if (qName != null && (qName.startsWith("xmlns:") || qName.equals("xmlns"))) continue;
                WriterRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            try {
                WriterRecord.this.writer.write(60);
                WriterRecord.this.writer.write(33);
                WriterRecord.this.writer.write(45);
                WriterRecord.this.writer.write(45);
                for (int x = start; x < length; ++x) {
                    WriterRecord.this.writer.write(chars[x]);
                }
                WriterRecord.this.writer.write(45);
                WriterRecord.this.writer.write(45);
                WriterRecord.this.writer.write(62);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                for (int x = start; x < length; ++x) {
                    WriterRecord.this.writer.write(chars[x]);
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

