/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.eclipse.paho.sample.utility.MQTTFrame;

public class SubPanel
implements ActionListener {
    private JPanel subPanel;
    private JComboBox topic;
    private JTextField receivedTopic;
    private JTextField receivedQoS;
    private JCheckBox receivedRetain;
    private JTextArea receivedData;
    private MQTTFrame mqttMgr = null;
    private Integer[] qos = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private JComboBox qosList;
    private boolean hexDisplay = true;
    private JLabel subLabel = null;
    private JButton hexButton = null;
    private JButton fileButton;
    private JButton subButton;
    private JButton unsubButton;
    private static final String PANEL_TITLE = " Subscribe To Topics";
    private File fileChooserCurrentDir = null;
    private byte[] fileContent = null;

    public SubPanel(JPanel theSubPanel, MQTTFrame aMqttMgr) {
        this.subPanel = theSubPanel;
        this.subPanel.setBorder(new EtchedBorder());
        this.mqttMgr = aMqttMgr;
        this.init();
    }

    public void init() {
        this.subPanel.setLayout(new BorderLayout());
        this.topic = new JComboBox();
        this.topic.setEditable(true);
        this.topic.setMaximumSize(MQTTFrame.TEXT_FIELD_DIMENSION);
        this.topic.setMaximumRowCount(5);
        this.receivedTopic = new JTextField(15);
        this.receivedTopic.setMaximumSize(MQTTFrame.TEXT_FIELD_DIMENSION);
        this.receivedTopic.setEditable(false);
        this.receivedTopic.setBackground(Color.lightGray);
        this.receivedTopic.setMargin(MQTTFrame.TEXT_MARGINS);
        this.receivedQoS = new JTextField(3);
        this.receivedQoS.setMaximumSize(MQTTFrame.DROP_DOWN_DIMENSION);
        this.receivedQoS.setEditable(false);
        this.receivedQoS.setBackground(Color.lightGray);
        this.receivedQoS.setMargin(MQTTFrame.TEXT_MARGINS);
        this.receivedRetain = new JCheckBox();
        this.receivedRetain.setMaximumSize(MQTTFrame.DROP_DOWN_DIMENSION);
        this.receivedRetain.setEnabled(false);
        this.receivedRetain.setMargin(MQTTFrame.TEXT_MARGINS);
        this.receivedRetain.setSelected(false);
        this.receivedData = new JTextArea(3, 30);
        this.receivedData.setBorder(new BevelBorder(1));
        this.receivedData.setEditable(false);
        this.receivedData.setBackground(Color.lightGray);
        this.receivedData.setMargin(MQTTFrame.TEXT_MARGINS);
        this.qosList = new JComboBox<Integer>(this.qos);
        this.qosList.setSelectedIndex(0);
        this.qosList.setMaximumSize(MQTTFrame.DROP_DOWN_DIMENSION);
        this.qosList.setToolTipText("The QoS at which publications will be delivered");
        JPanel sendTopicPanel = new JPanel();
        sendTopicPanel.setLayout(new BoxLayout(sendTopicPanel, 0));
        sendTopicPanel.add(new JLabel(" Subscribe Topic:"));
        sendTopicPanel.add(this.topic);
        sendTopicPanel.add(new JLabel(" Request QoS:"));
        sendTopicPanel.add(this.qosList);
        sendTopicPanel.add(new JLabel("  "));
        JPanel rcvdTopicPanel = new JPanel();
        rcvdTopicPanel.setLayout(new BoxLayout(rcvdTopicPanel, 0));
        rcvdTopicPanel.add(new JLabel(" Received Topic:"));
        rcvdTopicPanel.add(this.receivedTopic);
        rcvdTopicPanel.add(new JLabel(" QoS:"));
        rcvdTopicPanel.add(this.receivedQoS);
        rcvdTopicPanel.add(new JLabel(" Retained:"));
        rcvdTopicPanel.add(this.receivedRetain);
        JPanel titleAndTopics = new JPanel();
        titleAndTopics.setLayout(new GridLayout(3, 1));
        this.subLabel = new JLabel(" Subscribe To Topics - text display");
        Font f = this.subLabel.getFont();
        this.subLabel.setFont(new Font(f.getName(), 1, f.getSize() + 1));
        titleAndTopics.add(this.subLabel);
        titleAndTopics.add(sendTopicPanel);
        titleAndTopics.add(rcvdTopicPanel);
        JPanel subButtonsLayout = new JPanel();
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(4, 1));
        this.hexDisplay = false;
        this.hexButton = new JButton("Hex");
        this.hexButton.addActionListener(this);
        this.fileButton = new JButton("Save...");
        this.fileButton.setEnabled(true);
        this.fileButton.addActionListener(this);
        this.subButton = new JButton("Subscribe");
        this.subButton.setEnabled(false);
        this.subButton.addActionListener(this);
        this.unsubButton = new JButton("Unsubscribe");
        this.unsubButton.setEnabled(false);
        this.unsubButton.addActionListener(this);
        buttons.add(this.subButton);
        buttons.add(this.unsubButton);
        buttons.add(this.fileButton);
        buttons.add(this.hexButton);
        subButtonsLayout.add(buttons);
        this.subPanel.add((Component)titleAndTopics, "North");
        this.subPanel.add((Component)new JScrollPane(this.receivedData), "Center");
        this.subPanel.add((Component)subButtonsLayout, "East");
    }

    public boolean updateTopicList(String topicName) {
        return this.mqttMgr.updateComboBoxList(this.topic, topicName);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String topicName = (String)this.topic.getSelectedItem();
        if (this.updateTopicList(topicName)) {
            this.mqttMgr.updatePublishTopicList(topicName);
        }
        if (e.getActionCommand().equals("Subscribe")) {
            this.mqttMgr.subscription(topicName, this.qosList.getSelectedIndex(), true);
        } else if (e.getActionCommand().equals("Unsubscribe")) {
            this.mqttMgr.subscription(topicName, 0, false);
        } else if (e.getActionCommand().equals("Save...")) {
            JFileChooser selectFile = new JFileChooser(this.fileChooserCurrentDir);
            selectFile.setMultiSelectionEnabled(false);
            if (selectFile.showSaveDialog(this.subPanel) == 0) {
                this.fileChooserCurrentDir = selectFile.getCurrentDirectory();
                File theFile = selectFile.getSelectedFile();
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(theFile);
                    output.write(this.fileContent);
                }
                catch (FileNotFoundException fnfe) {
                    JOptionPane.showMessageDialog(this.subPanel, fnfe.getMessage(), "File Save Error", 0);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.subPanel, ioe.getMessage(), "File Save Error", 0);
                }
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } else if (!this.hexDisplay) {
            this.toHexString();
        } else {
            this.toCharString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReceivedData(String topic, byte[] data, int QoS, boolean retained) {
        boolean writeHex = this.hexDisplay;
        if (this.hexDisplay) {
            this.toCharString();
        }
        this.receivedTopic.setText(topic);
        this.receivedQoS.setText(Integer.toString(QoS));
        this.receivedRetain.setSelected(retained);
        this.receivedData.setText(new String(data));
        this.fileContent = data;
        if (writeHex) {
            this.toHexString();
        }
        MQTTFrame mQTTFrame = this.mqttMgr;
        synchronized (mQTTFrame) {
            this.mqttMgr.writeLogln("  --> PUBLISH received, TOPIC:" + topic + ", QoS:" + QoS + ", Retained:" + retained);
            this.mqttMgr.writeLog("                        DATA:");
            if (writeHex) {
                this.mqttMgr.writeLog("0x");
            }
            this.mqttMgr.writeLogln(this.receivedData.getText());
        }
    }

    private void toHexString() {
        String subText = this.receivedData.getText();
        StringBuffer hexText = new StringBuffer();
        byte[] subBytes = subText.getBytes();
        for (int i = 0; i < subBytes.length; ++i) {
            int byteValue = subBytes[i];
            if (byteValue < 0) {
                byteValue += 256;
            }
            if (byteValue < 16) {
                hexText.append("0" + Integer.toHexString(byteValue));
                continue;
            }
            hexText.append(Integer.toHexString(byteValue));
        }
        this.hexDisplay = true;
        this.subLabel.setText(" Subscribe To Topics - hexadecimal display");
        this.mqttMgr.setTitleText("");
        this.hexButton.setText("Text");
        this.receivedData.setText(hexText.toString());
    }

    private void toCharString() {
        String hexText = this.receivedData.getText();
        if (hexText.length() % 2 != 0) {
            System.out.println("Hex length" + hexText.length());
            this.mqttMgr.setTitleText("Odd number of hex characters!");
        } else {
            try {
                byte[] charArray = new byte[hexText.length() / 2];
                for (int i = 0; i < charArray.length; ++i) {
                    charArray[i] = (byte)Integer.parseInt(hexText.substring(i * 2, i * 2 + 2), 16);
                }
                this.hexDisplay = false;
                this.subLabel.setText(" Subscribe To Topics - text display");
                this.mqttMgr.setTitleText("");
                this.hexButton.setText("Hex");
                this.receivedData.setText(new String(charArray));
            }
            catch (NumberFormatException nfe) {
                this.mqttMgr.setTitleText("Invalid hexadecimal data!");
            }
        }
    }

    public void enableButtons(boolean b) {
        this.subButton.setEnabled(b);
        this.unsubButton.setEnabled(b);
    }
}

