/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.sample.utility.ConnOpts;
import org.eclipse.paho.sample.utility.LED;
import org.eclipse.paho.sample.utility.MQTTHist;
import org.eclipse.paho.sample.utility.PubPanel;
import org.eclipse.paho.sample.utility.SubPanel;

public class MQTTFrame
implements ActionListener,
MqttCallback,
Runnable {
    private JPanel connPanel = new JPanel();
    private JPanel pubPanel = new JPanel();
    private JPanel subPanel = new JPanel();
    private PubPanel pubPanelContr;
    private SubPanel subPanelContr;
    private ConnOpts optionsComp = null;
    private MQTTHist historyComp = null;
    private JPanel mqttComp = null;
    private JComboBox ipAddress;
    private JComboBox port;
    private LED led;
    private JButton connect;
    private JButton disconnect;
    private MqttClient mqtt = null;
    private MqttConnectOptions opts = null;
    private boolean connected = false;
    private boolean traceEnabled = false;
    private Object connLostWait = new Object();
    private JFrame frame = null;
    protected static final Dimension TEXT_FIELD_DIMENSION = new Dimension(1000, 20);
    protected static final Dimension DROP_DOWN_DIMENSION = new Dimension(35, 20);
    protected static final Insets TEXT_MARGINS = new Insets(3, 3, 3, 3);
    protected static final int FRAME_WIDTH = 375;
    protected static final int FRAME_HEIGHT = 450;
    private static final String PROP_FILE = "mqtt.properties";
    private static final String PROP_DELIM = ";";
    private static final String DEFAULT_IP_ADDRESS = "127.0.0.1";
    private static final String DEFAULT_PORT_NUMBER = "1883";

    public static void main(String[] args) {
        JFrame theFrame = null;
        final MQTTFrame view = new MQTTFrame();
        theFrame = view.getJFrame();
        theFrame.setSize(375, 450);
        theFrame.setLocation(150, 50);
        theFrame.setResizable(true);
        view.init(theFrame.getContentPane());
        theFrame.setVisible(true);
        theFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FileOutputStream propFile = null;
                Properties props = new Properties();
                try {
                    propFile = new FileOutputStream(MQTTFrame.PROP_FILE);
                    props.setProperty("IPAddressList", view.constructPropertyValue("IPAddressList"));
                    props.setProperty("IPPortList", view.constructPropertyValue("IPPortList"));
                    props.setProperty("ClientId", view.constructPropertyValue("ClientId"));
                    props.setProperty("Persistence", view.constructPropertyValue("Persistence"));
                    props.setProperty("PersistenceDir", view.constructPropertyValue("PersistenceDir"));
                    props.store(propFile, "MQTT Utility properties");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
    }

    private JFrame getJFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
        }
        return this.frame;
    }

    protected void init(Container contentPane) {
        FileInputStream propFile = null;
        Properties props = new Properties();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            propFile = new FileInputStream(PROP_FILE);
            props.load(propFile);
        }
        catch (Exception fe) {
            propFile = null;
        }
        this.setTitleText("");
        this.connPanel.setLayout(new GridLayout(2, 1));
        this.connPanel.setBorder(new EtchedBorder());
        this.mqttComp = new JPanel(new BorderLayout());
        this.historyComp = new MQTTHist(this.getJFrame(), this.optionsComp);
        this.mqttComp.add((Component)this.connPanel, "North");
        JSplitPane pubsub = new JSplitPane(0, true, this.subPanel, this.pubPanel);
        pubsub.setOneTouchExpandable(true);
        pubsub.setDividerSize(10);
        pubsub.setResizeWeight(0.5);
        this.mqttComp.add((Component)pubsub, "Center");
        this.ipAddress = new JComboBox();
        this.ipAddress.setPreferredSize(new Dimension(125, 20));
        this.ipAddress.setEditable(true);
        this.getProperties(props, this.ipAddress, "IPAddressList", DEFAULT_IP_ADDRESS);
        this.port = new JComboBox();
        this.port.setPreferredSize(new Dimension(65, 20));
        this.port.setEditable(true);
        this.getProperties(props, this.port, "IPPortList", DEFAULT_PORT_NUMBER);
        this.optionsComp = new ConnOpts(this, props);
        this.led = new LED();
        this.led.setRed();
        new Thread(this.led).start();
        this.connect = new JButton("Connect");
        this.disconnect = new JButton("Disconnect");
        this.disconnect.setEnabled(false);
        JButton history = new JButton("History");
        this.connect.addActionListener(this);
        this.disconnect.addActionListener(this);
        history.addActionListener(this);
        JPanel text = new JPanel();
        text.add(new JLabel("Broker TCP/IP address: "));
        text.add(this.ipAddress);
        text.add(this.port);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(new JSeparator(1));
        buttons.add(this.led);
        buttons.add(this.connect);
        buttons.add(new JLabel("  "));
        buttons.add(this.disconnect);
        buttons.add(new JSeparator(1));
        buttons.add(history);
        buttons.add(new JSeparator(1));
        this.connPanel.add(text);
        this.connPanel.add(buttons);
        this.pubPanelContr = new PubPanel(this.pubPanel, this);
        this.subPanelContr = new SubPanel(this.subPanel, this);
        if (propFile != null) {
            try {
                propFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JTabbedPane tabbedGui = new JTabbedPane();
        tabbedGui.addTab("MQTT", this.mqttComp);
        tabbedGui.addTab("Options", this.optionsComp);
        contentPane.add(tabbedGui);
    }

    public void publish(String topic, byte[] message, int qos, boolean retained) throws Exception {
        this.setTitleText("");
        if (this.connected) {
            try {
                this.mqtt.getTopic(topic).publish(message, qos, retained);
            }
            catch (MqttException ex) {
                this.setTitleText("MQTT publish exception !");
                JOptionPane.showMessageDialog(this.frame, ex.getClass().getName() + "\n" + ex.getMessage(), "MQTT Publish Exception", 0);
                throw ex;
            }
        } else {
            this.setTitleText("MQTT client not connected !");
            throw new Exception("MQTT client not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.connected = false;
        Object object = this.connLostWait;
        synchronized (object) {
            this.connLostWait.notify();
        }
        if (this.mqtt != null) {
            try {
                this.mqtt.disconnect();
            }
            catch (Exception ex) {
                this.setTitleText("MQTT disconnect error !");
                ex.printStackTrace();
                System.exit(1);
            }
        }
        if (this.led.isFlashing()) {
            this.led.setFlash();
        }
        this.led.setRed();
        this.setConnected(false);
        object = this;
        synchronized (object) {
            this.writeLogln("WebSphere MQ Telemetry transport disconnected");
        }
    }

    public void connect(String connStr, boolean usePersistence) throws MqttException {
        if (this.mqtt != null && !connStr.equals(this.mqtt.getServerURI())) {
            this.mqtt = null;
        }
        if (this.mqtt == null) {
            MqttDefaultFilePersistence persistence = null;
            if (usePersistence) {
                persistence = new MqttDefaultFilePersistence(this.optionsComp.getPersistenceDirectory());
            }
            this.mqtt = new MqttClient(connStr, this.optionsComp.getClientID(), persistence);
            this.mqtt.setCallback(this);
            if (this.traceEnabled) {
                this.startTrace();
            }
        }
        this.opts = new MqttConnectOptions();
        this.opts.setCleanSession(this.optionsComp.isCleanSessionSelected());
        this.opts.setKeepAliveInterval(this.optionsComp.getKeepAlive());
        if (this.optionsComp.isLWTTopicSet()) {
            this.opts.setWill(this.mqtt.getTopic(this.optionsComp.getLWTTopic()), this.optionsComp.getLWTData().getBytes(), this.optionsComp.getLWTQoS(), this.optionsComp.isLWTRetainSelected());
        }
        this.mqtt.connect(this.opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscription(String topic, int qos, boolean sub) {
        block10: {
            this.setTitleText("");
            if (this.connected) {
                try {
                    String[] theseTopics = new String[1];
                    int[] theseQoS = new int[1];
                    theseTopics[0] = topic;
                    theseQoS[0] = qos;
                    MQTTFrame mQTTFrame = this;
                    synchronized (mQTTFrame) {
                        if (sub) {
                            this.writeLogln("  --> SUBSCRIBE,        TOPIC:" + topic + ", Requested QoS:" + qos);
                        } else {
                            this.writeLogln("  --> UNSUBSCRIBE,      TOPIC:" + topic);
                        }
                    }
                    if (sub) {
                        this.mqtt.subscribe(theseTopics, theseQoS);
                        break block10;
                    }
                    this.mqtt.unsubscribe(theseTopics);
                }
                catch (Exception ex) {
                    this.setTitleText("MQTT subscription exception caught !");
                    JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "MQTT Subscription Exception", 0);
                }
            } else {
                this.setTitleText("MQTT client not connected !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc = -1;
        String ipAddr = (String)this.ipAddress.getSelectedItem();
        String portNum = (String)this.port.getSelectedItem();
        String connStr = "";
        try {
            connStr = ipAddr.indexOf("://") < 0 ? "tcp://" + ipAddr + ":" + portNum : ipAddr;
            this.connect(connStr, this.optionsComp.isPersistenceSelected());
            this.updateComboBoxList(this.ipAddress, ipAddr);
            this.updateComboBoxList(this.port, portNum);
            this.connected = true;
            this.led.setGreen();
            this.setConnected(true);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.frame, "Invalid port number !", "MQTT Connect Exception", 0);
        }
        catch (MqttException mqe) {
            this.setTitleText("MQTT connect failed !");
            Throwable e = mqe.getCause();
            String msg = "";
            if (e == null) {
                e = mqe;
            } else if (mqe.getMessage() != null) {
                msg = msg + mqe.getMessage() + "\n";
            }
            msg = msg + e;
            JOptionPane.showMessageDialog(this.frame, msg, "MQTT Connect Exception", 0);
            e.printStackTrace();
        }
        catch (Exception ex) {
            this.setTitleText("MQTT connect failed !");
            JOptionPane.showMessageDialog(this.frame, ex, "MQTT Connect Exception", 0);
            ex.printStackTrace();
        }
        if (!this.connected) {
            this.led.setRed();
            this.setConnected(false);
        }
        MQTTFrame mQTTFrame = this;
        synchronized (mQTTFrame) {
            if (this.connected) {
                this.writeLogln("WebSphere MQ Telemetry transport connected to " + this.mqtt.getServerURI());
            } else {
                this.writeLogln("ERROR:WebSphere MQ Telemetry transport failed to connect to " + connStr);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setTitleText("");
        if (e.getActionCommand().equals("Connect")) {
            if (this.connected) {
                this.setTitleText("MQTT session already active !");
            } else {
                this.connect.setEnabled(false);
                this.led.setAmber();
                this.connected = false;
                new Thread(this).start();
            }
        } else if (e.getActionCommand().equals("Disconnect")) {
            if (this.connected) {
                this.disconnect();
            } else {
                this.setTitleText("MQTT client not connected !");
            }
        } else if (e.getActionCommand().equals("History")) {
            this.historyComp.enableHistory();
        }
    }

    public synchronized void setTitleText(String extraText) {
        if (extraText.equals("")) {
            this.frame.setTitle("Paho MQTT Utility");
        } else {
            this.frame.setTitle("Paho MQTT Utility - " + extraText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionLost(Throwable cause) {
        int rc = -1;
        this.led.setAmber();
        this.led.setFlash();
        this.setTitleText("Connection Lost!....Reconnecting");
        Object object = this;
        synchronized (object) {
            this.writeLogln("MQTT Connection Lost!....Reconnecting to " + this.mqtt.getServerURI());
        }
        try {
            while (rc == -1 && this.connected) {
                try {
                    object = this.connLostWait;
                    synchronized (object) {
                        this.connLostWait.wait(10000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                object = this;
                synchronized (object) {
                    if (this.connected) {
                        this.writeLog("MQTT reconnecting......");
                        try {
                            this.connect(this.mqtt.getServerURI(), this.optionsComp.isPersistenceSelected());
                            rc = 0;
                        }
                        catch (MqttException mqte) {
                            rc = -1;
                        }
                        if (rc == -1) {
                            this.writeLogln("failed");
                        } else {
                            this.writeLogln("success !");
                        }
                    }
                }
            }
            this.setTitleText("");
        }
        catch (Exception ex) {
            this.setTitleText("MQTT connection broken !");
            ex.printStackTrace();
            this.disconnect();
        }
        finally {
            if (this.led.isFlashing()) {
                this.led.setFlash();
            }
        }
        if (this.connected) {
            this.led.setGreen();
            this.setConnected(true);
        } else {
            this.led.setRed();
            this.setConnected(false);
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        try {
            this.subPanelContr.updateReceivedData(topic, message.getPayload(), message.getQos(), message.isRetained());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public void updateSubscribeTopicList(String topicName) {
        this.subPanelContr.updateTopicList(topicName);
    }

    public void updatePublishTopicList(String topicName) {
        this.pubPanelContr.updateTopicList(topicName);
    }

    public boolean updateComboBoxList(JComboBox list, String itemName) {
        int listCount = list.getItemCount();
        boolean found = false;
        if (itemName == null) {
            return false;
        }
        for (int i = 0; i < listCount; ++i) {
            if (!((String)list.getItemAt(i)).equals(itemName)) continue;
            found = true;
            break;
        }
        if (!found) {
            list.addItem(itemName);
            return true;
        }
        return false;
    }

    public void startTrace() throws MqttException {
        this.traceEnabled = true;
    }

    public void stopTrace() {
        this.traceEnabled = false;
        if (this.mqtt != null) {
            JOptionPane.showMessageDialog(this.frame, "Trace file mqe0.trc generated in the current directory", "MQTT Trace", 1);
        }
    }

    public void writeLogln(String logdata) {
        this.writeLog(logdata + System.getProperty("line.separator"));
    }

    public void writeLog(String logdata) {
        if (this.historyComp != null) {
            try {
                this.historyComp.write(logdata);
            }
            catch (Exception e) {
                this.setTitleText("Log write failed!");
            }
        }
    }

    public void getProperties(Properties props, JComboBox comp, String key, String defValue) {
        String parms = props.getProperty(key, defValue);
        StringTokenizer st = new StringTokenizer(parms, PROP_DELIM);
        while (st.hasMoreTokens()) {
            comp.addItem(st.nextToken());
        }
    }

    public String constructPropertyValue(String prop) {
        String retString = null;
        if (prop.equals("IPAddressList")) {
            int numAddrs = this.ipAddress.getItemCount();
            retString = numAddrs > 0 ? "" : DEFAULT_IP_ADDRESS;
            for (int i = 0; i < numAddrs; ++i) {
                retString = retString + this.ipAddress.getItemAt(i);
                if (i == numAddrs - 1) continue;
                retString = retString + PROP_DELIM;
            }
        } else if (prop.equals("IPPortList")) {
            int numPorts = this.port.getItemCount();
            retString = numPorts > 0 ? "" : DEFAULT_PORT_NUMBER;
            for (int i = 0; i < numPorts; ++i) {
                retString = retString + this.port.getItemAt(i);
                if (i == numPorts - 1) continue;
                retString = retString + PROP_DELIM;
            }
        } else if (prop.equals("ClientId")) {
            retString = this.optionsComp.getClientID();
        } else if (prop.equals("Persistence")) {
            retString = String.valueOf(this.optionsComp.isPersistenceSelected());
        } else if (prop.equals("PersistenceDir")) {
            retString = this.optionsComp.getPersistenceDirectory();
        }
        return retString;
    }

    private void setConnected(boolean b) {
        this.pubPanelContr.enableButtons(b);
        this.subPanelContr.enableButtons(b);
        this.disconnect.setEnabled(b);
        this.connect.setEnabled(!b);
    }
}

