/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.signature;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.eclipse.packager.rpm.HashAlgorithm;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.signature.SignatureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaHeaderSignatureProcessor
implements SignatureProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RsaHeaderSignatureProcessor.class);
    private final PGPPrivateKey privateKey;
    private final int hashAlgorithm;
    private byte[] value;

    protected RsaHeaderSignatureProcessor(PGPPrivateKey privateKey, int hashAlgorithm) {
        Objects.requireNonNull(privateKey);
        this.privateKey = privateKey;
        this.hashAlgorithm = hashAlgorithm;
    }

    public RsaHeaderSignatureProcessor(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm) {
        this(privateKey, Objects.requireNonNull(hashAlgorithm).getValue());
    }

    public RsaHeaderSignatureProcessor(PGPPrivateKey privateKey) {
        this(privateKey, 2);
    }

    @Override
    public void feedHeader(ByteBuffer header) {
        try {
            BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(this.privateKey.getPublicKeyPacket().getAlgorithm(), this.hashAlgorithm);
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
            signatureGenerator.init(0, this.privateKey);
            if (header.hasArray()) {
                signatureGenerator.update(header.array(), header.position(), header.remaining());
            } else {
                byte[] buffer = new byte[header.remaining()];
                header.get(buffer);
                signatureGenerator.update(buffer);
            }
            this.value = signatureGenerator.generate().getEncoded();
            logger.info("RSA HEADER: {}", (Object)this.value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void feedPayloadData(ByteBuffer data) {
    }

    @Override
    public void finish(Header<RpmSignatureTag> signature) {
        signature.putBlob(RpmSignatureTag.RSAHEADER, this.value);
    }
}

