/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Map;

public class ChecksumInputStream
extends FilterInputStream {
    private final MessageDigest[] digests;
    private final Map<String, byte[]> results;

    public ChecksumInputStream(InputStream stream, Map<String, byte[]> results, MessageDigest ... digests) {
        super(stream);
        this.digests = digests;
        this.results = results;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            for (MessageDigest d : this.digests) {
                d.update(b, off, result);
            }
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result > 0) {
            for (MessageDigest d : this.digests) {
                d.update((byte)result);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (MessageDigest d : this.digests) {
            byte[] result = d.digest();
            this.results.put(d.getAlgorithm(), result);
        }
    }

    public Map<String, byte[]> getResults() {
        return this.results;
    }
}

