/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.toolkit;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class TestResources {
    public static String load(Class<?> relativeToClass, String path) {
        try {
            URL url = relativeToClass.getResource(path);
            Objects.requireNonNull(url, String.format("Resource %s not found relative to %s", path, relativeToClass.getName()));
            return TestResources.convertToUnixLineEndings(Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertToUnixLineEndings(String resource) {
        return resource.replaceAll("\\r\\n?", "\n");
    }
}

