/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.toolkit;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class TimeoutActionRule
implements TestRule {
    private Duration timeoutDuration;

    public TimeoutActionRule(Duration timeoutDuration) {
        this.timeoutDuration = Objects.requireNonNull(timeoutDuration, "Must specify a timeout duration");
        Preconditions.checkArgument((timeoutDuration.toMillis() > 100L ? 1 : 0) != 0, (Object)"Timeout must be > 100ms");
    }

    protected abstract void performAction();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Timer timer = new Timer(true);
                try {
                    timer.schedule(TimeoutActionRule.this.createActionTask(), TimeoutActionRule.this.timeoutDuration.toMillis(), TimeoutActionRule.this.timeoutDuration.toMillis());
                    base.evaluate();
                }
                finally {
                    timer.cancel();
                }
            }
        };
    }

    TimerTask createActionTask() {
        return new TimerTask(){

            @Override
            public void run() {
                TimeoutActionRule.this.performAction();
            }
        };
    }
}

